/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.util.Map;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.geospatial.GeospatialParser;
import org.opensearch.geospatial.action.upload.geojson.ContentBuilder;
import org.opensearch.geospatial.action.upload.geojson.IndexManager;
import org.opensearch.geospatial.action.upload.geojson.PipelineManager;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONRequest;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONRequestContent;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONResponse;
import org.opensearch.geospatial.action.upload.geojson.Uploader;
import org.opensearch.geospatial.stats.upload.UploadStats;
import org.opensearch.rest.RestRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class UploadGeoJSONTransportAction
extends HandledTransportAction<UploadGeoJSONRequest, UploadGeoJSONResponse> {
    private final ClusterService clusterService;
    private final Client client;

    @Inject
    public UploadGeoJSONTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/upload_geojson_action", transportService, actionFilters, UploadGeoJSONRequest::new);
        this.clusterService = clusterService;
        this.client = client;
    }

    protected void doExecute(Task task, UploadGeoJSONRequest request, ActionListener<UploadGeoJSONResponse> actionListener) {
        UploadStats.getInstance().incrementAPICount();
        Map<String, Object> contentAsMap = GeospatialParser.convertToMap(request.getContent());
        UploadGeoJSONRequestContent content = UploadGeoJSONRequestContent.create(contentAsMap);
        boolean failIfIndexExist = this.shouldFailIfIndexExist(request.getMethod());
        boolean indexExists = this.clusterService.state().getRoutingTable().hasIndex(content.getIndexName());
        if (indexExists && failIfIndexExist) {
            throw new ResourceAlreadyExistsException(content.getIndexName(), new Object[0]);
        }
        IndexManager indexManager = new IndexManager(this.client.admin().indices());
        PipelineManager pipelineManager = new PipelineManager(this.client.admin().cluster());
        ContentBuilder contentBuilder = new ContentBuilder(this.client);
        new Uploader(indexManager, pipelineManager, contentBuilder).upload(content, indexExists, actionListener);
    }

    private boolean shouldFailIfIndexExist(RestRequest.Method method) {
        return RestRequest.Method.POST.equals((Object)method);
    }
}

