/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.opensearch.performanceanalyzer.decisionmaker.actions.AdmissionControlAction;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decider;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decision;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.store.rca.admissioncontrol.AdmissionControlClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class AdmissionControlDecider
extends Decider {
    private int counter = 0;
    private static final String NAME = "admissionControlDecider";
    private final AdmissionControlClusterRca admissionControlClusterRca;

    public AdmissionControlDecider(long evalIntervalSeconds, int decisionFrequency, AdmissionControlClusterRca admissionControlClusterRca) {
        super(evalIntervalSeconds, decisionFrequency);
        this.admissionControlClusterRca = admissionControlClusterRca;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Decision operate() {
        Decision decision = new Decision(Instant.now().toEpochMilli(), NAME);
        ++this.counter;
        if (this.counter < this.decisionFrequency) {
            return decision;
        }
        this.counter = 0;
        List<AdmissionControlAction> heapBasedActions = this.getHeapBasedActions();
        heapBasedActions.stream().max(Comparator.comparingDouble(AdmissionControlAction::getDesiredValue)).ifPresent(decision::addAction);
        return decision;
    }

    private List<AdmissionControlAction> getHeapBasedActions() {
        ArrayList<AdmissionControlAction> heapBasedActions = new ArrayList<AdmissionControlAction>();
        if (this.admissionControlClusterRca.getFlowUnits().isEmpty()) {
            return heapBasedActions;
        }
        ResourceFlowUnit flowUnit = (ResourceFlowUnit)this.admissionControlClusterRca.getFlowUnits().get(0);
        if (!flowUnit.hasResourceSummary()) {
            return heapBasedActions;
        }
        HotClusterSummary clusterSummary = (HotClusterSummary)flowUnit.getSummary();
        clusterSummary.getHotNodeSummaryList().forEach(nodeSummary -> nodeSummary.getHotResourceSummaryList().stream().filter(this::isHeapResource).map(resourceSummary -> this.getAction((HotNodeSummary)nodeSummary, (HotResourceSummary)resourceSummary)).filter(Objects::nonNull).forEach(heapBasedActions::add));
        return heapBasedActions;
    }

    private boolean isHeapResource(HotResourceSummary hotResourceSummary) {
        return hotResourceSummary.getResource().getResourceEnum() == ResourceEnum.HEAP;
    }

    private AdmissionControlAction getAction(HotNodeSummary hotNodeSummary, HotResourceSummary hotResourceSummary) {
        double currentThreshold = hotResourceSummary.getValue();
        double desiredThreshold = hotResourceSummary.getThreshold();
        NodeKey esNode = new NodeKey(hotNodeSummary.getNodeID(), hotNodeSummary.getHostAddress());
        AdmissionControlAction action = AdmissionControlAction.newBuilder(esNode, "Request_Size", this.getAppContext(), this.rcaConf).currentValue(currentThreshold).desiredValue(desiredThreshold).build();
        return action.isActionable() ? action : null;
    }
}

