/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm;

import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelOneActionBuilderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelThreeActionBuilderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelTwoActionBuilderConfig;
import org.opensearch.performanceanalyzer.rca.framework.core.Config;
import org.opensearch.performanceanalyzer.rca.framework.core.NestedConfig;

public class OldGenDecisionPolicyConfig {
    private static final String QUEUE_BUCKET_SIZE_CONFIG_NAME = "queue-bucket-size";
    private static final String LEVEL_ONE_CONFIG_NAME = "level-one-config";
    private static final String LEVEL_TWO_CONFIG_NAME = "level-two-config";
    private static final String LEVEL_THREE_CONFIG_NAME = "level-three-config";
    private static final String OLD_GEN_THRESHOLD_LEVEL_ONE_CONFIG_NAME = "old-gen-threshold-level-one";
    private static final String OLD_GEN_THRESHOLD_LEVEL_TWO_CONFIG_NAME = "old-gen-threshold-level-two";
    private static final String OLD_GEN_THRESHOLD_LEVEL_THREE_CONFIG_NAME = "old-gen-threshold-level-three";
    public static final int DEFAULT_QUEUE_BUCKET_SIZE = 10;
    public static final double DEFAULT_OLD_GEN_THRESHOLD_LEVEL_ONE = 0.6;
    public static final double DEFAULT_OLD_GEN_THRESHOLD_LEVEL_TWO = 0.75;
    public static final double DEFAULT_OLD_GEN_THRESHOLD_LEVEL_THREE = 0.9;
    private final LevelOneActionBuilderConfig levelOneActionBuilderConfig;
    private final LevelTwoActionBuilderConfig levelTwoActionBuilderConfig;
    private final LevelThreeActionBuilderConfig levelThreeActionBuilderConfig;
    private Config<Double> oldGenThresholdLevelOne;
    private Config<Double> oldGenThresholdLevelTwo;
    private Config<Double> oldGenThresholdLevelThree;
    private Config<Integer> queueBucketSize;

    public OldGenDecisionPolicyConfig(NestedConfig oldGenConfig) {
        this.levelOneActionBuilderConfig = new LevelOneActionBuilderConfig(new NestedConfig(LEVEL_ONE_CONFIG_NAME, oldGenConfig.getValue()));
        this.levelTwoActionBuilderConfig = new LevelTwoActionBuilderConfig(new NestedConfig(LEVEL_TWO_CONFIG_NAME, oldGenConfig.getValue()));
        this.levelThreeActionBuilderConfig = new LevelThreeActionBuilderConfig(new NestedConfig(LEVEL_THREE_CONFIG_NAME, oldGenConfig.getValue()));
        this.oldGenThresholdLevelOne = new Config<Double>(OLD_GEN_THRESHOLD_LEVEL_ONE_CONFIG_NAME, oldGenConfig.getValue(), 0.6, s -> s > 0.0, Double.class);
        this.oldGenThresholdLevelTwo = new Config<Double>(OLD_GEN_THRESHOLD_LEVEL_TWO_CONFIG_NAME, oldGenConfig.getValue(), 0.75, s -> s > this.oldGenThresholdLevelOne.getValue(), Double.class);
        this.oldGenThresholdLevelThree = new Config<Double>(OLD_GEN_THRESHOLD_LEVEL_THREE_CONFIG_NAME, oldGenConfig.getValue(), 0.9, s -> s > this.oldGenThresholdLevelTwo.getValue(), Double.class);
        this.queueBucketSize = new Config<Integer>(QUEUE_BUCKET_SIZE_CONFIG_NAME, oldGenConfig.getValue(), 10, s -> s > 0, Integer.class);
    }

    public LevelOneActionBuilderConfig levelOneActionBuilderConfig() {
        return this.levelOneActionBuilderConfig;
    }

    public LevelTwoActionBuilderConfig levelTwoActionBuilderConfig() {
        return this.levelTwoActionBuilderConfig;
    }

    public LevelThreeActionBuilderConfig levelThreeActionBuilderConfig() {
        return this.levelThreeActionBuilderConfig;
    }

    public double oldGenThresholdLevelOne() {
        return this.oldGenThresholdLevelOne.getValue();
    }

    public double oldGenThresholdLevelTwo() {
        return this.oldGenThresholdLevelTwo.getValue();
    }

    public double oldGenThresholdLevelThree() {
        return this.oldGenThresholdLevelThree.getValue();
    }

    public int queueBucketSize() {
        return this.queueBucketSize.getValue();
    }
}

