/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm;

import java.util.List;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decider;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decision;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.JvmGenTuningPolicy;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.OldGenDecisionPolicy;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.sizing.HeapSizeIncreasePolicy;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing.LargeHeapClusterRca;

public class HeapHealthDecider
extends Decider {
    private static final int EVAL_INTERVAL_IN_S = 5;
    public static final String NAME = "HeapHealthDecider";
    private final OldGenDecisionPolicy oldGenDecisionPolicy;
    private final JvmGenTuningPolicy jvmGenTuningPolicy;
    private final HeapSizeIncreasePolicy heapSizeIncreasePolicy;
    private int counter = 0;

    public HeapHealthDecider(int decisionFrequency, HighHeapUsageClusterRca highHeapUsageClusterRca, LargeHeapClusterRca largeHeapClusterRca) {
        super(5L, decisionFrequency);
        this.oldGenDecisionPolicy = new OldGenDecisionPolicy(highHeapUsageClusterRca);
        this.jvmGenTuningPolicy = new JvmGenTuningPolicy(highHeapUsageClusterRca);
        this.heapSizeIncreasePolicy = new HeapSizeIncreasePolicy(largeHeapClusterRca);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Decision operate() {
        Decision decision = new Decision(System.currentTimeMillis(), NAME);
        ++this.counter;
        if (this.counter < this.decisionFrequency) {
            return decision;
        }
        this.counter = 0;
        List<Action> oldGenPolicyActions = this.oldGenDecisionPolicy.evaluate();
        oldGenPolicyActions.forEach(decision::addAction);
        List<Action> jvmScaleUpActions = this.heapSizeIncreasePolicy.evaluate();
        jvmScaleUpActions.forEach(decision::addAction);
        if (jvmScaleUpActions == null || jvmScaleUpActions.isEmpty()) {
            List<Action> jvmGenTuningActions = this.jvmGenTuningPolicy.evaluate();
            jvmGenTuningActions.forEach(decision::addAction);
        }
        return decision;
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        super.readRcaConf(conf);
        this.oldGenDecisionPolicy.setRcaConf(conf);
        this.jvmGenTuningPolicy.setRcaConf(conf);
        this.heapSizeIncreasePolicy.setRcaConf(conf);
    }

    @Override
    public void setAppContext(AppContext appContext) {
        super.setAppContext(appContext);
        this.oldGenDecisionPolicy.setAppContext(appContext);
        this.jvmGenTuningPolicy.setAppContext(appContext);
        this.heapSizeIncreasePolicy.setAppContext(appContext);
    }
}

