/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.persist;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataTypeException;

public class SQLParsingUtil {
    private static final Logger LOG = LogManager.getLogger(SQLParsingUtil.class);

    private static Record getRecordByName(Result<Record> result, Field<String> field, String name) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException("getRecordByName called with null result");
        }
        int idx = -1;
        List fieldNames = result.getValues(field);
        for (int i = 0; i < fieldNames.size(); ++i) {
            if (!((String)fieldNames.get(i)).equals(name)) continue;
            idx = i;
            break;
        }
        if (idx < 0) {
            throw new IllegalArgumentException();
        }
        return (Record)result.get(idx);
    }

    public static double readDataFromSqlResult(Result<Record> result, Field<String> matchedField, String matchedFieldName, String dataField) {
        double ret = Double.NaN;
        try {
            Record record = SQLParsingUtil.getRecordByName(result, matchedField, matchedFieldName);
            ret = (Double)record.getValue(dataField, Double.class);
        }
        catch (IllegalArgumentException ie) {
            LOG.error("{} fails to match any row in field {}.", (Object)matchedFieldName, (Object)matchedField.getName());
        }
        catch (DataTypeException de) {
            LOG.error("Fail to read {} field from SQL result", (Object)dataField);
        }
        return ret;
    }
}

