/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.sql.Connection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.commons.event_process.Event;
import org.opensearch.performanceanalyzer.commons.event_process.EventProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.util.JsonConverter;
import org.opensearch.performanceanalyzer.reader.GarbageCollectorInfoSnapshot;

public class GarbageCollectorInfoProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(GarbageCollectorInfoProcessor.class);
    private GarbageCollectorInfoSnapshot gcSnap;
    private BatchBindStep handle;
    private long startTime;
    private long endTime;

    private GarbageCollectorInfoProcessor(GarbageCollectorInfoSnapshot gcSnap) {
        this.gcSnap = gcSnap;
    }

    static GarbageCollectorInfoProcessor buildGarbageCollectorInfoProcessor(long currWindowStartTime, Connection conn, NavigableMap<Long, GarbageCollectorInfoSnapshot> gcInfoMap) {
        if (gcInfoMap.get(currWindowStartTime) == null) {
            GarbageCollectorInfoSnapshot gcSnap = new GarbageCollectorInfoSnapshot(conn, currWindowStartTime);
            gcInfoMap.put(currWindowStartTime, gcSnap);
            return new GarbageCollectorInfoProcessor(gcSnap);
        }
        return new GarbageCollectorInfoProcessor((GarbageCollectorInfoSnapshot)gcInfoMap.get(currWindowStartTime));
    }

    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.handle = this.gcSnap.startBatchPut();
    }

    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
    }

    public void processEvent(Event event) {
        this.handleGarbageCollectorInfoEvent(event);
        this.commitBatchIfRequired();
    }

    private void handleGarbageCollectorInfoEvent(Event event) {
        String[] lines = event.value.split(System.getProperty("line.separator"));
        for (int i = 1; i < lines.length; ++i) {
            this.parseJsonLine(lines[i]);
        }
    }

    private void parseJsonLine(String jsonString) {
        Map map = JsonConverter.createMapFrom((String)jsonString);
        if (map.isEmpty()) {
            LOG.warn("Empty line in the event log for gc_info section.");
            return;
        }
        AllMetrics.GCInfoDimension[] dims = AllMetrics.GCInfoDimension.values();
        Object[] bindVals = new Object[dims.length];
        int idx = 0;
        for (AllMetrics.GCInfoDimension dimension : dims) {
            bindVals[idx++] = map.get(dimension.toString());
        }
        this.handle.bind(bindVals);
    }

    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("gc_info");
    }

    public void commitBatchIfRequired() {
        if (this.handle.size() >= 500) {
            this.handle.execute();
            this.handle = this.gcSnap.startBatchPut();
        }
    }
}

