/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.performanceanalyzer.commons.event_process.Event;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricDimension;
import org.opensearch.performanceanalyzer.commons.metrics.MetricValue;
import org.opensearch.performanceanalyzer.reader.FileHandler;
import org.opensearch.performanceanalyzer.reader.MetricProperties;

public final class MetricPropertiesConfig {
    private final Map<AllMetrics.MetricName, MetricProperties> metricName2Property;
    private static final MetricPropertiesConfig INSTANCE = new MetricPropertiesConfig();
    private Map<AllMetrics.MetricName, String> metricPathMap = new HashMap<AllMetrics.MetricName, String>();
    private Map<String, AllMetrics.MetricName> eventKeyToMetricNameMap;

    static FileHandler createFileHandler(final String ... metricPathElements) {
        return new FileHandler(){

            @Override
            public List<File> findFiles4Metric(long startTimeThirtySecondBucket) {
                ArrayList<File> ret = new ArrayList<File>(1);
                StringBuilder sb = new StringBuilder();
                sb.append(this.getRootLocation());
                sb.append(startTimeThirtySecondBucket);
                for (String element : metricPathElements) {
                    sb.append(File.separator);
                    sb.append(element);
                }
                File metricFile = new File(sb.toString());
                if (metricFile.exists()) {
                    ret.add(metricFile);
                }
                return ret;
            }

            @Override
            public List<Event> getMetricData(Map<String, List<Event>> metricDataMap) {
                Objects.requireNonNull(metricDataMap);
                List<Event> entries = metricDataMap.get(metricPathElements[0]);
                return entries == null ? Collections.emptyList() : entries;
            }
        };
    }

    private MetricPropertiesConfig() {
        this.metricPathMap.put(AllMetrics.MetricName.CACHE_CONFIG, "cache_config");
        this.metricPathMap.put(AllMetrics.MetricName.CIRCUIT_BREAKER, "circuit_breaker");
        this.metricPathMap.put(AllMetrics.MetricName.HEAP_METRICS, "heap_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.DISK_METRICS, "disk_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.TCP_METRICS, "tcp_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.IP_METRICS, "ip_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.THREAD_POOL, "thread_pool");
        this.metricPathMap.put(AllMetrics.MetricName.SHARD_STATS, "indices");
        this.metricPathMap.put(AllMetrics.MetricName.CLUSTER_MANAGER_PENDING, "pending_tasks");
        this.metricPathMap.put(AllMetrics.MetricName.MOUNTED_PARTITION_METRICS, "mounted_part_space");
        this.metricPathMap.put(AllMetrics.MetricName.CLUSTER_APPLIER_SERVICE, "cluster_applier_service");
        this.metricPathMap.put(AllMetrics.MetricName.ELECTION_TERM, "election_term");
        this.metricPathMap.put(AllMetrics.MetricName.ADMISSION_CONTROL_METRICS, "admission_control_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.SHARD_INDEXING_PRESSURE, "shard_indexing_pressure_metrics");
        this.metricPathMap.put(AllMetrics.MetricName.CLUSTER_MANAGER_CLUSTER_UPDATE_STATS, "cluster_manager_cluster_update");
        this.eventKeyToMetricNameMap = new HashMap<String, AllMetrics.MetricName>();
        this.eventKeyToMetricNameMap.put("cache_config", AllMetrics.MetricName.CACHE_CONFIG);
        this.eventKeyToMetricNameMap.put("circuit_breaker", AllMetrics.MetricName.CIRCUIT_BREAKER);
        this.eventKeyToMetricNameMap.put("heap_metrics", AllMetrics.MetricName.HEAP_METRICS);
        this.eventKeyToMetricNameMap.put("disk_metrics", AllMetrics.MetricName.DISK_METRICS);
        this.eventKeyToMetricNameMap.put("tcp_metrics", AllMetrics.MetricName.TCP_METRICS);
        this.eventKeyToMetricNameMap.put("ip_metrics", AllMetrics.MetricName.IP_METRICS);
        this.eventKeyToMetricNameMap.put("thread_pool", AllMetrics.MetricName.THREAD_POOL);
        this.eventKeyToMetricNameMap.put("indices", AllMetrics.MetricName.SHARD_STATS);
        this.eventKeyToMetricNameMap.put("pending_tasks", AllMetrics.MetricName.CLUSTER_MANAGER_PENDING);
        this.eventKeyToMetricNameMap.put("mounted_part_space", AllMetrics.MetricName.MOUNTED_PARTITION_METRICS);
        this.eventKeyToMetricNameMap.put("cluster_manager_cluster_update", AllMetrics.MetricName.CLUSTER_MANAGER_CLUSTER_UPDATE_STATS);
        this.eventKeyToMetricNameMap.put("cluster_applier_service", AllMetrics.MetricName.CLUSTER_APPLIER_SERVICE);
        this.eventKeyToMetricNameMap.put("election_term", AllMetrics.MetricName.ELECTION_TERM);
        this.eventKeyToMetricNameMap.put("admission_control_metrics", AllMetrics.MetricName.ADMISSION_CONTROL_METRICS);
        this.eventKeyToMetricNameMap.put("shard_indexing_pressure_metrics", AllMetrics.MetricName.SHARD_INDEXING_PRESSURE);
        this.metricName2Property = new HashMap<AllMetrics.MetricName, MetricProperties>();
        this.metricName2Property.put(AllMetrics.MetricName.CACHE_CONFIG, new MetricProperties((MetricDimension[])AllMetrics.CacheConfigDimension.values(), (MetricValue[])AllMetrics.CacheConfigValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.CACHE_CONFIG))));
        this.metricName2Property.put(AllMetrics.MetricName.CIRCUIT_BREAKER, new MetricProperties((MetricDimension[])AllMetrics.CircuitBreakerDimension.values(), (MetricValue[])AllMetrics.CircuitBreakerValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.CIRCUIT_BREAKER))));
        this.metricName2Property.put(AllMetrics.MetricName.HEAP_METRICS, new MetricProperties((MetricDimension[])AllMetrics.HeapDimension.values(), (MetricValue[])AllMetrics.HeapValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.HEAP_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.DISK_METRICS, new MetricProperties((MetricDimension[])AllMetrics.DiskDimension.values(), (MetricValue[])AllMetrics.DiskValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.DISK_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.TCP_METRICS, new MetricProperties((MetricDimension[])AllMetrics.TCPDimension.values(), (MetricValue[])AllMetrics.TCPValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.TCP_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.IP_METRICS, new MetricProperties((MetricDimension[])AllMetrics.IPDimension.values(), (MetricValue[])AllMetrics.IPValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.IP_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.THREAD_POOL, new MetricProperties((MetricDimension[])AllMetrics.ThreadPoolDimension.values(), (MetricValue[])AllMetrics.ThreadPoolValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.THREAD_POOL))));
        this.metricName2Property.put(AllMetrics.MetricName.SHARD_STATS, new MetricProperties((MetricDimension[])AllMetrics.ShardStatsDerivedDimension.values(), MetricProperties.EMPTY_DIMENSION, (MetricValue[])AllMetrics.ShardStatsValue.values(), new ShardStatFileHandler()));
        this.metricName2Property.put(AllMetrics.MetricName.CLUSTER_MANAGER_PENDING, new MetricProperties((MetricDimension[])AllMetrics.ClusterManagerPendingTaskDimension.values(), (MetricValue[])AllMetrics.ClusterManagerPendingValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.CLUSTER_MANAGER_PENDING), "current", "metadata")));
        this.metricName2Property.put(AllMetrics.MetricName.MOUNTED_PARTITION_METRICS, new MetricProperties((MetricDimension[])AllMetrics.DevicePartitionDimension.values(), (MetricValue[])AllMetrics.DevicePartitionValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.MOUNTED_PARTITION_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.CLUSTER_APPLIER_SERVICE, new MetricProperties(MetricProperties.EMPTY_DIMENSION, (MetricValue[])AllMetrics.ClusterApplierServiceStatsValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.CLUSTER_APPLIER_SERVICE))));
        this.metricName2Property.put(AllMetrics.MetricName.ELECTION_TERM, new MetricProperties(MetricProperties.EMPTY_DIMENSION, (MetricValue[])AllMetrics.ElectionTermValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.ELECTION_TERM))));
        this.metricName2Property.put(AllMetrics.MetricName.ADMISSION_CONTROL_METRICS, new MetricProperties((MetricDimension[])AllMetrics.AdmissionControlDimension.values(), (MetricValue[])AllMetrics.AdmissionControlValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.ADMISSION_CONTROL_METRICS))));
        this.metricName2Property.put(AllMetrics.MetricName.SHARD_INDEXING_PRESSURE, new MetricProperties((MetricDimension[])AllMetrics.ShardIndexingPressureDimension.values(), (MetricValue[])AllMetrics.ShardIndexingPressureValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.SHARD_INDEXING_PRESSURE))));
        this.metricName2Property.put(AllMetrics.MetricName.CLUSTER_MANAGER_CLUSTER_UPDATE_STATS, new MetricProperties(MetricProperties.EMPTY_DIMENSION, (MetricValue[])AllMetrics.ClusterManagerClusterUpdateStatsValue.values(), MetricPropertiesConfig.createFileHandler(this.metricPathMap.get(AllMetrics.MetricName.CLUSTER_MANAGER_CLUSTER_UPDATE_STATS))));
    }

    public static MetricPropertiesConfig getInstance() {
        return INSTANCE;
    }

    public MetricProperties getProperty(AllMetrics.MetricName name) {
        return this.metricName2Property.get(name);
    }

    public Map<AllMetrics.MetricName, String> getMetricPathMap() {
        return this.metricPathMap;
    }

    Map<String, AllMetrics.MetricName> getEventKeyToMetricNameMap() {
        return this.eventKeyToMetricNameMap;
    }

    @VisibleForTesting
    Map<AllMetrics.MetricName, MetricProperties> getMetricName2Property() {
        return this.metricName2Property;
    }

    public static class ShardStatFileHandler
    extends FileHandler {
        @Override
        public List<File> findFiles4Metric(long timeBucket) {
            File indicesFolder = new File(this.getRootLocation() + File.separator + timeBucket + File.separator + "indices");
            if (!indicesFolder.exists()) {
                return Collections.emptyList();
            }
            ArrayList<File> metricFiles = new ArrayList<File>();
            File[] files = indicesFolder.listFiles();
            if (files != null) {
                for (File indexFolder : files) {
                    File[] shardIdFiles;
                    if (indexFolder == null || (shardIdFiles = indexFolder.listFiles()) == null) continue;
                    for (File shardIdFile : shardIdFiles) {
                        metricFiles.add(shardIdFile);
                    }
                }
            }
            return metricFiles;
        }

        @Override
        public List<Event> getMetricData(Map<String, List<Event>> metricDataMap) {
            Objects.requireNonNull(metricDataMap);
            return metricDataMap.computeIfAbsent("indices", k -> Collections.emptyList());
        }

        @Override
        public String filePathRegex() {
            return this.getRootLocation() + File.separator + "?\\d+" + File.separator + "indices" + File.separator + "(.*)" + File.separator + "(\\d+)";
        }
    }
}

