/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.sql.common.utils.URIValidationUtils;

public final class DatasourceValidationUtils {
    public static final int MAX_LENGTH_FOR_CONFIG_PROPERTY = 1000;

    public static void validateHost(String uriString, List<String> denyHostList) throws URISyntaxException, UnknownHostException {
        if (!URIValidationUtils.validateURIHost((String)new URI(uriString).getHost(), denyHostList)) {
            throw new IllegalArgumentException("Disallowed hostname in the uri. Validate with plugins.query.datasources.uri.hosts.denylist config");
        }
    }

    public static void validateLengthAndRequiredFields(Map<String, String> config, Set<String> fields) {
        HashSet<String> missingFields = new HashSet<String>();
        HashSet<String> invalidLengthFields = new HashSet<String>();
        for (String field : fields) {
            if (!config.containsKey(field)) {
                missingFields.add(field);
                continue;
            }
            if (config.get(field).length() <= 1000) continue;
            invalidLengthFields.add(field);
        }
        StringBuilder errorStringBuilder = new StringBuilder();
        if (missingFields.size() > 0) {
            errorStringBuilder.append(String.format("Missing %s fields in the connector properties.", missingFields));
        }
        if (invalidLengthFields.size() > 0) {
            errorStringBuilder.append(String.format("Fields %s exceeds more than 1000 characters.", invalidLengthFields));
        }
        if (errorStringBuilder.length() > 0) {
            throw new IllegalArgumentException(errorStringBuilder.toString());
        }
    }

    @Generated
    private DatasourceValidationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

