/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;

public final class XContentParserUtils {
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String CONNECTOR_FIELD = "connector";
    public static final String PROPERTIES_FIELD = "properties";
    public static final String ALLOWED_ROLES_FIELD = "allowedRoles";
    public static final String RESULT_INDEX_FIELD = "resultIndex";

    public static DataSourceMetadata toDataSourceMetadata(XContentParser parser) throws IOException {
        String name = null;
        String description = "";
        DataSourceType connector = null;
        ArrayList<String> allowedRoles = new ArrayList<String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        String resultIndex = null;
        org.opensearch.core.xcontent.XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.textOrNull();
                    continue block16;
                }
                case "description": {
                    description = parser.textOrNull();
                    continue block16;
                }
                case "connector": {
                    connector = DataSourceType.fromString((String)parser.textOrNull());
                    continue block16;
                }
                case "allowedRoles": {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        allowedRoles.add(parser.text());
                    }
                    continue block16;
                }
                case "properties": {
                    org.opensearch.core.xcontent.XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String key = parser.currentName();
                        parser.nextToken();
                        String value = parser.textOrNull();
                        properties.put(key, value);
                    }
                    continue block16;
                }
                case "resultIndex": {
                    resultIndex = parser.textOrNull();
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        if (name == null || connector == null) {
            throw new IllegalArgumentException("name and connector are required fields.");
        }
        return new DataSourceMetadata(name, description, connector, allowedRoles, properties, resultIndex);
    }

    public static DataSourceMetadata toDataSourceMetadata(String json) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, json);){
            DataSourceMetadata dataSourceMetadata = XContentParserUtils.toDataSourceMetadata(parser);
            return dataSourceMetadata;
        }
    }

    public static XContentBuilder convertToXContent(DataSourceMetadata metadata) throws Exception {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field(NAME_FIELD, metadata.getName());
        builder.field(DESCRIPTION_FIELD, metadata.getDescription());
        builder.field(CONNECTOR_FIELD, metadata.getConnector().name());
        builder.field(ALLOWED_ROLES_FIELD, (Object)metadata.getAllowedRoles().toArray());
        builder.startObject(PROPERTIES_FIELD);
        for (Map.Entry entry : metadata.getProperties().entrySet()) {
            builder.field((String)entry.getKey(), (String)entry.getValue());
        }
        builder.endObject();
        builder.field(RESULT_INDEX_FIELD, metadata.getResultIndex());
        builder.endObject();
        return builder;
    }

    @Generated
    private XContentParserUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

