/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.sgd.linear;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.ONNXExportable;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.common.sgd.AbstractLinearSGDModel;
import org.tribuo.common.sgd.AbstractSGDModel;
import org.tribuo.math.LinearParameters;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.regression.Regressor;
import org.tribuo.util.onnx.ONNXNode;

public class LinearSGDModel
extends AbstractLinearSGDModel<Regressor>
implements ONNXExportable {
    private static final long serialVersionUID = 3L;
    private final String[] dimensionNames;
    @Deprecated
    private DenseMatrix weights = null;

    LinearSGDModel(String name, String[] dimensionNames, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Regressor> outputIDInfo, LinearParameters parameters) {
        super(name, provenance, featureIDMap, outputIDInfo, parameters, false);
        this.dimensionNames = dimensionNames;
    }

    public Prediction<Regressor> predict(Example<Regressor> example) {
        AbstractSGDModel.PredAndActive predTuple = this.predictSingle(example);
        return new Prediction((Output)new Regressor(this.dimensionNames, predTuple.prediction.toArray()), predTuple.numActiveFeatures - 1, example);
    }

    protected LinearSGDModel copy(String newName, ModelProvenance newProvenance) {
        return new LinearSGDModel(newName, Arrays.copyOf(this.dimensionNames, this.dimensionNames.length), newProvenance, this.featureIDMap, (ImmutableOutputInfo<Regressor>)this.outputIDInfo, (LinearParameters)this.modelParameters.copy());
    }

    protected String getDimensionName(int index) {
        return this.dimensionNames[index];
    }

    protected ONNXNode onnxOutput(ONNXNode input) {
        return input;
    }

    protected String onnxModelName() {
        return "Regression-LinearSGDModel";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.weights != null && this.modelParameters == null) {
            this.modelParameters = new LinearParameters(this.weights);
            this.weights = null;
            this.addBias = true;
        }
    }
}

