/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.logical.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.planner.core.PlanNode;
import org.opensearch.sql.legacy.query.planner.logical.LogicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.PhysicalOperator;

public class Filter
implements LogicalOperator {
    private final LogicalOperator next;
    private final Map<String, Where> aliasWhereMap = new HashMap<String, Where>();

    public Filter(LogicalOperator next, List<TableInJoinRequestBuilder> tables) {
        this.next = next;
        for (TableInJoinRequestBuilder table : tables) {
            Select select = table.getOriginalSelect();
            if (select.getWhere() == null) continue;
            this.aliasWhereMap.put(table.getAlias(), select.getWhere());
        }
    }

    public Filter(LogicalOperator next) {
        this.next = next;
    }

    @Override
    public PlanNode[] children() {
        return new PlanNode[]{this.next};
    }

    @Override
    public boolean isNoOp() {
        return this.aliasWhereMap.isEmpty();
    }

    @Override
    public <T> PhysicalOperator[] toPhysical(Map<LogicalOperator, PhysicalOperator<T>> optimalOps) {
        return new PhysicalOperator[]{optimalOps.get(this.next)};
    }

    public void pushDown(String tableAlias, Filter pushedDownFilter) {
        Where pushedDownWhere = pushedDownFilter.aliasWhereMap.remove(tableAlias);
        if (pushedDownWhere != null) {
            this.aliasWhereMap.put(tableAlias, pushedDownWhere);
        }
    }

    public String toString() {
        return "Filter [ conditions=" + this.aliasWhereMap.values() + " ]";
    }
}

