/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.netty4.Netty4HttpServerTransport;
import org.opensearch.security.filter.SecurityRestFilter;
import org.opensearch.security.ssl.http.netty.Netty4ConditionalDecompressor;
import org.opensearch.security.ssl.http.netty.Netty4HttpRequestHeaderVerifier;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.SharedGroupFactory;

public class SecurityNonSslHttpServerTransport
extends Netty4HttpServerTransport {
    private final ChannelInboundHandlerAdapter headerVerifier;

    public SecurityNonSslHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry namedXContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, Tracer tracer, SecurityRestFilter restFilter) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, tracer);
        this.headerVerifier = new Netty4HttpRequestHeaderVerifier(restFilter, threadPool, settings);
    }

    public ChannelHandler configureServerChannelHandler() {
        return new NonSslHttpChannelHandler(this, this.handlingSettings);
    }

    protected ChannelInboundHandlerAdapter createHeaderVerifier() {
        return this.headerVerifier;
    }

    protected ChannelInboundHandlerAdapter createDecompressor() {
        return new Netty4ConditionalDecompressor();
    }

    protected class NonSslHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected NonSslHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings) {
            super(transport, handlingSettings);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
        }
    }
}

