/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.securityconf.impl.AllowlistingSettings;
import org.opensearch.security.securityconf.impl.HttpRequestMethods;

public class WhitelistingSettings
extends AllowlistingSettings {
    private boolean enabled;
    private Map<String, List<HttpRequestMethods>> requests;

    public WhitelistingSettings() {
        this.enabled = false;
        this.requests = Collections.emptyMap();
    }

    public WhitelistingSettings(WhitelistingSettings whitelistingSettings) {
        this.enabled = whitelistingSettings.getEnabled();
        this.requests = whitelistingSettings.getRequests();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Map<String, List<HttpRequestMethods>> getRequests() {
        return this.requests == null ? Collections.emptyMap() : this.requests;
    }

    @Override
    public void setRequests(Map<String, List<HttpRequestMethods>> requests) {
        this.requests = requests;
    }

    @Override
    public String toString() {
        return "WhitelistingSetting [enabled=" + this.enabled + ", requests=" + this.requests + "]";
    }

    private boolean requestIsWhitelisted(SecurityRequest request) {
        String path = request.path();
        String pathWithoutTrailingSlash = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String pathWithTrailingSlash = pathWithoutTrailingSlash + "/";
        if (this.requests.containsKey(pathWithoutTrailingSlash) && this.requests.get(pathWithoutTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()))) {
            return true;
        }
        return this.requests.containsKey(pathWithTrailingSlash) && this.requests.get(pathWithTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()));
    }

    @Override
    public Optional<SecurityResponse> checkRequestIsAllowed(SecurityRequest request) {
        if (this.enabled && !this.requestIsWhitelisted(request)) {
            return Optional.of(new SecurityResponse(403, null, this.generateFailureMessage(request), XContentType.JSON.mediaType()));
        }
        return Optional.empty();
    }

    @Override
    protected String getVerb() {
        return "whitelisted";
    }
}

