/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.security.ssl.SecurityKeyStore;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.transport.DualModeSSLHandler;
import org.opensearch.security.ssl.transport.SSLConfig;
import org.opensearch.security.ssl.util.SSLConnectionTestResult;
import org.opensearch.security.ssl.util.SSLConnectionTestUtil;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.SharedGroupFactory;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.netty4.Netty4Transport;

public class SecuritySSLNettyTransport
extends Netty4Transport {
    private static final Logger logger = LogManager.getLogger(SecuritySSLNettyTransport.class);
    private final SecurityKeyStore ossks;
    private final SslExceptionHandler errorHandler;
    private final SSLConfig SSLConfig;

    public SecuritySSLNettyTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SecurityKeyStore ossks, SslExceptionHandler errorHandler, SharedGroupFactory sharedGroupFactory, SSLConfig SSLConfig2, Tracer tracer) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sharedGroupFactory, tracer);
        this.ossks = ossks;
        this.errorHandler = errorHandler;
        this.SSLConfig = SSLConfig2;
    }

    public void onException(TcpChannel channel, Exception e) {
        Throwable cause = e;
        if (e instanceof DecoderException && e != null) {
            cause = e.getCause();
        }
        this.errorHandler.logError(cause, false);
        logger.error("Exception during establishing a SSL connection: " + cause, cause);
        super.onException(channel, e);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new SSLServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new SSLClientChannelInitializer(node);
    }

    protected class SSLServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        public SSLServerChannelInitializer(String name) {
            super((Netty4Transport)SecuritySSLNettyTransport.this, name);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            boolean dualModeEnabled = SecuritySSLNettyTransport.this.SSLConfig.isDualModeEnabled();
            if (dualModeEnabled) {
                logger.info("SSL Dual mode enabled, using port unification handler");
                DualModeSSLHandler portUnificationHandler = new DualModeSSLHandler(SecuritySSLNettyTransport.this.ossks);
                ch.pipeline().addFirst("port_unification_handler", (ChannelHandler)portUnificationHandler);
            } else {
                SslHandler sslHandler = new SslHandler(SecuritySSLNettyTransport.this.ossks.createServerTransportSSLEngine());
                ch.pipeline().addFirst("ssl_server", (ChannelHandler)sslHandler);
            }
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            SecuritySSLNettyTransport.this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class SSLClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final DiscoveryNode node;
        private SSLConnectionTestResult connectionTestResult;

        public SSLClientChannelInitializer(DiscoveryNode node) {
            super((Netty4Transport)SecuritySSLNettyTransport.this);
            this.node = node;
            this.hostnameVerificationEnabled = SecuritySSLNettyTransport.this.settings.getAsBoolean("plugins.security.ssl.transport.enforce_hostname_verification", Boolean.valueOf(true));
            this.hostnameVerificationResovleHostName = SecuritySSLNettyTransport.this.settings.getAsBoolean("plugins.security.ssl.transport.resolve_hostname", Boolean.valueOf(true));
            this.connectionTestResult = SSLConnectionTestResult.SSL_AVAILABLE;
            if (SecuritySSLNettyTransport.this.SSLConfig.isDualModeEnabled()) {
                SSLConnectionTestUtil sslConnectionTestUtil = new SSLConnectionTestUtil(node.getAddress().getAddress(), node.getAddress().getPort());
                this.connectionTestResult = AccessController.doPrivileged(sslConnectionTestUtil::testConnection);
            }
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (this.connectionTestResult == SSLConnectionTestResult.OPENSEARCH_PING_FAILED) {
                logger.error("SSL dual mode is enabled but dual mode handshake and OpenSearch ping has failed during client connection setup, closing channel");
                ch.close();
                return;
            }
            if (this.connectionTestResult == SSLConnectionTestResult.SSL_AVAILABLE) {
                logger.debug("Connection to {} needs to be ssl, adding ssl handler to the client channel ", (Object)this.node.getHostName());
                ch.pipeline().addFirst("client_ssl_handler", (ChannelHandler)new ClientSSLHandler(SecuritySSLNettyTransport.this.ossks, this.hostnameVerificationEnabled, this.hostnameVerificationResovleHostName, SecuritySSLNettyTransport.this.errorHandler));
            } else {
                logger.debug("Connection to {} needs to be non ssl", (Object)this.node.getHostName());
            }
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            SecuritySSLNettyTransport.this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected static class ClientSSLHandler
    extends ChannelOutboundHandlerAdapter {
        private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
        private final SecurityKeyStore sks;
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;
        private final SslExceptionHandler errorHandler;

        private ClientSSLHandler(SecurityKeyStore sks, boolean hostnameVerificationEnabled, boolean hostnameVerificationResovleHostName, SslExceptionHandler errorHandler) {
            this.sks = sks;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.hostnameVerificationResovleHostName = hostnameVerificationResovleHostName;
            this.errorHandler = errorHandler;
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            this.errorHandler.logError(cause, false);
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine engine = null;
            try {
                if (this.hostnameVerificationEnabled) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                    String hostname = null;
                    hostname = this.hostnameVerificationResovleHostName ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Hostname of peer is {} ({}/{}) with hostnameVerificationResovleHostName: {}", (Object)hostname, (Object)inetSocketAddress.getHostName(), (Object)inetSocketAddress.getHostString(), (Object)this.hostnameVerificationResovleHostName);
                    }
                    engine = this.sks.createClientTransportSSLEngine(hostname, inetSocketAddress.getPort());
                } else {
                    engine = this.sks.createClientTransportSSLEngine(null, -1);
                }
            }
            catch (SSLException e) {
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
            SslHandler sslHandler = new SslHandler(engine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl_client", (ChannelHandler)sslHandler);
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }
}

