/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.utils;

import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006\u001a\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0006\u001a\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0006\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"VALID_ID_CHARS", "", "", "isValidEmail", "", "email", "", "isValidId", "idString", "isValidUrl", "urlString", "validateEmail", "", "validateIamRoleArn", "roleArn", "validateId", "validateUrl", "common-utils"})
@SourceDebugExtension(value={"SMAP\nValidationHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidationHelpers.kt\norg/opensearch/commons/utils/ValidationHelpersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,56:1\n1#2:57\n483#3,11:58\n1064#3,2:69\n*S KotlinDebug\n*F\n+ 1 ValidationHelpers.kt\norg/opensearch/commons/utils/ValidationHelpersKt\n*L\n23#1:58,11\n49#1:69,2\n*E\n"})
public final class ValidationHelpersKt {
    @NotNull
    private static final Set<Character> VALID_ID_CHARS = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9'))), (Object)Character.valueOf('+')), (Object)Character.valueOf('/')), (Object)Character.valueOf('_')), (Object)Character.valueOf('-')));

    public static final void validateUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (!ValidationHelpersKt.isValidUrl(urlString)) {
            boolean bl = false;
            String string = "Invalid URL or unsupported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void validateEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        if (!ValidationHelpersKt.isValidEmail(email)) {
            boolean bl = false;
            String string = "Invalid email address";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateId(@NotNull String idString) {
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        if (!ValidationHelpersKt.isValidId(idString)) {
            void $this$filterNotTo$iv$iv;
            boolean bl = false;
            String $this$filterNot$iv = idString;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = $this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                boolean bl2 = false;
                if (VALID_ID_CHARS.contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterNotTo(StringBuilder(), predicate).toString()");
            String string2 = "Invalid characters in id : " + string;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public static final boolean isValidUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        URL url = new URL(urlString);
        return Intrinsics.areEqual((Object)"https", (Object)url.getProtocol()) || Intrinsics.areEqual((Object)"http", (Object)url.getProtocol());
    }

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidId(@NotNull String idString) {
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        if (StringsKt.isBlank((CharSequence)idString)) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = idString;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl2 = false;
            if (!VALID_ID_CHARS.contains(Character.valueOf(it))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final void validateIamRoleArn(@NotNull String roleArn) {
        Intrinsics.checkNotNullParameter((Object)roleArn, (String)"roleArn");
        Pattern roleArnRegex = Pattern.compile("^arn:aws(-[^:]+)?:iam::([0-9]{12}):([a-zA-Z_0-9+=,.@\\-_/]+)$");
        if (!roleArnRegex.matcher(roleArn).find()) {
            boolean bl = false;
            String string = "Invalid AWS role ARN: " + roleArn + " ";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

