/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher.model;

import lombok.Generated;
import org.opensearch.sql.spark.dispatcher.model.FullyQualifiedTableName;
import org.opensearch.sql.spark.flint.FlintIndexType;

public class IndexDetails {
    private String indexName;
    private FullyQualifiedTableName fullyQualifiedTableName;
    private Boolean autoRefresh = false;
    private boolean isDropIndex;
    private FlintIndexType indexType;

    public String openSearchIndexName() {
        FullyQualifiedTableName fullyQualifiedTableName = this.getFullyQualifiedTableName();
        if (FlintIndexType.SKIPPING.equals((Object)this.getIndexType())) {
            String indexName = "flint_" + fullyQualifiedTableName.getDatasourceName() + "_" + fullyQualifiedTableName.getSchemaName() + "_" + fullyQualifiedTableName.getTableName() + "_" + this.getIndexType().getSuffix();
            return indexName.toLowerCase();
        }
        if (FlintIndexType.COVERING.equals((Object)this.getIndexType())) {
            String indexName = "flint_" + fullyQualifiedTableName.getDatasourceName() + "_" + fullyQualifiedTableName.getSchemaName() + "_" + fullyQualifiedTableName.getTableName() + "_" + this.getIndexName() + "_" + this.getIndexType().getSuffix();
            return indexName.toLowerCase();
        }
        throw new UnsupportedOperationException(String.format("Unsupported Index Type : %s", new Object[]{this.getIndexType()}));
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public FullyQualifiedTableName getFullyQualifiedTableName() {
        return this.fullyQualifiedTableName;
    }

    @Generated
    public Boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    @Generated
    public boolean isDropIndex() {
        return this.isDropIndex;
    }

    @Generated
    public FlintIndexType getIndexType() {
        return this.indexType;
    }

    @Generated
    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Generated
    public void setFullyQualifiedTableName(FullyQualifiedTableName fullyQualifiedTableName) {
        this.fullyQualifiedTableName = fullyQualifiedTableName;
    }

    @Generated
    public void setAutoRefresh(Boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    @Generated
    public void setDropIndex(boolean isDropIndex) {
        this.isDropIndex = isDropIndex;
    }

    @Generated
    public void setIndexType(FlintIndexType indexType) {
        this.indexType = indexType;
    }

    @Generated
    public String toString() {
        return "IndexDetails(indexName=" + this.getIndexName() + ", fullyQualifiedTableName=" + this.getFullyQualifiedTableName() + ", autoRefresh=" + this.getAutoRefresh() + ", isDropIndex=" + this.isDropIndex() + ", indexType=" + this.getIndexType() + ")";
    }

    @Generated
    public IndexDetails(String indexName, FullyQualifiedTableName fullyQualifiedTableName, Boolean autoRefresh, boolean isDropIndex, FlintIndexType indexType) {
        this.indexName = indexName;
        this.fullyQualifiedTableName = fullyQualifiedTableName;
        this.autoRefresh = autoRefresh;
        this.isDropIndex = isDropIndex;
        this.indexType = indexType;
    }

    @Generated
    public IndexDetails() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexDetails)) {
            return false;
        }
        IndexDetails other = (IndexDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDropIndex() != other.isDropIndex()) {
            return false;
        }
        Boolean this$autoRefresh = this.getAutoRefresh();
        Boolean other$autoRefresh = other.getAutoRefresh();
        if (this$autoRefresh == null ? other$autoRefresh != null : !((Object)this$autoRefresh).equals(other$autoRefresh)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        FullyQualifiedTableName this$fullyQualifiedTableName = this.getFullyQualifiedTableName();
        FullyQualifiedTableName other$fullyQualifiedTableName = other.getFullyQualifiedTableName();
        if (this$fullyQualifiedTableName == null ? other$fullyQualifiedTableName != null : !((Object)this$fullyQualifiedTableName).equals(other$fullyQualifiedTableName)) {
            return false;
        }
        FlintIndexType this$indexType = this.getIndexType();
        FlintIndexType other$indexType = other.getIndexType();
        return !(this$indexType == null ? other$indexType != null : !((Object)((Object)this$indexType)).equals((Object)other$indexType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDropIndex() ? 79 : 97);
        Boolean $autoRefresh = this.getAutoRefresh();
        result = result * 59 + ($autoRefresh == null ? 43 : ((Object)$autoRefresh).hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        FullyQualifiedTableName $fullyQualifiedTableName = this.getFullyQualifiedTableName();
        result = result * 59 + ($fullyQualifiedTableName == null ? 43 : ((Object)$fullyQualifiedTableName).hashCode());
        FlintIndexType $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : ((Object)((Object)$indexType)).hashCode());
        return result;
    }
}

