/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PGPKeyRing {
    private static final Logger LOG = Logger.getLogger(PGPKeyRing.class.getName());

    PGPKeyRing() {
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream bCPGInputStream) throws IOException {
        int n = bCPGInputStream.skipMarkerPackets();
        return n == 12 ? (TrustPacket)bCPGInputStream.readPacket() : null;
    }

    static List<PGPSignature> readSignaturesAndTrust(BCPGInputStream bCPGInputStream) throws IOException {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        while (bCPGInputStream.skipMarkerPackets() == 2) {
            try {
                SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(bCPGInputStream);
                arrayList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            catch (UnsupportedPacketVersionException unsupportedPacketVersionException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown signature: " + unsupportedPacketVersionException.getMessage());
            }
        }
        return arrayList;
    }

    static void readUserIDs(BCPGInputStream bCPGInputStream, List<UserDataPacket> list, List<TrustPacket> list2, List<List<PGPSignature>> list3) throws IOException {
        while (PGPKeyRing.isUserTag(bCPGInputStream.skipMarkerPackets())) {
            ContainedPacket containedPacket;
            Packet packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                containedPacket = (UserIDPacket)packet;
                list.add((UserDataPacket)((Object)containedPacket));
            } else {
                containedPacket = (UserAttributePacket)packet;
                list.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)containedPacket).getSubpackets()));
            }
            list2.add(PGPKeyRing.readOptionalTrustPacket(bCPGInputStream));
            list3.add(PGPKeyRing.readSignaturesAndTrust(bCPGInputStream));
        }
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator<PGPPublicKey> getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract PGPPublicKey getPublicKey(byte[] var1);

    public abstract Iterator<PGPPublicKey> getKeysWithSignaturesBy(long var1);

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;

    private static boolean isUserTag(int n) {
        switch (n) {
            case 13: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

