/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.plugin;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.ml.action.connector.DeleteConnectorTransportAction;
import org.opensearch.ml.action.connector.GetConnectorTransportAction;
import org.opensearch.ml.action.connector.SearchConnectorTransportAction;
import org.opensearch.ml.action.connector.TransportCreateConnectorAction;
import org.opensearch.ml.action.connector.UpdateConnectorTransportAction;
import org.opensearch.ml.action.deploy.TransportDeployModelAction;
import org.opensearch.ml.action.deploy.TransportDeployModelOnNodeAction;
import org.opensearch.ml.action.execute.TransportExecuteTaskAction;
import org.opensearch.ml.action.forward.TransportForwardAction;
import org.opensearch.ml.action.handler.MLSearchHandler;
import org.opensearch.ml.action.model_group.DeleteModelGroupTransportAction;
import org.opensearch.ml.action.model_group.SearchModelGroupTransportAction;
import org.opensearch.ml.action.model_group.TransportRegisterModelGroupAction;
import org.opensearch.ml.action.model_group.TransportUpdateModelGroupAction;
import org.opensearch.ml.action.models.DeleteModelTransportAction;
import org.opensearch.ml.action.models.GetModelTransportAction;
import org.opensearch.ml.action.models.SearchModelTransportAction;
import org.opensearch.ml.action.prediction.TransportPredictionTaskAction;
import org.opensearch.ml.action.profile.MLProfileAction;
import org.opensearch.ml.action.profile.MLProfileTransportAction;
import org.opensearch.ml.action.register.TransportRegisterModelAction;
import org.opensearch.ml.action.stats.MLStatsNodesAction;
import org.opensearch.ml.action.stats.MLStatsNodesTransportAction;
import org.opensearch.ml.action.syncup.TransportSyncUpOnNodeAction;
import org.opensearch.ml.action.tasks.DeleteTaskTransportAction;
import org.opensearch.ml.action.tasks.GetTaskTransportAction;
import org.opensearch.ml.action.tasks.SearchTaskTransportAction;
import org.opensearch.ml.action.training.TransportTrainingTaskAction;
import org.opensearch.ml.action.trainpredict.TransportTrainAndPredictionTaskAction;
import org.opensearch.ml.action.undeploy.TransportUndeployModelAction;
import org.opensearch.ml.action.undeploy.TransportUndeployModelsAction;
import org.opensearch.ml.action.upload_chunk.MLModelChunkUploader;
import org.opensearch.ml.action.upload_chunk.TransportRegisterModelMetaAction;
import org.opensearch.ml.action.upload_chunk.TransportUploadModelChunkAction;
import org.opensearch.ml.autoredeploy.MLModelAutoReDeployer;
import org.opensearch.ml.breaker.MLCircuitBreakerService;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.cluster.MLCommonsClusterEventListener;
import org.opensearch.ml.cluster.MLCommonsClusterManagerEventListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.input.execute.anomalylocalization.AnomalyLocalizationInput;
import org.opensearch.ml.common.input.execute.metricscorrelation.MetricsCorrelationInput;
import org.opensearch.ml.common.input.execute.samplecalculator.LocalSampleCalculatorInput;
import org.opensearch.ml.common.input.parameter.ad.AnomalyDetectionLibSVMParams;
import org.opensearch.ml.common.input.parameter.clustering.KMeansParams;
import org.opensearch.ml.common.input.parameter.clustering.RCFSummarizeParams;
import org.opensearch.ml.common.input.parameter.rcf.BatchRCFParams;
import org.opensearch.ml.common.input.parameter.rcf.FitRCFParams;
import org.opensearch.ml.common.input.parameter.regression.LinearRegressionParams;
import org.opensearch.ml.common.input.parameter.regression.LogisticRegressionParams;
import org.opensearch.ml.common.input.parameter.sample.SampleAlgoParams;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteAction;
import org.opensearch.ml.common.transport.connector.MLConnectorGetAction;
import org.opensearch.ml.common.transport.connector.MLConnectorSearchAction;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorAction;
import org.opensearch.ml.common.transport.connector.MLUpdateConnectorAction;
import org.opensearch.ml.common.transport.deploy.MLDeployModelAction;
import org.opensearch.ml.common.transport.deploy.MLDeployModelOnNodeAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.forward.MLForwardAction;
import org.opensearch.ml.common.transport.model.MLModelDeleteAction;
import org.opensearch.ml.common.transport.model.MLModelGetAction;
import org.opensearch.ml.common.transport.model.MLModelSearchAction;
import org.opensearch.ml.common.transport.model_group.MLModelGroupDeleteAction;
import org.opensearch.ml.common.transport.model_group.MLModelGroupSearchAction;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupAction;
import org.opensearch.ml.common.transport.model_group.MLUpdateModelGroupAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.register.MLRegisterModelAction;
import org.opensearch.ml.common.transport.sync.MLSyncUpAction;
import org.opensearch.ml.common.transport.task.MLTaskDeleteAction;
import org.opensearch.ml.common.transport.task.MLTaskGetAction;
import org.opensearch.ml.common.transport.task.MLTaskSearchAction;
import org.opensearch.ml.common.transport.training.MLTrainingTaskAction;
import org.opensearch.ml.common.transport.trainpredict.MLTrainAndPredictionTaskAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsAction;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaAction;
import org.opensearch.ml.common.transport.upload_chunk.MLUploadModelChunkAction;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.engine.MLEngineClassLoader;
import org.opensearch.ml.engine.ModelHelper;
import org.opensearch.ml.engine.algorithms.anomalylocalization.AnomalyLocalizerImpl;
import org.opensearch.ml.engine.algorithms.metrics_correlation.MetricsCorrelation;
import org.opensearch.ml.engine.algorithms.sample.LocalSampleCalculator;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.encryptor.EncryptorImpl;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.indices.MLInputDatasetHandler;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.CreateConversationAction;
import org.opensearch.ml.memory.action.conversation.CreateConversationTransportAction;
import org.opensearch.ml.memory.action.conversation.CreateInteractionAction;
import org.opensearch.ml.memory.action.conversation.CreateInteractionTransportAction;
import org.opensearch.ml.memory.action.conversation.DeleteConversationAction;
import org.opensearch.ml.memory.action.conversation.DeleteConversationTransportAction;
import org.opensearch.ml.memory.action.conversation.GetConversationsAction;
import org.opensearch.ml.memory.action.conversation.GetConversationsTransportAction;
import org.opensearch.ml.memory.action.conversation.GetInteractionsAction;
import org.opensearch.ml.memory.action.conversation.GetInteractionsTransportAction;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.ml.model.MLModelCacheHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.rest.RestMLCreateConnectorAction;
import org.opensearch.ml.rest.RestMLDeleteConnectorAction;
import org.opensearch.ml.rest.RestMLDeleteModelAction;
import org.opensearch.ml.rest.RestMLDeleteModelGroupAction;
import org.opensearch.ml.rest.RestMLDeleteTaskAction;
import org.opensearch.ml.rest.RestMLDeployModelAction;
import org.opensearch.ml.rest.RestMLExecuteAction;
import org.opensearch.ml.rest.RestMLGetConnectorAction;
import org.opensearch.ml.rest.RestMLGetModelAction;
import org.opensearch.ml.rest.RestMLGetTaskAction;
import org.opensearch.ml.rest.RestMLPredictionAction;
import org.opensearch.ml.rest.RestMLProfileAction;
import org.opensearch.ml.rest.RestMLRegisterModelAction;
import org.opensearch.ml.rest.RestMLRegisterModelGroupAction;
import org.opensearch.ml.rest.RestMLRegisterModelMetaAction;
import org.opensearch.ml.rest.RestMLSearchConnectorAction;
import org.opensearch.ml.rest.RestMLSearchModelAction;
import org.opensearch.ml.rest.RestMLSearchModelGroupAction;
import org.opensearch.ml.rest.RestMLSearchTaskAction;
import org.opensearch.ml.rest.RestMLStatsAction;
import org.opensearch.ml.rest.RestMLTrainAndPredictAction;
import org.opensearch.ml.rest.RestMLTrainingAction;
import org.opensearch.ml.rest.RestMLUndeployModelAction;
import org.opensearch.ml.rest.RestMLUpdateConnectorAction;
import org.opensearch.ml.rest.RestMLUpdateModelGroupAction;
import org.opensearch.ml.rest.RestMLUploadModelChunkAction;
import org.opensearch.ml.rest.RestMemoryCreateConversationAction;
import org.opensearch.ml.rest.RestMemoryCreateInteractionAction;
import org.opensearch.ml.rest.RestMemoryDeleteConversationAction;
import org.opensearch.ml.rest.RestMemoryGetConversationsAction;
import org.opensearch.ml.rest.RestMemoryGetInteractionsAction;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.stats.MLClusterLevelStat;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStat;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.stats.suppliers.CounterSupplier;
import org.opensearch.ml.stats.suppliers.IndexStatusSupplier;
import org.opensearch.ml.task.MLExecuteTaskRunner;
import org.opensearch.ml.task.MLPredictTaskRunner;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.task.MLTrainAndPredictTaskRunner;
import org.opensearch.ml.task.MLTrainingTaskRunner;
import org.opensearch.ml.utils.IndexUtils;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.monitor.os.OsService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPipelinePlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.searchpipelines.questionanswering.generative.GenerativeQARequestProcessor;
import org.opensearch.searchpipelines.questionanswering.generative.GenerativeQAResponseProcessor;
import org.opensearch.searchpipelines.questionanswering.generative.ext.GenerativeQAParamExtBuilder;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class MachineLearningPlugin
extends Plugin
implements ActionPlugin,
SearchPlugin,
SearchPipelinePlugin {
    public static final String ML_THREAD_POOL_PREFIX = "thread_pool.ml_commons.";
    public static final String GENERAL_THREAD_POOL = "opensearch_ml_general";
    public static final String EXECUTE_THREAD_POOL = "opensearch_ml_execute";
    public static final String TRAIN_THREAD_POOL = "opensearch_ml_train";
    public static final String PREDICT_THREAD_POOL = "opensearch_ml_predict";
    public static final String REGISTER_THREAD_POOL = "opensearch_ml_register";
    public static final String DEPLOY_THREAD_POOL = "opensearch_ml_deploy";
    public static final String ML_BASE_URI = "/_plugins/_ml";
    private MLStats mlStats;
    private MLModelCacheHelper modelCacheHelper;
    private MLTaskManager mlTaskManager;
    private MLModelManager mlModelManager;
    private MLIndicesHandler mlIndicesHandler;
    private MLInputDatasetHandler mlInputDatasetHandler;
    private MLTrainingTaskRunner mlTrainingTaskRunner;
    private MLPredictTaskRunner mlPredictTaskRunner;
    private MLTrainAndPredictTaskRunner mlTrainAndPredictTaskRunner;
    private MLExecuteTaskRunner mlExecuteTaskRunner;
    private IndexUtils indexUtils;
    private ModelHelper modelHelper;
    private DiscoveryNodeHelper nodeHelper;
    private MLModelChunkUploader mlModelChunkUploader;
    private MLEngine mlEngine;
    private Client client;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Set<String> indicesToListen;
    public static final String ML_ROLE_NAME = "ml";
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;
    private ConnectorAccessControlHelper connectorAccessControlHelper;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private ConversationalMemoryHandler cmHandler;
    private volatile boolean ragSearchPipelineEnabled;

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return ImmutableList.of((Object)new ActionPlugin.ActionHandler((ActionType)MLStatsNodesAction.INSTANCE, MLStatsNodesTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLExecuteTaskAction.INSTANCE, TransportExecuteTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLPredictionTaskAction.INSTANCE, TransportPredictionTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTrainingTaskAction.INSTANCE, TransportTrainingTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTrainAndPredictionTaskAction.INSTANCE, TransportTrainAndPredictionTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLModelGetAction.INSTANCE, GetModelTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLModelDeleteAction.INSTANCE, DeleteModelTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLModelSearchAction.INSTANCE, SearchModelTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTaskGetAction.INSTANCE, GetTaskTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTaskDeleteAction.INSTANCE, DeleteTaskTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTaskSearchAction.INSTANCE, SearchTaskTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLProfileAction.INSTANCE, MLProfileTransportAction.class, new Class[0]), (Object[])new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)MLRegisterModelAction.INSTANCE, TransportRegisterModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLDeployModelAction.INSTANCE, TransportDeployModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLDeployModelOnNodeAction.INSTANCE, TransportDeployModelOnNodeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUndeployModelAction.INSTANCE, TransportUndeployModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUndeployModelsAction.INSTANCE, TransportUndeployModelsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLRegisterModelMetaAction.INSTANCE, TransportRegisterModelMetaAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUploadModelChunkAction.INSTANCE, TransportUploadModelChunkAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLForwardAction.INSTANCE, TransportForwardAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLSyncUpAction.INSTANCE, TransportSyncUpOnNodeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLRegisterModelGroupAction.INSTANCE, TransportRegisterModelGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUpdateModelGroupAction.INSTANCE, TransportUpdateModelGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelGroupSearchAction.INSTANCE, SearchModelGroupTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelGroupDeleteAction.INSTANCE, DeleteModelGroupTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLCreateConnectorAction.INSTANCE, TransportCreateConnectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLConnectorGetAction.INSTANCE, GetConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLConnectorDeleteAction.INSTANCE, DeleteConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLConnectorSearchAction.INSTANCE, SearchConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateConversationAction.INSTANCE, CreateConversationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetConversationsAction.INSTANCE, GetConversationsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateInteractionAction.INSTANCE, CreateInteractionTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetInteractionsAction.INSTANCE, GetInteractionsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteConversationAction.INSTANCE, DeleteConversationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUpdateConnectorAction.INSTANCE, UpdateConnectorTransportAction.class, new Class[0])});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.indexUtils = new IndexUtils(client, clusterService);
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        Settings settings = environment.settings();
        Path dataPath = environment.dataFiles()[0];
        Path configFile = environment.configFile();
        EncryptorImpl encryptor = new EncryptorImpl(clusterService, client);
        this.mlEngine = new MLEngine(dataPath, (Encryptor)encryptor);
        this.nodeHelper = new DiscoveryNodeHelper(clusterService, settings);
        this.modelCacheHelper = new MLModelCacheHelper(clusterService, settings);
        this.cmHandler = new OpenSearchConversationalMemoryHandler(client, clusterService);
        JvmService jvmService = new JvmService(environment.settings());
        OsService osService = new OsService(environment.settings());
        MLCircuitBreakerService mlCircuitBreakerService = new MLCircuitBreakerService(jvmService, osService, settings, clusterService).init(dataPath);
        ConcurrentHashMap stats = new ConcurrentHashMap();
        stats.put(MLClusterLevelStat.ML_MODEL_INDEX_STATUS, new MLStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".plugins-ml-model")));
        stats.put(MLClusterLevelStat.ML_CONNECTOR_INDEX_STATUS, new MLStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".plugins-ml-connector")));
        stats.put(MLClusterLevelStat.ML_CONFIG_INDEX_STATUS, new MLStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".plugins-ml-config")));
        stats.put(MLClusterLevelStat.ML_TASK_INDEX_STATUS, new MLStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".plugins-ml-task")));
        stats.put(MLClusterLevelStat.ML_MODEL_COUNT, new MLStat<Long>(true, new CounterSupplier()));
        stats.put(MLClusterLevelStat.ML_CONNECTOR_COUNT, new MLStat<Long>(true, new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_REQUEST_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_FAILURE_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_CIRCUIT_BREAKER_TRIGGER_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        this.mlStats = new MLStats(stats);
        this.mlIndicesHandler = new MLIndicesHandler(clusterService, client);
        this.mlTaskManager = new MLTaskManager(client, threadPool, this.mlIndicesHandler);
        this.modelHelper = new ModelHelper(this.mlEngine);
        this.mlModelManager = new MLModelManager(clusterService, scriptService, client, threadPool, xContentRegistry, this.modelHelper, settings, this.mlStats, mlCircuitBreakerService, this.mlIndicesHandler, this.mlTaskManager, this.modelCacheHelper, this.mlEngine, this.nodeHelper);
        this.mlInputDatasetHandler = new MLInputDatasetHandler(client);
        this.modelAccessControlHelper = new ModelAccessControlHelper(clusterService, settings);
        this.connectorAccessControlHelper = new ConnectorAccessControlHelper(clusterService, settings);
        this.mlFeatureEnabledSetting = new MLFeatureEnabledSetting(clusterService, settings);
        this.mlModelChunkUploader = new MLModelChunkUploader(this.mlIndicesHandler, client, xContentRegistry, this.modelAccessControlHelper);
        MLTaskDispatcher mlTaskDispatcher = new MLTaskDispatcher(clusterService, client, settings, this.nodeHelper);
        this.mlTrainingTaskRunner = new MLTrainingTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlIndicesHandler, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, this.nodeHelper, this.mlEngine);
        this.mlPredictTaskRunner = new MLPredictTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, xContentRegistry, this.mlModelManager, this.nodeHelper, this.mlEngine);
        this.mlTrainAndPredictTaskRunner = new MLTrainAndPredictTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, this.nodeHelper, this.mlEngine);
        this.mlExecuteTaskRunner = new MLExecuteTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, this.nodeHelper, this.mlEngine);
        LocalSampleCalculator localSampleCalculator = new LocalSampleCalculator(client, settings);
        MLEngineClassLoader.register((Enum)FunctionName.LOCAL_SAMPLE_CALCULATOR, (Object)localSampleCalculator);
        AnomalyLocalizerImpl anomalyLocalizer = new AnomalyLocalizerImpl(client, settings, clusterService, indexNameExpressionResolver);
        MLEngineClassLoader.register((Enum)FunctionName.ANOMALY_LOCALIZATION, (Object)anomalyLocalizer);
        MetricsCorrelation metricsCorrelation = new MetricsCorrelation(client, settings, clusterService);
        MLEngineClassLoader.register((Enum)FunctionName.METRICS_CORRELATION, (Object)metricsCorrelation);
        MLSearchHandler mlSearchHandler = new MLSearchHandler(client, xContentRegistry, this.modelAccessControlHelper, clusterService);
        MLModelAutoReDeployer mlModelAutoRedeployer = new MLModelAutoReDeployer(clusterService, client, settings, this.mlModelManager, new MLModelAutoReDeployer.SearchRequestBuilderFactory());
        MLCommonsClusterEventListener mlCommonsClusterEventListener = new MLCommonsClusterEventListener(clusterService, this.mlModelManager, this.mlTaskManager, this.modelCacheHelper, mlModelAutoRedeployer);
        MLCommonsClusterManagerEventListener clusterManagerEventListener = new MLCommonsClusterManagerEventListener(clusterService, client, settings, threadPool, this.nodeHelper, this.mlIndicesHandler, (Encryptor)encryptor);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_RAG_PIPELINE_FEATURE_ENABLED, it -> {
            this.ragSearchPipelineEnabled = it;
        });
        return ImmutableList.of((Object)encryptor, (Object)this.mlEngine, (Object)this.nodeHelper, (Object)this.modelCacheHelper, (Object)this.mlStats, (Object)this.mlTaskManager, (Object)this.mlModelManager, (Object)this.mlIndicesHandler, (Object)this.mlInputDatasetHandler, (Object)this.mlTrainingTaskRunner, (Object)this.mlPredictTaskRunner, (Object)this.mlTrainAndPredictTaskRunner, (Object[])new Object[]{this.mlExecuteTaskRunner, this.modelAccessControlHelper, this.connectorAccessControlHelper, this.mlFeatureEnabledSetting, mlSearchHandler, mlTaskDispatcher, this.mlModelChunkUploader, this.modelHelper, mlCommonsClusterEventListener, clusterManagerEventListener, mlCircuitBreakerService, mlModelAutoRedeployer, this.cmHandler});
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestMLStatsAction restMLStatsAction = new RestMLStatsAction(this.mlStats, this.clusterService, this.indexUtils, this.xContentRegistry);
        RestMLTrainingAction restMLTrainingAction = new RestMLTrainingAction();
        RestMLTrainAndPredictAction restMLTrainAndPredictAction = new RestMLTrainAndPredictAction();
        RestMLPredictionAction restMLPredictionAction = new RestMLPredictionAction(this.mlModelManager, this.mlFeatureEnabledSetting);
        RestMLExecuteAction restMLExecuteAction = new RestMLExecuteAction();
        RestMLGetModelAction restMLGetModelAction = new RestMLGetModelAction();
        RestMLDeleteModelAction restMLDeleteModelAction = new RestMLDeleteModelAction();
        RestMLSearchModelAction restMLSearchModelAction = new RestMLSearchModelAction();
        RestMLGetTaskAction restMLGetTaskAction = new RestMLGetTaskAction();
        RestMLDeleteTaskAction restMLDeleteTaskAction = new RestMLDeleteTaskAction();
        RestMLSearchTaskAction restMLSearchTaskAction = new RestMLSearchTaskAction();
        RestMLProfileAction restMLProfileAction = new RestMLProfileAction(this.clusterService);
        RestMLRegisterModelAction restMLRegisterModelAction = new RestMLRegisterModelAction(this.clusterService, settings, this.mlFeatureEnabledSetting);
        RestMLDeployModelAction restMLDeployModelAction = new RestMLDeployModelAction();
        RestMLUndeployModelAction restMLUndeployModelAction = new RestMLUndeployModelAction(this.clusterService, settings);
        RestMLRegisterModelMetaAction restMLRegisterModelMetaAction = new RestMLRegisterModelMetaAction(this.clusterService, settings);
        RestMLUploadModelChunkAction restMLUploadModelChunkAction = new RestMLUploadModelChunkAction(this.clusterService, settings);
        RestMLRegisterModelGroupAction restMLCreateModelGroupAction = new RestMLRegisterModelGroupAction();
        RestMLUpdateModelGroupAction restMLUpdateModelGroupAction = new RestMLUpdateModelGroupAction();
        RestMLSearchModelGroupAction restMLSearchModelGroupAction = new RestMLSearchModelGroupAction();
        RestMLDeleteModelGroupAction restMLDeleteModelGroupAction = new RestMLDeleteModelGroupAction();
        RestMLCreateConnectorAction restMLCreateConnectorAction = new RestMLCreateConnectorAction(this.mlFeatureEnabledSetting);
        RestMLGetConnectorAction restMLGetConnectorAction = new RestMLGetConnectorAction();
        RestMLDeleteConnectorAction restMLDeleteConnectorAction = new RestMLDeleteConnectorAction();
        RestMLSearchConnectorAction restMLSearchConnectorAction = new RestMLSearchConnectorAction();
        RestMemoryCreateConversationAction restCreateConversationAction = new RestMemoryCreateConversationAction();
        RestMemoryGetConversationsAction restListConversationsAction = new RestMemoryGetConversationsAction();
        RestMemoryCreateInteractionAction restCreateInteractionAction = new RestMemoryCreateInteractionAction();
        RestMemoryGetInteractionsAction restListInteractionsAction = new RestMemoryGetInteractionsAction();
        RestMemoryDeleteConversationAction restDeleteConversationAction = new RestMemoryDeleteConversationAction();
        RestMLUpdateConnectorAction restMLUpdateConnectorAction = new RestMLUpdateConnectorAction(this.mlFeatureEnabledSetting);
        return ImmutableList.of((Object)((Object)restMLStatsAction), (Object)((Object)restMLTrainingAction), (Object)((Object)restMLPredictionAction), (Object)((Object)restMLExecuteAction), (Object)((Object)restMLTrainAndPredictAction), (Object)((Object)restMLGetModelAction), (Object)((Object)restMLDeleteModelAction), (Object)((Object)restMLSearchModelAction), (Object)((Object)restMLGetTaskAction), (Object)((Object)restMLDeleteTaskAction), (Object)((Object)restMLSearchTaskAction), (Object)((Object)restMLProfileAction), (Object[])new RestHandler[]{restMLRegisterModelAction, restMLDeployModelAction, restMLUndeployModelAction, restMLRegisterModelMetaAction, restMLUploadModelChunkAction, restMLCreateModelGroupAction, restMLUpdateModelGroupAction, restMLSearchModelGroupAction, restMLDeleteModelGroupAction, restMLCreateConnectorAction, restMLGetConnectorAction, restMLDeleteConnectorAction, restMLSearchConnectorAction, restCreateConversationAction, restListConversationsAction, restCreateInteractionAction, restListInteractionsAction, restDeleteConversationAction, restMLUpdateConnectorAction});
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        FixedExecutorBuilder generalThreadPool = new FixedExecutorBuilder(settings, GENERAL_THREAD_POOL, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), 100, "thread_pool.ml_commons.opensearch_ml_general", false);
        FixedExecutorBuilder registerModelThreadPool = new FixedExecutorBuilder(settings, REGISTER_THREAD_POOL, Math.max(4, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.opensearch_ml_register", false);
        FixedExecutorBuilder deployModelThreadPool = new FixedExecutorBuilder(settings, DEPLOY_THREAD_POOL, Math.max(4, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.opensearch_ml_deploy", false);
        FixedExecutorBuilder executeThreadPool = new FixedExecutorBuilder(settings, EXECUTE_THREAD_POOL, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.opensearch_ml_execute", false);
        FixedExecutorBuilder trainThreadPool = new FixedExecutorBuilder(settings, TRAIN_THREAD_POOL, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.opensearch_ml_train", false);
        FixedExecutorBuilder predictThreadPool = new FixedExecutorBuilder(settings, PREDICT_THREAD_POOL, OpenSearchExecutors.allocatedProcessors((Settings)settings) * 2, 10000, "thread_pool.ml_commons.opensearch_ml_predict", false);
        return ImmutableList.of((Object)generalThreadPool, (Object)registerModelThreadPool, (Object)deployModelThreadPool, (Object)executeThreadPool, (Object)trainThreadPool, (Object)predictThreadPool);
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return ImmutableList.of((Object)KMeansParams.XCONTENT_REGISTRY, (Object)LinearRegressionParams.XCONTENT_REGISTRY, (Object)AnomalyDetectionLibSVMParams.XCONTENT_REGISTRY, (Object)SampleAlgoParams.XCONTENT_REGISTRY, (Object)FitRCFParams.XCONTENT_REGISTRY, (Object)BatchRCFParams.XCONTENT_REGISTRY, (Object)LocalSampleCalculatorInput.XCONTENT_REGISTRY, (Object)MetricsCorrelationInput.XCONTENT_REGISTRY, (Object)AnomalyLocalizationInput.XCONTENT_REGISTRY_ENTRY, (Object)RCFSummarizeParams.XCONTENT_REGISTRY, (Object)LogisticRegressionParams.XCONTENT_REGISTRY, (Object)TextEmbeddingModelConfig.XCONTENT_REGISTRY, (Object[])new NamedXContentRegistry.Entry[0]);
    }

    public List<Setting<?>> getSettings() {
        ImmutableList settings = ImmutableList.of(MLCommonsSettings.ML_COMMONS_TASK_DISPATCH_POLICY, MLCommonsSettings.ML_COMMONS_MAX_MODELS_PER_NODE, MLCommonsSettings.ML_COMMONS_ONLY_RUN_ON_ML_NODE, MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS, MLCommonsSettings.ML_COMMONS_ML_TASK_TIMEOUT_IN_SECONDS, MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT, MLCommonsSettings.ML_COMMONS_MAX_REGISTER_MODEL_TASKS_PER_NODE, MLCommonsSettings.ML_COMMONS_MAX_ML_TASK_PER_NODE, MLCommonsSettings.ML_COMMONS_MAX_DEPLOY_MODEL_TASKS_PER_NODE, MLCommonsSettings.ML_COMMONS_TRUSTED_URL_REGEX, MLCommonsSettings.ML_COMMONS_NATIVE_MEM_THRESHOLD, MLCommonsSettings.ML_COMMONS_JVM_HEAP_MEM_THRESHOLD, (Object[])new Setting[]{MLCommonsSettings.ML_COMMONS_EXCLUDE_NODE_NAMES, MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN, MLCommonsSettings.ML_COMMONS_ENABLE_INHOUSE_PYTHON_MODEL, MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_ENABLE, MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_LIFETIME_RETRY_TIMES, MLCommonsSettings.ML_COMMONS_ALLOW_MODEL_URL, MLCommonsSettings.ML_COMMONS_ALLOW_LOCAL_FILE_UPLOAD, MLCommonsSettings.ML_COMMONS_MODEL_ACCESS_CONTROL_ENABLED, MLCommonsSettings.ML_COMMONS_CONNECTOR_ACCESS_CONTROL_ENABLED, MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, MLCommonsSettings.ML_COMMONS_REMOTE_MODEL_ELIGIBLE_NODE_ROLES, MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ELIGIBLE_NODE_ROLES, MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED, MLCommonsSettings.ML_COMMONS_UPDATE_CONNECTOR_ENABLED, MLCommonsSettings.ML_COMMONS_MEMORY_FEATURE_ENABLED, MLCommonsSettings.ML_COMMONS_RAG_PIPELINE_FEATURE_ENABLED});
        return settings;
    }

    public List<SearchPlugin.SearchExtSpec<?>> getSearchExts() {
        ArrayList searchExts = new ArrayList();
        searchExts.add(new SearchPlugin.SearchExtSpec("generative_qa_parameters", input -> new GenerativeQAParamExtBuilder(input), parser -> GenerativeQAParamExtBuilder.parse((XContentParser)parser)));
        return searchExts;
    }

    public Map<String, Processor.Factory<SearchRequestProcessor>> getRequestProcessors(SearchPipelinePlugin.Parameters parameters) {
        HashMap<String, Processor.Factory<SearchRequestProcessor>> requestProcessors = new HashMap<String, Processor.Factory<SearchRequestProcessor>>();
        requestProcessors.put("question_rewrite", (Processor.Factory<SearchRequestProcessor>)new GenerativeQARequestProcessor.Factory(() -> this.ragSearchPipelineEnabled));
        return requestProcessors;
    }

    public Map<String, Processor.Factory<SearchResponseProcessor>> getResponseProcessors(SearchPipelinePlugin.Parameters parameters) {
        HashMap<String, Processor.Factory<SearchResponseProcessor>> responseProcessors = new HashMap<String, Processor.Factory<SearchResponseProcessor>>();
        responseProcessors.put("retrieval_augmented_generation", (Processor.Factory<SearchResponseProcessor>)new GenerativeQAResponseProcessor.Factory(this.client, () -> this.ragSearchPipelineEnabled));
        return responseProcessors;
    }
}

