/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLExecuteAction
extends BaseRestHandler {
    private static final String ML_EXECUTE_ACTION = "ml_execute_action";

    public String getName() {
        return ML_EXECUTE_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_execute/{%s}", "/_plugins/_ml", "algorithm")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLExecuteTaskRequest mlExecuteTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)mlExecuteTaskRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLExecuteTaskRequest getRequest(RestRequest request) throws IOException {
        String algorithm = RestActionUtils.getAlgorithm(request).toUpperCase(Locale.ROOT);
        FunctionName functionName = FunctionName.from((String)algorithm);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        Input input = (Input)parser.namedObject(Input.class, algorithm, null);
        return new MLExecuteTaskRequest(functionName, input);
    }
}

