/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import java.util.Base64;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.notifications.spi.model.MessageContent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/notifications/core/client/EmailMimeProvider;", "", "()V", "createBinaryAttachmentPart", "Ljavax/mail/internet/MimeBodyPart;", "messageContent", "Lorg/opensearch/notifications/spi/model/MessageContent;", "createTextAttachmentPart", "prepareMimeMessage", "Ljavax/mail/internet/MimeMessage;", "session", "Ljavax/mail/Session;", "fromAddress", "", "recipient", "opensearch-notifications-core"})
public final class EmailMimeProvider {
    @NotNull
    public static final EmailMimeProvider INSTANCE = new EmailMimeProvider();

    private EmailMimeProvider() {
    }

    @NotNull
    public final MimeMessage prepareMimeMessage(@NotNull Session session, @NotNull String fromAddress, @NotNull String recipient, @NotNull MessageContent messageContent) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)fromAddress, (String)"fromAddress");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Intrinsics.checkNotNullParameter((Object)messageContent, (String)"messageContent");
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom(fromAddress);
        mimeMessage.setRecipients(Message.RecipientType.TO, recipient);
        mimeMessage.setSubject(messageContent.getTitle(), "UTF-8");
        MimeMultipart msgBody = new MimeMultipart("alternative");
        MimeBodyPart bodyWrapper = new MimeBodyPart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)messageContent.getTextDescription(), "text/plain; charset=UTF-8");
        msgBody.addBodyPart((BodyPart)textPart);
        if (messageContent.getHtmlDescription() != null) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)messageContent.getHtmlDescription(), "text/html; charset=UTF-8");
            msgBody.addBodyPart((BodyPart)htmlPart);
        }
        bodyWrapper.setContent((Multipart)msgBody);
        MimeMultipart msg = new MimeMultipart("mixed");
        mimeMessage.setContent((Multipart)msg);
        msg.addBodyPart((BodyPart)bodyWrapper);
        if (messageContent.getFileName() != null && messageContent.getFileData() != null && messageContent.getFileContentType() != null && messageContent.getFileEncoding() != null) {
            MimeBodyPart attachmentMime = null;
            String string = messageContent.getFileEncoding();
            if (Intrinsics.areEqual((Object)string, (Object)"text")) {
                attachmentMime = this.createTextAttachmentPart(messageContent);
            } else if (Intrinsics.areEqual((Object)string, (Object)"base64")) {
                attachmentMime = this.createBinaryAttachmentPart(messageContent);
            }
            if (attachmentMime != null) {
                msg.addBodyPart((BodyPart)attachmentMime);
            }
        }
        return mimeMessage;
    }

    private final MimeBodyPart createBinaryAttachmentPart(MessageContent messageContent) {
        MimeBodyPart attachmentMime = new MimeBodyPart();
        byte[] byArray = Base64.getMimeDecoder().decode(messageContent.getFileData());
        String string = messageContent.getFileContentType();
        if (string == null) {
            string = "application/octet-stream";
        }
        ByteArrayDataSource fds = new ByteArrayDataSource(byArray, string);
        attachmentMime.setDataHandler(new DataHandler((DataSource)fds));
        attachmentMime.setFileName(messageContent.getFileName());
        return attachmentMime;
    }

    private final MimeBodyPart createTextAttachmentPart(MessageContent messageContent) {
        MimeBodyPart attachmentMime = new MimeBodyPart();
        String string = messageContent.getFileContentType();
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null)) == null) {
            string = "plain";
        }
        String subContentType = string;
        attachmentMime.setText(messageContent.getFileData(), "UTF-8", subContentType);
        attachmentMime.setFileName(messageContent.getFileName());
        return attachmentMime;
    }
}

