/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class GetFindingsRequest
extends ActionRequest {
    private String logType;
    private String detectorId;
    private Table table;
    public static final String DETECTOR_ID = "detector_id";

    public GetFindingsRequest(String detectorId) {
        this.detectorId = detectorId;
    }

    public GetFindingsRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), sin.readOptionalString(), Table.readFrom((StreamInput)sin));
    }

    public GetFindingsRequest(String detectorId, String logType, Table table) {
        this.detectorId = detectorId;
        this.logType = logType;
        this.table = table;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if ((this.detectorId == null || this.detectorId.length() == 0) && this.logType == null) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "At least one of detector type or detector id needs to be passed", DETECTOR_ID), validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.detectorId);
        out.writeOptionalString(this.logType);
        this.table.writeTo(out);
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public String getLogType() {
        return this.logType;
    }

    public Table getTable() {
        return this.table;
    }
}

