/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class CorrelationQuery
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(CorrelationQuery.class);
    private static final String INDEX = "index";
    private static final String QUERY = "query";
    private static final String CATEGORY = "category";
    private String index;
    private String query;
    private String category;

    public CorrelationQuery(String index, String query, String category) {
        this.index = index;
        this.query = query;
        this.category = category;
    }

    public CorrelationQuery(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeString(this.query);
        out.writeString(this.category);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX, this.index).field(QUERY, this.query).field(CATEGORY, this.category);
        return builder.endObject();
    }

    public static CorrelationQuery parse(XContentParser xcp) throws IOException {
        String index = null;
        String query = null;
        String category = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index": {
                    index = xcp.text();
                    continue block10;
                }
                case "query": {
                    query = xcp.text();
                    continue block10;
                }
                case "category": {
                    category = xcp.text();
                    continue block10;
                }
            }
            xcp.skipChildren();
        }
        return new CorrelationQuery(index, query, category);
    }

    public static CorrelationQuery readFrom(StreamInput sin) throws IOException {
        return new CorrelationQuery(sin);
    }

    public String getIndex() {
        return this.index;
    }

    public String getQuery() {
        return this.query;
    }

    public String getCategory() {
        return this.category;
    }
}

