/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class LogType
implements Writeable {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String IS_BUILTIN = "is_builtin";
    private static final String MAPPINGS = "mappings";
    private static final String RAW_FIELD = "raw_field";
    public static final String ECS = "ecs";
    public static final String OCSF = "ocsf";
    private String id;
    private String name;
    private String description;
    private Boolean isBuiltIn;
    private List<Mapping> mappings;

    public LogType(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.isBuiltIn = sin.readOptionalBoolean();
        this.name = sin.readString();
        this.description = sin.readString();
        this.mappings = sin.readList(Mapping::readFrom);
    }

    public LogType(String id, String name, String description, boolean isBuiltIn, List<Mapping> mappings) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.isBuiltIn = isBuiltIn;
        this.mappings = mappings == null ? List.of() : mappings;
    }

    public LogType(Map<String, Object> logTypeAsMap) {
        List mappings;
        this.id = (String)logTypeAsMap.get(ID);
        this.name = (String)logTypeAsMap.get(NAME);
        this.description = (String)logTypeAsMap.get(DESCRIPTION);
        if (logTypeAsMap.containsKey(IS_BUILTIN)) {
            this.isBuiltIn = (Boolean)logTypeAsMap.get(IS_BUILTIN);
        }
        if ((mappings = (List)logTypeAsMap.get(MAPPINGS)).size() > 0) {
            this.mappings = new ArrayList<Mapping>(mappings.size());
            this.mappings = mappings.stream().map(e -> new Mapping((String)e.get(RAW_FIELD), (String)e.get(ECS), (String)e.get(OCSF))).collect(Collectors.toList());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getIsBuiltIn() {
        return this.isBuiltIn;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalBoolean(this.isBuiltIn);
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeCollection(this.mappings);
    }

    public String toString() {
        return this.name;
    }

    public static class Mapping
    implements Writeable {
        private String rawField;
        private String ecs;
        private String ocsf;

        public Mapping(StreamInput sin) throws IOException {
            this.rawField = sin.readString();
            this.ecs = sin.readOptionalString();
            this.ocsf = sin.readOptionalString();
        }

        public Mapping(String rawField, String ecs, String ocsf) {
            this.rawField = rawField;
            this.ecs = ecs;
            this.ocsf = ocsf;
        }

        public String getRawField() {
            return this.rawField;
        }

        public String getEcs() {
            return this.ecs;
        }

        public String getOcsf() {
            return this.ocsf;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.rawField);
            out.writeOptionalString(this.ecs);
            out.writeOptionalString(this.ocsf);
        }

        public static Mapping readFrom(StreamInput sin) throws IOException {
            return new Mapping(sin);
        }
    }
}

