/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.objects;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.opensearch.securityanalytics.rules.exceptions.SigmaDateError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaDetectionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaIdentifierError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaLevelError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaLogsourceError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaStatusError;
import org.opensearch.securityanalytics.rules.objects.SigmaDetections;
import org.opensearch.securityanalytics.rules.objects.SigmaLevel;
import org.opensearch.securityanalytics.rules.objects.SigmaLogSource;
import org.opensearch.securityanalytics.rules.objects.SigmaRuleTag;
import org.opensearch.securityanalytics.rules.objects.SigmaStatus;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class SigmaRule {
    private String title;
    private SigmaLogSource logSource;
    private SigmaDetections detection;
    private UUID id;
    private SigmaStatus status;
    private String description;
    private List<String> references;
    private List<SigmaRuleTag> tags;
    private String author;
    private Date date;
    private List<String> fields;
    private List<String> falsePositives;
    private SigmaLevel level;
    private List<SigmaError> errors;

    public SigmaRule(String title, SigmaLogSource logSource, SigmaDetections detection, UUID id, SigmaStatus status, String description, List<String> references, List<SigmaRuleTag> tags, String author, Date date, List<String> fields, List<String> falsePositives, SigmaLevel level, List<SigmaError> errors) {
        this.title = title;
        this.logSource = logSource;
        this.detection = detection;
        this.id = id;
        this.status = status;
        this.description = description;
        this.references = references;
        this.tags = tags;
        this.author = author;
        this.date = date;
        this.fields = fields;
        this.falsePositives = falsePositives;
        this.level = level;
        this.errors = errors;
        if (this.references == null) {
            this.references = new ArrayList<String>();
        }
        if (this.tags == null) {
            this.tags = new ArrayList<SigmaRuleTag>();
        }
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        if (this.falsePositives == null) {
            this.falsePositives = new ArrayList<String>();
        }
    }

    protected static SigmaRule fromDict(Map<String, Object> rule, boolean collectErrors) throws SigmaError {
        SigmaDetections detections;
        SigmaLogSource logSource;
        SigmaStatus status;
        SigmaLevel level;
        UUID ruleId;
        ArrayList<SigmaError> errors = new ArrayList<SigmaError>();
        if (rule.containsKey("id")) {
            try {
                ruleId = UUID.fromString(rule.get("id").toString());
            }
            catch (IllegalArgumentException ex) {
                errors.add(new SigmaIdentifierError("Sigma rule identifier must be an UUID"));
                ruleId = null;
            }
        } else {
            errors.add(new SigmaIdentifierError("Sigma rule identifier must be an UUID"));
            ruleId = null;
        }
        if (rule.containsKey("level")) {
            level = SigmaLevel.valueOf(rule.get("level").toString().toUpperCase(Locale.ROOT));
        } else {
            errors.add(new SigmaLevelError("null is no valid Sigma rule level"));
            level = null;
        }
        if (rule.containsKey("status")) {
            status = SigmaStatus.valueOf(rule.get("status").toString().toUpperCase(Locale.ROOT));
        } else {
            errors.add(new SigmaStatusError("null is no valid Sigma rule status"));
            status = null;
        }
        Date ruleDate = null;
        if (rule.containsKey("date")) {
            try {
                SimpleDateFormat formatter;
                if (rule.get("date").toString().contains("/")) {
                    formatter = new SimpleDateFormat("yyyy/MM/dd", Locale.getDefault());
                    ruleDate = formatter.parse(rule.get("date").toString());
                } else if (rule.get("date").toString().contains("-")) {
                    formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                    ruleDate = formatter.parse(rule.get("date").toString());
                }
            }
            catch (Exception ex) {
                errors.add(new SigmaDateError("Rule date " + rule.get("date").toString() + " is invalid, must be yyyy/mm/dd or yyyy-mm-dd"));
            }
        }
        if (rule.containsKey("logsource")) {
            logSource = SigmaLogSource.fromDict((Map)rule.get("logsource"));
        } else {
            errors.add(new SigmaLogsourceError("Sigma rule must have a log source"));
            logSource = null;
        }
        if (rule.containsKey("detection")) {
            detections = SigmaDetections.fromDict((Map)rule.get("detection"));
        } else {
            errors.add(new SigmaDetectionError("Sigma rule must have a detection definitions"));
            detections = null;
        }
        List ruleTagsStr = (List)rule.get("tags");
        ArrayList<SigmaRuleTag> ruleTags = new ArrayList<SigmaRuleTag>();
        if (ruleTagsStr != null) {
            for (String ruleTag : ruleTagsStr) {
                ruleTags.add(SigmaRuleTag.fromStr(ruleTag));
            }
        }
        if (!collectErrors && !errors.isEmpty()) {
            throw (SigmaError)errors.get(0);
        }
        return new SigmaRule(rule.get("title").toString(), logSource, detections, ruleId, status, rule.get("description").toString(), rule.get("references") != null ? (List)rule.get("references") : null, ruleTags, rule.get("author").toString(), ruleDate, rule.get("fields") != null ? (List)rule.get("fields") : null, rule.get("falsepositives") != null ? (List)rule.get("falsepositives") : null, level, errors);
    }

    public static SigmaRule fromYaml(String rule, boolean collectErrors) throws SigmaError {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setNestingDepthLimit(10);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()), new Representer(new DumperOptions()), new DumperOptions(), loaderOptions);
        Map ruleMap = (Map)yaml.load(rule);
        return SigmaRule.fromDict(ruleMap, collectErrors);
    }

    public String getTitle() {
        return this.title;
    }

    public SigmaLogSource getLogSource() {
        return this.logSource;
    }

    public SigmaDetections getDetection() {
        return this.detection;
    }

    public UUID getId() {
        return this.id;
    }

    public SigmaStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getReferences() {
        return this.references;
    }

    public List<SigmaRuleTag> getTags() {
        return this.tags;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getFalsePositives() {
        return this.falsePositives;
    }

    public SigmaLevel getLevel() {
        return this.level;
    }

    public List<SigmaError> getErrors() {
        return this.errors;
    }
}

