/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.types;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.securityanalytics.rules.exceptions.SigmaRegularExpressionError;
import org.opensearch.securityanalytics.rules.types.SigmaType;

public class SigmaRegularExpression
implements SigmaType {
    private String regexp;

    public SigmaRegularExpression(String regexp) throws SigmaRegularExpressionError {
        this.regexp = regexp.replace(" ", "_ws_");
        this.compile();
    }

    public void compile() throws SigmaRegularExpressionError {
        try {
            Pattern.compile(this.regexp);
        }
        catch (Exception ex) {
            throw new SigmaRegularExpressionError("Regular expression '" + this.regexp + "' is invalid: " + ex.getMessage());
        }
    }

    public String escape(List<String> escaped, String escapeChar) {
        if (escapeChar == null || escapeChar.isEmpty()) {
            escapeChar = "\\";
        }
        ArrayList<String> rList = new ArrayList<String>();
        for (String escape : escaped) {
            rList.add(Pattern.quote(escape));
        }
        rList.add(Pattern.quote(escapeChar));
        String r = String.join((CharSequence)"|", rList);
        ArrayList<Integer> pos = new ArrayList<Integer>();
        pos.add(0);
        Pattern pattern = Pattern.compile(r);
        Matcher matcher = pattern.matcher(this.regexp);
        while (matcher.find()) {
            pos.add(matcher.start());
        }
        pos.add(this.regexp.length());
        ArrayList<String> ranges = new ArrayList<String>();
        for (int i = 0; i < pos.size() - 1; ++i) {
            ranges.add(this.regexp.substring((Integer)pos.get(i), (Integer)pos.get(i + 1)));
        }
        return String.join((CharSequence)escapeChar, ranges);
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public String toString() {
        return this.regexp;
    }
}

