/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;
import org.opensearch.script.IngestScript;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;

public final class ScriptProcessor
extends AbstractProcessor {
    public static final String TYPE = "script";
    private final Script script;
    private final ScriptService scriptService;
    private final IngestScript precompiledIngestScript;

    ScriptProcessor(String tag, String description, Script script, @Nullable IngestScript precompiledIngestScript, ScriptService scriptService) {
        super(tag, description);
        this.script = script;
        this.precompiledIngestScript = precompiledIngestScript;
        this.scriptService = scriptService;
    }

    public IngestDocument execute(IngestDocument document) {
        IngestScript ingestScript;
        if (this.precompiledIngestScript == null) {
            IngestScript.Factory factory = (IngestScript.Factory)this.scriptService.compile(this.script, IngestScript.CONTEXT);
            ingestScript = factory.newInstance(this.script.getParams());
        } else {
            ingestScript = this.precompiledIngestScript;
        }
        ingestScript.execute(document.getSourceAndMetadata());
        CollectionUtils.ensureNoSelfReferences((Object)document.getSourceAndMetadata(), (String)"ingest script");
        return document;
    }

    public String getType() {
        return TYPE;
    }

    Script getScript() {
        return this.script;
    }

    IngestScript getPrecompiledIngestScript() {
        return this.precompiledIngestScript;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        /*
         * Exception decompiling
         */
        public ScriptProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

