/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.kernel;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import org.tribuo.math.kernel.Kernel;
import org.tribuo.math.la.SparseVector;

public class RBF
implements Kernel {
    private static final long serialVersionUID = 1L;
    @Config(mandatory=true, description="Kernel output = exp(-gamma*|u-v|^2).")
    private double gamma;

    private RBF() {
    }

    public RBF(double gamma) {
        this.gamma = gamma;
    }

    @Override
    public double similarity(SparseVector a, SparseVector b) {
        return Math.exp(-this.gamma * Math.pow(a.subtract(b).twoNorm(), 2.0));
    }

    public String toString() {
        return "RBF(gamma=" + this.gamma + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Kernel");
    }
}

