/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class HybridQueryScorer
extends Scorer {
    private final List<Scorer> subScorers;
    private final DisiPriorityQueue subScorersPQ;
    private final float[] subScores;
    private final Map<Query, Integer> queryToIndex;

    public HybridQueryScorer(Weight weight, List<Scorer> subScorers) throws IOException {
        super(weight);
        this.subScorers = Collections.unmodifiableList(subScorers);
        this.subScores = new float[subScorers.size()];
        this.queryToIndex = this.mapQueryToIndex();
        this.subScorersPQ = this.initializeSubScorersPQ();
    }

    public float score() throws IOException {
        DisiWrapper topList = this.subScorersPQ.topList();
        float totalScore = 0.0f;
        DisiWrapper disiWrapper = topList;
        while (disiWrapper != null) {
            if (disiWrapper.scorer.docID() != Integer.MAX_VALUE) {
                totalScore += disiWrapper.scorer.score();
            }
            disiWrapper = disiWrapper.next;
        }
        return totalScore;
    }

    public DocIdSetIterator iterator() {
        return new DisjunctionDISIApproximation(this.subScorersPQ);
    }

    public float getMaxScore(int upTo) throws IOException {
        return this.subScorers.stream().filter(scorer -> scorer.docID() <= upTo).map(scorer -> {
            try {
                return Float.valueOf(scorer.getMaxScore(upTo));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int docID() {
        return this.subScorersPQ.top().doc;
    }

    public float[] hybridScores() throws IOException {
        DisiWrapper topList;
        float[] scores = new float[this.subScores.length];
        DisiWrapper disiWrapper = topList = this.subScorersPQ.topList();
        while (disiWrapper != null) {
            if (disiWrapper.scorer.docID() != Integer.MAX_VALUE) {
                float subScore;
                scores[this.queryToIndex.get((Object)disiWrapper.scorer.getWeight().getQuery()).intValue()] = subScore = disiWrapper.scorer.score();
            }
            disiWrapper = disiWrapper.next;
        }
        return scores;
    }

    private Map<Query, Integer> mapQueryToIndex() {
        HashMap<Query, Integer> queryToIndex = new HashMap<Query, Integer>();
        int idx = 0;
        for (Scorer scorer : this.subScorers) {
            if (scorer == null) {
                ++idx;
                continue;
            }
            queryToIndex.put(scorer.getWeight().getQuery(), idx);
            ++idx;
        }
        return queryToIndex;
    }

    private DisiPriorityQueue initializeSubScorersPQ() {
        Objects.requireNonNull(this.queryToIndex, "should not be null");
        Objects.requireNonNull(this.subScorers, "should not be null");
        DisiPriorityQueue subScorersPQ = new DisiPriorityQueue(this.queryToIndex.size());
        for (Scorer scorer : this.subScorers) {
            if (scorer == null) continue;
            DisiWrapper w = new DisiWrapper(scorer);
            subScorersPQ.add(w);
        }
        return subScorersPQ;
    }

    @Generated
    public List<Scorer> getSubScorers() {
        return this.subScorers;
    }
}

