/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.reflect.Field;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.configuration.FieldAnnotationProcessor;

public class MockAnnotationProcessor
implements FieldAnnotationProcessor<Mock> {
    @Override
    public Object process(Mock annotation, Field field) {
        return MockAnnotationProcessor.processAnnotationForMock(annotation, field.getType(), field.getName());
    }

    public static Object processAnnotationForMock(Mock annotation, Class<?> type, String name) {
        MockSettings mockSettings = Mockito.withSettings();
        if (annotation.extraInterfaces().length > 0) {
            mockSettings.extraInterfaces(annotation.extraInterfaces());
        }
        if ("".equals(annotation.name())) {
            mockSettings.name(name);
        } else {
            mockSettings.name(annotation.name());
        }
        if (annotation.serializable()) {
            mockSettings.serializable();
        }
        if (annotation.stubOnly()) {
            mockSettings.stubOnly();
        }
        mockSettings.defaultAnswer(annotation.answer());
        return Mockito.mock(type, mockSettings);
    }
}

