/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.cluster.service.ClusterManagerService;
import org.opensearch.cluster.service.SourcePrioritizedRunnable;
import org.opensearch.common.util.concurrent.PrioritizedOpenSearchThreadPoolExecutor;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.commons.util.ThreadIDUtil;

public class ClusterManagerServiceEventMetrics
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ClusterManagerServiceEventMetrics.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(ClusterManagerServiceEventMetrics.class);
    private static final int KEYS_PATH_LENGTH = 3;
    private StringBuilder value = new StringBuilder();
    private static final int TPEXECUTOR_ADD_PENDING_PARAM_COUNT = 3;
    private Queue<Runnable> clusterManagerServiceCurrentQueue = null;
    private PrioritizedOpenSearchThreadPoolExecutor prioritizedOpenSearchThreadPoolExecutor = null;
    private HashSet<Object> clusterManagerServiceWorkers = null;
    private long currentThreadId = -1L;
    private Object currentWorker = null;
    @VisibleForTesting
    long lastTaskInsertionOrder = -1L;

    public ClusterManagerServiceEventMetrics() {
        super(SAMPLING_TIME_INTERVAL, "ClusterManagerServiceEventMetrics", (MeasurementSet)StatMetrics.CLUSTER_MANAGER_SERVICE_EVENTS_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.CLUSTER_MANAGER_SERVICE_EVENTS_METRICS_COLLECTOR_ERROR);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 3) {
            throw new RuntimeException("keys length should be 3");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"threads", keysPath[0], "cluster_manager_task", keysPath[1], keysPath[2]});
    }

    public void collectMetrics(long startTime) {
        try {
            if (Objects.isNull(OpenSearchResources.INSTANCE.getClusterService()) || Objects.isNull(OpenSearchResources.INSTANCE.getClusterService().getClusterManagerService())) {
                return;
            }
            this.value.setLength(0);
            Queue<Runnable> current = this.getClusterManagerServiceCurrentQueue();
            if (Objects.isNull(current) || current.size() == 0) {
                this.generateFinishMetrics(startTime);
                return;
            }
            ArrayList pending = new ArrayList();
            Object[] parameters = new Object[]{new ArrayList<Runnable>(current), pending, true};
            this.getPrioritizedTPExecutorAddPendingMethod().invoke((Object)this.prioritizedOpenSearchThreadPoolExecutor, parameters);
            if (pending.size() != 0) {
                PrioritizedOpenSearchThreadPoolExecutor.Pending firstPending = (PrioritizedOpenSearchThreadPoolExecutor.Pending)pending.get(0);
                if (this.lastTaskInsertionOrder != firstPending.insertionOrder) {
                    this.generateFinishMetrics(startTime);
                    SourcePrioritizedRunnable task = (SourcePrioritizedRunnable)firstPending.task;
                    this.lastTaskInsertionOrder = firstPending.insertionOrder;
                    int firstSpaceIndex = task.source().indexOf(" ");
                    this.value.append(PerformanceAnalyzerMetrics.getCurrentTimeMetric());
                    PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_PRIORITY.toString(), (String)firstPending.priority.toString());
                    PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.ClusterManagerMetricValues.START_TIME.toString(), (long)(startTime - (long)(SAMPLING_TIME_INTERVAL / 2)));
                    PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_TYPE.toString(), (String)(firstSpaceIndex == -1 ? task.source() : task.source().substring(0, firstSpaceIndex)));
                    PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_METADATA.toString(), (String)(firstSpaceIndex == -1 ? "" : task.source().substring(firstSpaceIndex)));
                    PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.ClusterManagerMetricDimensions.CLUSTER_MANAGER_TASK_QUEUE_TIME.toString(), (long)task.getAgeInMillis());
                    this.saveMetricValues(this.value.toString(), startTime, new String[]{String.valueOf(this.getClusterManagerThreadId()), String.valueOf(this.lastTaskInsertionOrder), "start"});
                    this.value.setLength(0);
                }
            } else {
                this.generateFinishMetrics(startTime);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((ClusterManagerServiceEventMetrics)this).getCollectorName();
            supplierArray[1] = e::getMessage;
            LOG.debug("[ {} ] Exception raised while getting Cluster Manager throttling metrics: {} ", supplierArray);
            StatsCollector.instance().logException(StatExceptionCode.CLUSTER_MANAGER_SERVICE_EVENTS_METRICS_COLLECTOR_ERROR);
        }
    }

    @VisibleForTesting
    void generateFinishMetrics(long startTime) {
        if (this.lastTaskInsertionOrder != -1L) {
            this.value.append(PerformanceAnalyzerMetrics.getCurrentTimeMetric());
            PerformanceAnalyzerMetrics.addMetricEntry((StringBuilder)this.value, (String)AllMetrics.ClusterManagerMetricValues.FINISH_TIME.toString(), (long)(startTime - (long)(SAMPLING_TIME_INTERVAL / 2)));
            this.saveMetricValues(this.value.toString(), startTime, new String[]{String.valueOf(this.currentThreadId), String.valueOf(this.lastTaskInsertionOrder), "finish"});
            this.value.setLength(0);
            this.lastTaskInsertionOrder = -1L;
        }
    }

    Field getClusterManagerServiceTPExecutorField() throws NoSuchFieldException {
        Field threadPoolExecutorField = ClusterManagerService.class.getSuperclass().getDeclaredField("threadPoolExecutor");
        threadPoolExecutorField.setAccessible(true);
        return threadPoolExecutorField;
    }

    Field getPrioritizedTPExecutorCurrentField() throws NoSuchFieldException {
        Field currentField = PrioritizedOpenSearchThreadPoolExecutor.class.getDeclaredField("current");
        currentField.setAccessible(true);
        return currentField;
    }

    Field getTPExecutorWorkersField() throws NoSuchFieldException {
        Field workersField = ThreadPoolExecutor.class.getDeclaredField("workers");
        workersField.setAccessible(true);
        return workersField;
    }

    Method getPrioritizedTPExecutorAddPendingMethod() throws NoSuchMethodException {
        Class[] classArray = new Class[]{List.class, List.class, Boolean.TYPE};
        Method addPendingMethod = PrioritizedOpenSearchThreadPoolExecutor.class.getDeclaredMethod("addPending", classArray);
        addPendingMethod.setAccessible(true);
        return addPendingMethod;
    }

    Queue<Runnable> getClusterManagerServiceCurrentQueue() throws NoSuchFieldException, IllegalAccessException {
        ClusterManagerService clusterManagerService;
        if (this.clusterManagerServiceCurrentQueue == null && OpenSearchResources.INSTANCE.getClusterService() != null && (clusterManagerService = OpenSearchResources.INSTANCE.getClusterService().getClusterManagerService()) != null) {
            if (this.prioritizedOpenSearchThreadPoolExecutor == null) {
                this.prioritizedOpenSearchThreadPoolExecutor = (PrioritizedOpenSearchThreadPoolExecutor)this.getClusterManagerServiceTPExecutorField().get(clusterManagerService);
            }
            if (this.prioritizedOpenSearchThreadPoolExecutor != null) {
                this.clusterManagerServiceCurrentQueue = (Queue)this.getPrioritizedTPExecutorCurrentField().get(this.prioritizedOpenSearchThreadPoolExecutor);
            } else {
                StatsCollector.instance().logException(StatExceptionCode.CLUSTER_MANAGER_NODE_NOT_UP);
            }
        }
        return this.clusterManagerServiceCurrentQueue;
    }

    HashSet<Object> getClusterManagerServiceWorkers() throws NoSuchFieldException, IllegalAccessException {
        ClusterManagerService clusterManagerService;
        if (this.clusterManagerServiceWorkers == null && OpenSearchResources.INSTANCE.getClusterService() != null && (clusterManagerService = OpenSearchResources.INSTANCE.getClusterService().getClusterManagerService()) != null) {
            if (this.prioritizedOpenSearchThreadPoolExecutor == null) {
                this.prioritizedOpenSearchThreadPoolExecutor = (PrioritizedOpenSearchThreadPoolExecutor)this.getClusterManagerServiceTPExecutorField().get(clusterManagerService);
            }
            this.clusterManagerServiceWorkers = (HashSet)this.getTPExecutorWorkersField().get(this.prioritizedOpenSearchThreadPoolExecutor);
        }
        return this.clusterManagerServiceWorkers;
    }

    long getClusterManagerThreadId() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        HashSet<Object> currentWorkers = this.getClusterManagerServiceWorkers();
        if (currentWorkers.size() > 0) {
            if (currentWorkers.size() > 1) {
                LOG.error("ClusterManager threads are more than 1 (expected); current ClusterManager threads count: {}", (Object)currentWorkers.size());
                this.currentThreadId = -1L;
                this.currentWorker = null;
            } else {
                Object currentTopWorker = currentWorkers.iterator().next();
                if (this.currentWorker != currentTopWorker) {
                    this.currentWorker = currentTopWorker;
                    Thread clusterManagerThread = (Thread)this.getWorkerThreadField().get(this.currentWorker);
                    this.currentThreadId = ThreadIDUtil.INSTANCE.getNativeThreadId(clusterManagerThread.getId());
                }
            }
        } else {
            this.currentThreadId = -1L;
            this.currentWorker = null;
        }
        return this.currentThreadId;
    }

    Field getWorkerThreadField() throws ClassNotFoundException, NoSuchFieldException {
        Class<?> tpExecutorWorkerClass = Class.forName("java.util.concurrent.ThreadPoolExecutor$Worker");
        Field workerField = tpExecutorWorkerClass.getDeclaredField("thread");
        workerField.setAccessible(true);
        return workerField;
    }
}

