/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.queries.function.valuesource.IDFValueSource;
import org.apache.lucene.queries.function.valuesource.TermFreqValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.util.BytesRef;

public class TFValueSource
extends TermFreqValueSource {
    public TFValueSource(String field, String val, String indexedField, BytesRef indexedBytes) {
        super(field, val, indexedField, indexedBytes);
    }

    @Override
    public String name() {
        return "tf";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final Terms terms = Terms.getTerms((LeafReader)readerContext.reader(), (String)this.indexedField);
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        final TFIDFSimilarity similarity = IDFValueSource.asTFIDF(searcher.getSimilarity(), this.indexedField);
        if (similarity == null) {
            throw new UnsupportedOperationException("requires a TFIDFSimilarity (such as ClassicSimilarity)");
        }
        return new FloatDocValues(this){
            PostingsEnum docs;
            int atDoc;
            int lastDocRequested;
            {
                super(vs);
                this.lastDocRequested = -1;
                this.reset();
            }

            public void reset() throws IOException {
                TermsEnum termsEnum = terms.iterator();
                this.docs = termsEnum.seekExact(TFValueSource.this.indexedBytes) ? termsEnum.postings(null) : null;
                if (this.docs == null) {
                    this.docs = new PostingsEnum(){

                        public int freq() {
                            return 0;
                        }

                        public int nextPosition() throws IOException {
                            return -1;
                        }

                        public int startOffset() throws IOException {
                            return -1;
                        }

                        public int endOffset() throws IOException {
                            return -1;
                        }

                        public BytesRef getPayload() throws IOException {
                            return null;
                        }

                        public int docID() {
                            return Integer.MAX_VALUE;
                        }

                        public int nextDoc() {
                            return Integer.MAX_VALUE;
                        }

                        public int advance(int target) {
                            return Integer.MAX_VALUE;
                        }

                        public long cost() {
                            return 0L;
                        }
                    };
                }
                this.atDoc = -1;
            }

            @Override
            public float floatVal(int doc) {
                try {
                    if (doc < this.lastDocRequested) {
                        this.reset();
                    }
                    this.lastDocRequested = doc;
                    if (this.atDoc < doc) {
                        this.atDoc = this.docs.advance(doc);
                    }
                    if (this.atDoc > doc) {
                        return similarity.tf(0.0f);
                    }
                    return similarity.tf((float)this.docs.freq());
                }
                catch (IOException e) {
                    throw new RuntimeException("caught exception in function " + TFValueSource.this.description() + " : doc=" + doc, e);
                }
            }
        };
    }
}

