/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.matchers.Dictionary;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.OmnibusMatcher;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Matching {
    private final Context context;
    protected final Map<String, Map<String, Integer>> rankedDictionaries;

    public Matching(Context context, List<String> orderedList) {
        this.context = context;
        LinkedHashMap<String, Dictionary> dictionaryMap = new LinkedHashMap<String, Dictionary>(context.getDictionaryMap());
        dictionaryMap.put("user_inputs", new Dictionary("user_inputs", orderedList));
        this.rankedDictionaries = Matching.buildRankedDictionaryMap(dictionaryMap);
    }

    public List<Match> omnimatch(CharSequence password) {
        return new OmnibusMatcher(this.context, this.rankedDictionaries).execute(password);
    }

    private static Map<String, Map<String, Integer>> buildRankedDictionaryMap(Map<String, Dictionary> dictionaryMap) {
        HashMap<String, Map<String, Integer>> rankedDictionaries = new HashMap<String, Map<String, Integer>>();
        for (Dictionary dictionary : dictionaryMap.values()) {
            rankedDictionaries.put(dictionary.getName(), dictionary.getRankedDictionary());
        }
        return rankedDictionaries;
    }
}

