/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.cluster;

import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.cluster.HashRing;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.gateway.GatewayService;

public class ADClusterEventListener
implements ClusterStateListener {
    private static final Logger LOG = LogManager.getLogger(ADClusterEventListener.class);
    static final String NOT_RECOVERED_MSG = "Cluster is not recovered yet.";
    static final String IN_PROGRESS_MSG = "Cluster state change in progress, return.";
    static final String NODE_CHANGED_MSG = "Cluster node changed";
    private final Semaphore inProgress;
    private HashRing hashRing;
    private final ClusterService clusterService;

    @Inject
    public ADClusterEventListener(ClusterService clusterService, HashRing hashRing) {
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.hashRing = hashRing;
        this.inProgress = new Semaphore(1);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            LOG.info(NOT_RECOVERED_MSG);
            return;
        }
        if (!this.inProgress.tryAcquire()) {
            LOG.info(IN_PROGRESS_MSG);
            return;
        }
        try {
            DiscoveryNodes.Delta delta;
            if (!this.hashRing.isHashRingInited()) {
                this.hashRing.buildCircles((ActionListener<Boolean>)ActionListener.wrap(r -> LOG.info("Init AD version hash ring successfully"), e -> LOG.error("Failed to init AD version hash ring")));
            }
            if ((delta = event.nodesDelta()).removed() || delta.added()) {
                LOG.info("Cluster node changed, node removed: {}, node added: {}", (Object)delta.removed(), (Object)delta.added());
                this.hashRing.addNodeChangeEvent();
                this.hashRing.buildCircles(delta, (ActionListener<Boolean>)ActionListener.runAfter((ActionListener)ActionListener.wrap(hasRingBuildDone -> LOG.info("Hash ring build result: {}", hasRingBuildDone), e -> LOG.error("Failed updating AD version hash ring", (Throwable)e)), () -> this.inProgress.release()));
            } else {
                this.inProgress.release();
            }
        }
        catch (Exception ex) {
            LOG.error("Cluster state change handler has issue(s)", (Throwable)ex);
            this.inProgress.release();
        }
    }
}

