/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(vec4(0.0, 1e-10, -1e-10, 0.1)) => vec4(0.0, 1e-10, -1e-10, 0.09966865)
 * atan(vec4(-0.1, 1.0, -1.0, 10.0)) => vec4(-0.09966865, 0.7853982, -0.7853982, 1.4711276)
 * atan(vec4(-10.0, 10000000000.0, -10000000000.0, 0.0)) => vec4(-1.4711276, 1.5707964, -1.5707964, 0.0)
 */
#version 120

void main()
{
  float[distance(atan(vec4(0.0, 1e-10, -1e-10, 0.1)), vec4(0.0, 1e-10, -1e-10, 0.09966865)) <= 0.0002 ? 1 : -1] array0;
  float[distance(atan(vec4(-0.1, 1.0, -1.0, 10.0)), vec4(-0.09966865, 0.7853982, -0.7853982, 1.4711276)) <= 0.0018460545 ? 1 : -1] array1;
  float[distance(atan(vec4(-10.0, 10000000000.0, -10000000000.0, 0.0)), vec4(-1.4711276, 1.5707964, -1.5707964, 0.0)) <= 0.0026662743 ? 1 : -1] array2;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length());
}
