/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(16, 24, -23, -25) << 0) => ivec4(16, 24, -23, -25)
 * (ivec4(16, 24, -23, -25) << 1) => ivec4(32, 48, -46, -50)
 * (ivec4(16, 24, -23, -25) << 2) => ivec4(64, 96, -92, -100)
 * (ivec4(16, 24, -23, -25) << 5) => ivec4(512, 768, -736, -800)
 * (ivec4(16, 24, -23, -25) << 25) => ivec4(536870912, 805306368, -771751936, -838860800)
 * (ivec4(16, 24, -23, -25) << 31) => ivec4(0, 0, -2147483648, -2147483648)
 * (ivec4(16, 24, 23, 25) << 0) => ivec4(16, 24, 23, 25)
 * (ivec4(16, 24, 23, 25) << 1) => ivec4(32, 48, 46, 50)
 * (ivec4(16, 24, 23, 25) << 2) => ivec4(64, 96, 92, 100)
 * (ivec4(16, 24, 23, 25) << 5) => ivec4(512, 768, 736, 800)
 * (ivec4(16, 24, 23, 25) << 25) => ivec4(536870912, 805306368, 771751936, 838860800)
 * (ivec4(16, 24, 23, 25) << 31) => ivec4(0, 0, -2147483648, -2147483648)
 * (ivec4(-23, -12, 14, 19) << 0) => ivec4(-23, -12, 14, 19)
 * (ivec4(-23, -12, 14, 19) << 1) => ivec4(-46, -24, 28, 38)
 * (ivec4(-23, -12, 14, 19) << 2) => ivec4(-92, -48, 56, 76)
 * (ivec4(-23, -12, 14, 19) << 5) => ivec4(-736, -384, 448, 608)
 * (ivec4(-23, -12, 14, 19) << 25) => ivec4(-771751936, -402653184, 469762048, 637534208)
 * (ivec4(-23, -12, 14, 19) << 31) => ivec4(-2147483648, 0, 0, -2147483648)
 * (ivec4(23, 12, 14, 19) << 0) => ivec4(23, 12, 14, 19)
 * (ivec4(23, 12, 14, 19) << 1) => ivec4(46, 24, 28, 38)
 * (ivec4(23, 12, 14, 19) << 2) => ivec4(92, 48, 56, 76)
 * (ivec4(23, 12, 14, 19) << 5) => ivec4(736, 384, 448, 608)
 * (ivec4(23, 12, 14, 19) << 25) => ivec4(771751936, 402653184, 469762048, 637534208)
 * (ivec4(23, 12, 14, 19) << 31) => ivec4(-2147483648, 0, 0, -2147483648)
 */
#version 150

void main()
{
  float[all(equal((ivec4(16, 24, -23, -25) << 0), ivec4(16, 24, -23, -25))) ? 1 : -1] array0;
  float[all(equal((ivec4(16, 24, -23, -25) << 1), ivec4(32, 48, -46, -50))) ? 1 : -1] array1;
  float[all(equal((ivec4(16, 24, -23, -25) << 2), ivec4(64, 96, -92, -100))) ? 1 : -1] array2;
  float[all(equal((ivec4(16, 24, -23, -25) << 5), ivec4(512, 768, -736, -800))) ? 1 : -1] array3;
  float[all(equal((ivec4(16, 24, -23, -25) << 25), ivec4(536870912, 805306368, -771751936, -838860800))) ? 1 : -1] array4;
  float[all(equal((ivec4(16, 24, -23, -25) << 31), ivec4(0, 0, -2147483648, -2147483648))) ? 1 : -1] array5;
  float[all(equal((ivec4(16, 24, 23, 25) << 0), ivec4(16, 24, 23, 25))) ? 1 : -1] array6;
  float[all(equal((ivec4(16, 24, 23, 25) << 1), ivec4(32, 48, 46, 50))) ? 1 : -1] array7;
  float[all(equal((ivec4(16, 24, 23, 25) << 2), ivec4(64, 96, 92, 100))) ? 1 : -1] array8;
  float[all(equal((ivec4(16, 24, 23, 25) << 5), ivec4(512, 768, 736, 800))) ? 1 : -1] array9;
  float[all(equal((ivec4(16, 24, 23, 25) << 25), ivec4(536870912, 805306368, 771751936, 838860800))) ? 1 : -1] array10;
  float[all(equal((ivec4(16, 24, 23, 25) << 31), ivec4(0, 0, -2147483648, -2147483648))) ? 1 : -1] array11;
  float[all(equal((ivec4(-23, -12, 14, 19) << 0), ivec4(-23, -12, 14, 19))) ? 1 : -1] array12;
  float[all(equal((ivec4(-23, -12, 14, 19) << 1), ivec4(-46, -24, 28, 38))) ? 1 : -1] array13;
  float[all(equal((ivec4(-23, -12, 14, 19) << 2), ivec4(-92, -48, 56, 76))) ? 1 : -1] array14;
  float[all(equal((ivec4(-23, -12, 14, 19) << 5), ivec4(-736, -384, 448, 608))) ? 1 : -1] array15;
  float[all(equal((ivec4(-23, -12, 14, 19) << 25), ivec4(-771751936, -402653184, 469762048, 637534208))) ? 1 : -1] array16;
  float[all(equal((ivec4(-23, -12, 14, 19) << 31), ivec4(-2147483648, 0, 0, -2147483648))) ? 1 : -1] array17;
  float[all(equal((ivec4(23, 12, 14, 19) << 0), ivec4(23, 12, 14, 19))) ? 1 : -1] array18;
  float[all(equal((ivec4(23, 12, 14, 19) << 1), ivec4(46, 24, 28, 38))) ? 1 : -1] array19;
  float[all(equal((ivec4(23, 12, 14, 19) << 2), ivec4(92, 48, 56, 76))) ? 1 : -1] array20;
  float[all(equal((ivec4(23, 12, 14, 19) << 5), ivec4(736, 384, 448, 608))) ? 1 : -1] array21;
  float[all(equal((ivec4(23, 12, 14, 19) << 25), ivec4(771751936, 402653184, 469762048, 637534208))) ? 1 : -1] array22;
  float[all(equal((ivec4(23, 12, 14, 19) << 31), ivec4(-2147483648, 0, 0, -2147483648))) ? 1 : -1] array23;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length());
}
