/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * dot(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => 8.793899999999999lf
 * dot(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => -2.5038lf
 * dot(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => -2.5038lf
 * dot(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)) => 0.9226000000000001lf
 */
#version 400

void main()
{
  double[distance(dot(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), 8.793899999999999lf) <= 8.7939e-05lf ? 1 : -1] array0;
  double[distance(dot(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), -2.5038lf) <= 2.5038000000000003e-05lf ? 1 : -1] array1;
  double[distance(dot(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), -2.5038lf) <= 2.5038000000000003e-05lf ? 1 : -1] array2;
  double[distance(dot(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf)), 0.9226000000000001lf) <= 9.226000000000001e-06lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
