###########################################
# Init settings for puppetdb
###########################################

# Location of your Java binary (version 8)
JAVA_BIN="$(javaPathHelper -c puppetdb)"

# Modify this if you'd like to change the memory allocation, enable JMX, etc
JAVA_ARGS="-Xmx192m -Djdk.tls.ephemeralDHKeySize=2048"

# Modify this as you would JAVA_ARGS but for non-service related subcommands
JAVA_ARGS_CLI="${JAVA_ARGS_CLI:-}"

# Modify this if you'd like TrapperKeeper specific arguments
TK_ARGS=""

# These normally shouldn't need to be edited if using OS packages
USER="_puppetdb"
GROUP="_puppetdb"
INSTALL_DIR="/usr/local/share/puppetlabs/puppetdb"
CONFIG="/etc/puppetlabs/puppetdb/conf.d"

# Bootstrap path
BOOTSTRAP_CONFIG="/etc/puppetlabs/puppetdb/bootstrap.cfg"

# SERVICE_STOP_RETRIES can be set here to alter the default stop timeout in
# seconds.  For systemd, the shorter of this setting or 'TimeoutStopSec' in
# the systemd.service definition will effectively be the timeout which is used.
SERVICE_STOP_RETRIES=60

# START_TIMEOUT can be set here to alter the default startup timeout in
# seconds.  For systemd, the shorter of this setting or 'TimeoutStartSec'
# in the service's systemd.service configuration file will effectively be the
# timeout which is used.
START_TIMEOUT=14400


# Maximum number of seconds that can expire for a service reload attempt before
# the result of the attempt is interpreted as a failure.
RELOAD_TIMEOUT=120
