/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class GoogleGeocoder
extends JsonGeocoder {
    private static String formatUrl(String key, String language) {
        Object url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=%f,%f";
        if (key != null) {
            url = (String)url + "&key=" + key;
        }
        if (language != null) {
            url = (String)url + "&language=" + language;
        }
        return url;
    }

    public GoogleGeocoder(Client client, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, GoogleGeocoder.formatUrl(key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray results = json.getJsonArray("results");
        if (!results.isEmpty()) {
            Address address = new Address();
            JsonObject result = (JsonObject)results.get(0);
            JsonArray components = result.getJsonArray("address_components");
            if (result.containsKey((Object)"formatted_address")) {
                address.setFormattedAddress(result.getString("formatted_address"));
            }
            block18: for (JsonObject component : components.getValuesAs(JsonObject.class)) {
                String value = component.getString("short_name");
                for (JsonString type : component.getJsonArray("types").getValuesAs(JsonString.class)) {
                    switch (type.getString()) {
                        case "street_number": {
                            address.setHouse(value);
                            continue block18;
                        }
                        case "route": {
                            address.setStreet(value);
                            continue block18;
                        }
                        case "locality": {
                            address.setSettlement(value);
                            continue block18;
                        }
                        case "administrative_area_level_2": {
                            address.setDistrict(value);
                            continue block18;
                        }
                        case "administrative_area_level_1": {
                            address.setState(value);
                            continue block18;
                        }
                        case "country": {
                            address.setCountry(value);
                            continue block18;
                        }
                        case "postal_code": {
                            address.setPostcode(value);
                            continue block18;
                        }
                    }
                }
            }
            return address;
        }
        return null;
    }

    @Override
    protected String parseError(JsonObject json) {
        return json.getString("error_message");
    }
}

