/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.protocol.RuptelaProtocolEncoder;
import org.traccar.session.DeviceSession;

public class RuptelaProtocolDecoder
extends BaseProtocolDecoder {
    private ByteBuf photo;
    public static final int MSG_RECORDS = 1;
    public static final int MSG_DEVICE_CONFIGURATION = 2;
    public static final int MSG_DEVICE_VERSION = 3;
    public static final int MSG_FIRMWARE_UPDATE = 4;
    public static final int MSG_SET_CONNECTION = 5;
    public static final int MSG_SET_ODOMETER = 6;
    public static final int MSG_SMS_VIA_GPRS_RESPONSE = 7;
    public static final int MSG_SMS_VIA_GPRS = 8;
    public static final int MSG_DTCS = 9;
    public static final int MSG_IDENTIFICATION = 15;
    public static final int MSG_HEARTBEAT = 16;
    public static final int MSG_SET_IO = 17;
    public static final int MSG_FILES = 37;
    public static final int MSG_EXTENDED_RECORDS = 68;

    public RuptelaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeCommandResponse(DeviceSession deviceSession, int type, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("type", type);
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                position.set("result", buf.toString(buf.readerIndex(), buf.readableBytes() - 2, StandardCharsets.US_ASCII).trim());
                return position;
            }
            case 17: {
                position.set("result", String.valueOf(buf.readUnsignedByte()));
                return position;
            }
        }
        return null;
    }

    private long readValue(ByteBuf buf, int length, boolean signed) {
        switch (length) {
            case 1: {
                return signed ? (long)buf.readByte() : (long)buf.readUnsignedByte();
            }
            case 2: {
                return signed ? (long)buf.readShort() : (long)buf.readUnsignedShort();
            }
            case 4: {
                return signed ? (long)buf.readInt() : buf.readUnsignedInt();
            }
        }
        return buf.readLong();
    }

    private void decodeDriver(Position position, String part1, String part2) {
        Long driverIdPart1 = (Long)position.getAttributes().remove(part1);
        Long driverIdPart2 = (Long)position.getAttributes().remove(part2);
        if (driverIdPart1 != null && driverIdPart2 != null) {
            ByteBuf driverId = Unpooled.copyLong((long[])new long[]{driverIdPart1, driverIdPart2});
            position.set("driverUniqueId", driverId.toString(StandardCharsets.US_ASCII));
            driverId.release();
        }
    }

    private void decodeParameter(Position position, int id, ByteBuf buf, int length) {
        switch (id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                position.set("in" + (id - 1), this.readValue(buf, length, false));
                break;
            }
            case 13: 
            case 173: {
                position.set("motion", this.readValue(buf, length, false) > 0L);
                break;
            }
            case 20: {
                position.set("adc3", this.readValue(buf, length, false));
                break;
            }
            case 21: {
                position.set("adc4", this.readValue(buf, length, false));
                break;
            }
            case 22: {
                position.set("adc1", this.readValue(buf, length, false));
                break;
            }
            case 23: {
                position.set("adc2", this.readValue(buf, length, false));
                break;
            }
            case 29: {
                position.set("power", (double)this.readValue(buf, length, false) * 0.001);
                break;
            }
            case 30: {
                position.set("battery", (double)this.readValue(buf, length, false) * 0.001);
                break;
            }
            case 32: {
                position.set("deviceTemp", this.readValue(buf, length, true));
                break;
            }
            case 39: {
                position.set("engineLoad", this.readValue(buf, length, true));
                break;
            }
            case 65: {
                position.set("odometer", this.readValue(buf, length, true));
                break;
            }
            case 74: {
                position.set("temp3", (double)this.readValue(buf, length, true) * 0.1);
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                position.set("temp" + (id - 78), (double)this.readValue(buf, length, true) * 0.1);
                break;
            }
            case 88: {
                if (this.readValue(buf, length, false) <= 0L) break;
                position.set("alarm", "jamming");
                break;
            }
            case 94: {
                position.set("rpm", (double)this.readValue(buf, length, true) * 0.25);
                break;
            }
            case 95: {
                position.set("obdSpeed", this.readValue(buf, length, true));
                break;
            }
            case 98: {
                position.set("fuel", (double)(this.readValue(buf, length, true) * 100L) / 255.0);
                break;
            }
            case 100: {
                position.set("fuelConsumption", (double)this.readValue(buf, length, true) / 20.0);
                break;
            }
            case 134: {
                if (this.readValue(buf, length, false) <= 0L) break;
                position.set("alarm", "hardBraking");
                break;
            }
            case 136: {
                if (this.readValue(buf, length, false) <= 0L) break;
                position.set("alarm", "hardAcceleration");
                break;
            }
            case 150: {
                position.set("operator", this.readValue(buf, length, false));
                break;
            }
            case 163: {
                position.set("odometer", this.readValue(buf, length, false) * 5L);
                break;
            }
            case 164: {
                position.set("tripOdometer", this.readValue(buf, length, false) * 5L);
                break;
            }
            case 165: {
                position.set("obdSpeed", (double)this.readValue(buf, length, false) / 256.0);
                break;
            }
            case 166: 
            case 197: {
                position.set("rpm", (double)this.readValue(buf, length, false) * 0.125);
                break;
            }
            case 170: {
                position.set("charge", this.readValue(buf, length, false) > 0L);
                break;
            }
            case 205: {
                position.set("fuel", this.readValue(buf, length, false));
                break;
            }
            case 207: {
                position.set("fuel", (double)this.readValue(buf, length, false) * 0.4);
                break;
            }
            case 208: {
                position.set("fuelUsed", (double)this.readValue(buf, length, false) * 0.5);
                break;
            }
            case 251: 
            case 409: {
                position.set("ignition", this.readValue(buf, length, false) > 0L);
                break;
            }
            case 410: {
                if (this.readValue(buf, length, false) <= 0L) break;
                position.set("alarm", "tow");
                break;
            }
            case 411: {
                if (this.readValue(buf, length, false) <= 0L) break;
                position.set("alarm", "accident");
                break;
            }
            case 415: {
                if (this.readValue(buf, length, false) != 0L) break;
                position.set("alarm", "gpsAntennaCut");
                break;
            }
            case 645: {
                position.set("obdOdometer", this.readValue(buf, length, true) * 1000L);
                break;
            }
            case 758: {
                if (this.readValue(buf, length, false) != 1L) break;
                position.set("alarm", "tampering");
                break;
            }
            default: {
                position.set("io" + id, this.readValue(buf, length, false));
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedShort();
        String imei = String.format("%015d", buf.readLong());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        short type = buf.readUnsignedByte();
        if (type == 1 || type == 68) {
            LinkedList<Position> positions = new LinkedList<Position>();
            buf.readUnsignedByte();
            int count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                int id;
                int j;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.setTime(new Date(buf.readUnsignedInt() * 1000L));
                buf.readUnsignedByte();
                if (type == 68) {
                    short recordExtension = buf.readUnsignedByte();
                    int mergeRecordCount = BitUtil.from(recordExtension, 4);
                    int currentRecord = BitUtil.to(recordExtension, 4);
                    if (currentRecord > 0 && currentRecord <= mergeRecordCount) {
                        if (positions.size() == 0) {
                            this.getLastLocation(position, null);
                        } else {
                            position = (Position)positions.remove(positions.size() - 1);
                        }
                    }
                }
                buf.readUnsignedByte();
                int longitude = buf.readInt();
                int latitude = buf.readInt();
                if (longitude > Integer.MIN_VALUE && latitude > Integer.MIN_VALUE) {
                    position.setValid(true);
                    position.setLongitude((double)longitude / 1.0E7);
                    position.setLatitude((double)latitude / 1.0E7);
                    position.setAltitude((double)buf.readUnsignedShort() / 10.0);
                    position.setCourse((double)buf.readUnsignedShort() / 100.0);
                    position.set("sat", buf.readUnsignedByte());
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
                    position.set("hdop", (double)buf.readUnsignedByte() / 10.0);
                } else {
                    buf.skipBytes(8);
                    this.getLastLocation(position, null);
                }
                if (type == 68) {
                    position.set("event", buf.readUnsignedShort());
                } else {
                    position.set("event", buf.readUnsignedByte());
                }
                int valueCount = buf.readUnsignedByte();
                for (j = 0; j < valueCount; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 1);
                }
                valueCount = buf.readUnsignedByte();
                for (j = 0; j < valueCount; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 2);
                }
                valueCount = buf.readUnsignedByte();
                for (j = 0; j < valueCount; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 4);
                }
                valueCount = buf.readUnsignedByte();
                for (j = 0; j < valueCount; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 8);
                }
                this.decodeDriver(position, "io126", "io127");
                this.decodeDriver(position, "io155", "io156");
                Long tagIdPart1 = (Long)position.getAttributes().remove("io760");
                Long tagIdPart2 = (Long)position.getAttributes().remove("io761");
                if (tagIdPart1 != null && tagIdPart2 != null) {
                    position.set("tagId", Long.toHexString(tagIdPart1) + Long.toHexString(tagIdPart2));
                }
                positions.add(position);
            }
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])DataConverter.parseHex("0002640113bc")), remoteAddress));
            }
            return positions;
        }
        if (type == 9) {
            LinkedList<Position> positions = new LinkedList<Position>();
            int count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                buf.readUnsignedByte();
                position.setTime(new Date(buf.readUnsignedInt() * 1000L));
                position.setValid(true);
                position.setLongitude((double)buf.readInt() / 1.0E7);
                position.setLatitude((double)buf.readInt() / 1.0E7);
                if (buf.readUnsignedByte() == 2) {
                    position.set("archive", true);
                }
                position.set("dtcs", buf.readSlice(5).toString(StandardCharsets.US_ASCII));
                positions.add(position);
            }
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])DataConverter.parseHex("00026d01c4a4")), remoteAddress));
            }
            return positions;
        }
        if (type == 37) {
            short subtype = buf.readUnsignedByte();
            short source = buf.readUnsignedByte();
            if (subtype == 2) {
                ByteBuf filename = buf.readSlice(8);
                int total = buf.readUnsignedShort();
                int current = buf.readUnsignedShort();
                if (this.photo == null) {
                    this.photo = Unpooled.buffer();
                }
                this.photo.writeBytes(buf.readSlice(buf.readableBytes() - 2));
                if (current < total - 1) {
                    ByteBuf content = Unpooled.buffer();
                    content.writeByte((int)subtype);
                    content.writeByte((int)source);
                    content.writeBytes(filename);
                    content.writeShort(current + 1);
                    ByteBuf response = RuptelaProtocolEncoder.encodeContent(type, content);
                    content.release();
                    if (channel != null) {
                        channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                    }
                } else {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    this.getLastLocation(position, null);
                    position.set("image", this.writeMediaFile(imei, this.photo, "jpg"));
                    this.photo.release();
                    this.photo = null;
                    return position;
                }
            }
            return null;
        }
        if (type == 15 || type == 16) {
            ByteBuf content = Unpooled.buffer();
            content.writeByte(1);
            ByteBuf response = RuptelaProtocolEncoder.encodeContent(type, content);
            content.release();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return null;
        }
        return this.decodeCommandResponse(deviceSession, type, buf);
    }
}

