/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import java.io.IOException;
import nu.validator.xml.PermutingAttributesWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class AttributesPermutingXMLReaderWrapper
implements XMLReader,
ContentHandler {
    private final XMLReader wrappedReader;
    private ContentHandler contentHandler;

    public AttributesPermutingXMLReaderWrapper(XMLReader wrappedReader) {
        this.wrappedReader = wrappedReader;
        this.contentHandler = wrappedReader.getContentHandler();
        wrappedReader.setContentHandler(this);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if ("http://www.w3.org/1999/xhtml" == uri) {
            if (("input" == localName || "command" == localName) && atts.getIndex("", "type") > 0) {
                PermutingAttributesWrapper wrap = new PermutingAttributesWrapper(atts);
                wrap.pullUp("", "role");
                wrap.pullUp("", "type");
                wrap.pullUp("", "template");
                this.contentHandler.startElement(uri, localName, qName, wrap);
            } else if ("textarea" == localName && atts.getIndex("", "wrap") > 0) {
                PermutingAttributesWrapper wrap = new PermutingAttributesWrapper(atts);
                wrap.pullUp("", "wrap");
                wrap.pullUp("", "template");
                this.contentHandler.startElement(uri, localName, qName, wrap);
            } else if ("script" == localName && atts.getIndex("", "src") > 0) {
                PermutingAttributesWrapper wrap = new PermutingAttributesWrapper(atts);
                wrap.pullUp("", "src");
                wrap.pullUp("", "template");
                this.contentHandler.startElement(uri, localName, qName, wrap);
            } else if ("meta" == localName && atts.getIndex("", "content") < atts.getLength() - 1) {
                PermutingAttributesWrapper wrap = new PermutingAttributesWrapper(atts);
                wrap.pushDown("", "content");
                wrap.pullUp("", "template");
                this.contentHandler.startElement(uri, localName, qName, wrap);
            } else if (atts.getIndex("", "template") > 0 || atts.getIndex("", "role") > 0) {
                PermutingAttributesWrapper wrap = new PermutingAttributesWrapper(atts);
                wrap.pullUp("", "role");
                wrap.pullUp("", "template");
                this.contentHandler.startElement(uri, localName, qName, wrap);
            } else {
                this.contentHandler.startElement(uri, localName, qName, atts);
            }
        } else {
            this.contentHandler.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.wrappedReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.wrappedReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.wrappedReader.getErrorHandler();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getProperty(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.wrappedReader.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.wrappedReader.parse(systemId);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.wrappedReader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.wrappedReader.setEntityResolver(resolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.wrappedReader.setErrorHandler(handler);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setFeature(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setProperty(name, value);
    }
}

