<?php

declare(strict_types=1);

/*
 * eduVPN - End-user friendly VPN.
 *
 * Copyright: 2014-2023, The Commons Conservancy eduVPN Programme
 * SPDX-License-Identifier: AGPL-3.0+
 */

namespace Vpn\Portal\Cfg;

class WireGuardConfig
{
    use ConfigTrait;

    private array $configData;

    public function __construct(array $configData)
    {
        $this->configData = $configData;
    }

    public function setMtu(): ?int
    {
        return $this->optionalInt('setMtu');
    }

    public function listenPort(): int
    {
        return $this->requireInt('listenPort', 51820);
    }
}
