/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_dcerpc
#define _PIDL_HEADER_dcerpc

#include <stdint.h>

#include <core/ntstatus.h>

#include <gen_ndr/misc.h>
extern const uint8_t DCERPC_SEC_VT_MAGIC[8];
#ifndef _HEADER_dcerpc
#define _HEADER_dcerpc

#define DCERPC_REQUEST_LENGTH	( 24 )
#define DCERPC_BIND_PROVIDER_REJECT	( DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION )
#define DCERPC_BIND_REASON_ASYNTAX	( DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED )
#define DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED	( DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED )
#define DCERPC_BIND_REASON_INVALID_AUTH_TYPE	( DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE )
#define DCERPC_RESPONSE_LENGTH	( 24 )
#define DCERPC_FAULT_OP_RNG_ERROR	( DCERPC_NCA_S_OP_RNG_ERROR )
#define DCERPC_FAULT_NDR	( DCERPC_FAULT_BAD_STUB_DATA )
#define DCERPC_FAULT_INVALID_TAG	( DCERPC_NCA_S_FAULT_INVALID_TAG )
#define DCERPC_FAULT_CONTEXT_MISMATCH	( DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH )
#define DCERPC_FAULT_OTHER	( 0x00000001 )
#define DCERPC_FAULT_TODO	( 0x00000042 )
#define DCERPC_FAULT_LENGTH	( 32 )
#define AS_SYSTEM_MAGIC_PATH_TOKEN	( "/root/ncalrpc_as_system" )
#define DCERPC_AUTH_TRAILER_LENGTH	( 8 )
#define DCERPC_AUTH_PAD_ALIGNMENT	( 16 )
#define DCERPC_PFC_FLAG_PENDING_CANCEL	( DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING )
#define DCERPC_PFC_FLAG_SUPPORT_HEADER_SIGN	( DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING )
#define DCERPC_PFC_OFFSET	( 3 )
#define DCERPC_DREP_OFFSET	( 4 )
#define DCERPC_FRAG_LEN_OFFSET	( 8 )
#define DCERPC_FRAG_MAX_SIZE	( 5840 )
#define DCERPC_AUTH_LEN_OFFSET	( 10 )
#define DCERPC_NCACN_PAYLOAD_OFFSET	( 16 )
#define DCERPC_NCACN_REQUEST_DEFAULT_MAX_SIZE	( 0x400000 )
#define DCERPC_NCACN_RESPONSE_DEFAULT_MAX_SIZE	( 0xf000000 )
#define DCERPC_DREP_LE	( 0x10 )
#define DCERPC_SEC_VT_MAX_SIZE	( 1024 )
struct dcerpc_ctx_list {
	uint16_t context_id;
	uint8_t num_transfer_syntaxes;
	struct ndr_syntax_id abstract_syntax;
	struct ndr_syntax_id *transfer_syntaxes;
};

struct dcerpc_bind {
	uint16_t max_xmit_frag;
	uint16_t max_recv_frag;
	uint32_t assoc_group_id;
	uint8_t num_contexts;
	struct dcerpc_ctx_list *ctx_list;
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_empty {
	char _empty_;
};

union dcerpc_object {
	struct GUID object;/* [default] */
	struct dcerpc_empty empty;/* [case(false)] */
}/* [nodiscriminant] */;

struct dcerpc_request {
	uint32_t alloc_hint;
	uint16_t context_id;
	uint16_t opnum;
	union dcerpc_object object;/* [switch_is(NDR_DCERPC_REQUEST_OBJECT_PRESENT)] */
	DATA_BLOB stub_and_verifier;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

enum dcerpc_bind_ack_result
#ifndef USE_UINT_ENUMS
 {
	DCERPC_BIND_ACK_RESULT_ACCEPTANCE=(int)(0),
	DCERPC_BIND_ACK_RESULT_USER_REJECTION=(int)(1),
	DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION=(int)(2),
	DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK=(int)(3)
}
#else
 { __do_not_use_enum_dcerpc_bind_ack_result=INT_MAX}
#define DCERPC_BIND_ACK_RESULT_ACCEPTANCE ( 0 )
#define DCERPC_BIND_ACK_RESULT_USER_REJECTION ( 1 )
#define DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION ( 2 )
#define DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK ( 3 )
#endif
;

enum dcerpc_bind_ack_reason_values
#ifndef USE_UINT_ENUMS
 {
	DCERPC_BIND_ACK_REASON_NOT_SPECIFIED=(int)(0),
	DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED=(int)(1),
	DCERPC_BIND_ACK_REASON_TRANSFER_SYNTAXES_NOT_SUPPORTED=(int)(2),
	DCERPC_BIND_ACK_REASON_LOCAL_LIMIT_EXCEEDED=(int)(3)
}
#else
 { __do_not_use_enum_dcerpc_bind_ack_reason_values=INT_MAX}
#define DCERPC_BIND_ACK_REASON_NOT_SPECIFIED ( 0 )
#define DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED ( 1 )
#define DCERPC_BIND_ACK_REASON_TRANSFER_SYNTAXES_NOT_SUPPORTED ( 2 )
#define DCERPC_BIND_ACK_REASON_LOCAL_LIMIT_EXCEEDED ( 3 )
#endif
;

/* bitmap dcerpc_bind_time_features */
#define DCERPC_BIND_TIME_SECURITY_CONTEXT_MULTIPLEXING ( 0x0001 )
#define DCERPC_BIND_TIME_KEEP_CONNECTION_ON_ORPHAN ( 0x0002 )

union dcerpc_bind_ack_reason {
	uint16_t negotiate;/* [case(DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK)] */
	enum dcerpc_bind_ack_reason_values value;/* [default] */
}/* [nodiscriminant] */;

struct dcerpc_ack_ctx {
	enum dcerpc_bind_ack_result result;
	union dcerpc_bind_ack_reason reason;/* [switch_is(result)] */
	struct ndr_syntax_id syntax;
};

struct dcerpc_bind_ack {
	uint16_t max_xmit_frag;
	uint16_t max_recv_frag;
	uint32_t assoc_group_id;
	uint16_t secondary_address_size;/* [value(strlen_m_term_null(secondary_address))] */
	const char *secondary_address;/* [charset(DOS)] */
	DATA_BLOB _pad1;/* [flag(LIBNDR_FLAG_ALIGN4)] */
	uint8_t num_results;
	struct dcerpc_ack_ctx *ctx_list;
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

enum dcerpc_bind_nak_reason
#ifndef USE_UINT_ENUMS
 {
	DCERPC_BIND_NAK_REASON_NOT_SPECIFIED=(int)(0),
	DCERPC_BIND_NAK_REASON_TEMPORARY_CONGESTION=(int)(1),
	DCERPC_BIND_NAK_REASON_LOCAL_LIMIT_EXCEEDED=(int)(2),
	DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED=(int)(4),
	DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE=(int)(8),
	DCERPC_BIND_NAK_REASON_INVALID_CHECKSUM=(int)(9)
}
#else
 { __do_not_use_enum_dcerpc_bind_nak_reason=INT_MAX}
#define DCERPC_BIND_NAK_REASON_NOT_SPECIFIED ( 0 )
#define DCERPC_BIND_NAK_REASON_TEMPORARY_CONGESTION ( 1 )
#define DCERPC_BIND_NAK_REASON_LOCAL_LIMIT_EXCEEDED ( 2 )
#define DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED ( 4 )
#define DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE ( 8 )
#define DCERPC_BIND_NAK_REASON_INVALID_CHECKSUM ( 9 )
#endif
;

struct dcerpc_bind_nak_version {
	uint8_t rpc_vers;
	uint8_t rpc_vers_minor;
}/* [public] */;

struct dcerpc_bind_nak {
	enum dcerpc_bind_nak_reason reject_reason;
	uint8_t num_versions;
	struct dcerpc_bind_nak_version *versions;
	DATA_BLOB _pad;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [nopull,public] */;

struct dcerpc_response {
	uint32_t alloc_hint;
	uint16_t context_id;
	uint8_t cancel_count;
	uint8_t reserved;/* [value(0)] */
	DATA_BLOB stub_and_verifier;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

enum dcerpc_nca_status
#ifndef USE_UINT_ENUMS
 {
	DCERPC_NCA_S_COMM_FAILURE=(int)(0x1C010001),
	DCERPC_NCA_S_OP_RNG_ERROR=(int)(0x1C010002),
	DCERPC_NCA_S_UNKNOWN_IF=(int)(0x1C010003),
	DCERPC_NCA_S_WRONG_BOOT_TIME=(int)(0x1C010006),
	DCERPC_NCA_S_YOU_CRASHED=(int)(0x1C010009),
	DCERPC_NCA_S_PROTO_ERROR=(int)(0x1C01000B),
	DCERPC_NCA_S_OUT_ARGS_TOO_BIG=(int)(0x1C010013),
	DCERPC_NCA_S_SERVER_TOO_BUSY=(int)(0x1C010014),
	DCERPC_NCA_S_FAULT_STRING_TOO_LARGE=(int)(0x1C010015),
	DCERPC_NCA_S_UNSUPPORTED_TYPE=(int)(0x1C010017),
	DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO=(int)(0x1C000001),
	DCERPC_NCA_S_FAULT_ADDR_ERROR=(int)(0x1C000002),
	DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO=(int)(0x1C000003),
	DCERPC_NCA_S_FAULT_FP_UNDERFLOW=(int)(0x1C000004),
	DCERPC_NCA_S_FAULT_FP_OVERRFLOW=(int)(0x1C000005),
	DCERPC_NCA_S_FAULT_INVALID_TAG=(int)(0x1C000006),
	DCERPC_NCA_S_FAULT_INVALID_BOUND=(int)(0x1C000007),
	DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH=(int)(0x1C000008),
	DCERPC_NCA_S_FAULT_UNSPEC_REJECT=(int)(0x1C000009),
	DCERPC_NCA_S_FAULT_BAD_ACTID=(int)(0x1C00000A),
	DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED=(int)(0x1C00000B),
	DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED=(int)(0x1C00000C),
	DCERPC_NCA_S_FAULT_CANCEL=(int)(0x1C00000D),
	DCERPC_NCA_S_FAULT_ILL_INST=(int)(0x1C00000E),
	DCERPC_NCA_S_FAULT_FP_ERROR=(int)(0x1C00000F),
	DCERPC_NCA_S_FAULT_INT_OVERFLOW=(int)(0x1C000010),
	DCERPC_NCA_S_UNUSED_1C000011=(int)(0x1C000011),
	DCERPC_NCA_S_FAULT_UNSPEC=(int)(0x1C000012),
	DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE=(int)(0x1C000013),
	DCERPC_NCA_S_FAULT_PIPE_EMPTY=(int)(0x1C000014),
	DCERPC_NCA_S_FAULT_PIPE_CLOSED=(int)(0x1C000015),
	DCERPC_NCA_S_FAULT_PIPE_ORDER=(int)(0x1C000016),
	DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE=(int)(0x1C000017),
	DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR=(int)(0x1C000018),
	DCERPC_NCA_S_FAULT_PIPE_MEMORY=(int)(0x1C000019),
	DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH=(int)(0x1C00001A),
	DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY=(int)(0x1C00001B),
	DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID=(int)(0x1C00001C),
	DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL=(int)(0x1C00001D),
	DCERPC_NCA_S_UNUSED_1C00001E=(int)(0x1C00001E),
	DCERPC_NCA_S_INVALID_CHECKSUM=(int)(0x1C00001F),
	DCERPC_NCA_S_INVALID_CRC=(int)(0x1C000020),
	DCERPC_NCA_S_FAULT_USER_DEFINED=(int)(0x1C000021),
	DCERPC_NCA_S_FAULT_TX_OPEN_FAILED=(int)(0x1C000022),
	DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR=(int)(0x1C000023),
	DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND=(int)(0x1C000024),
	DCERPC_NCA_S_FAULT_NO_CLIENT_STUB=(int)(0x1C000025),
	DCERPC_FAULT_ACCESS_DENIED=(int)(0x00000005),
	DCERPC_FAULT_SERVER_UNAVAILABLE=(int)(0x000006ba),
	DCERPC_FAULT_NO_CALL_ACTIVE=(int)(0x000006bd),
	DCERPC_FAULT_CANT_PERFORM=(int)(0x000006d8),
	DCERPC_FAULT_OUT_OF_RESOURCES=(int)(0x000006d9),
	DCERPC_FAULT_BAD_STUB_DATA=(int)(0x000006f7),
	DCERPC_FAULT_SEC_PKG_ERROR=(int)(0x00000721)
}
#else
 { __do_not_use_enum_dcerpc_nca_status=INT_MAX}
#define DCERPC_NCA_S_COMM_FAILURE ( 0x1C010001 )
#define DCERPC_NCA_S_OP_RNG_ERROR ( 0x1C010002 )
#define DCERPC_NCA_S_UNKNOWN_IF ( 0x1C010003 )
#define DCERPC_NCA_S_WRONG_BOOT_TIME ( 0x1C010006 )
#define DCERPC_NCA_S_YOU_CRASHED ( 0x1C010009 )
#define DCERPC_NCA_S_PROTO_ERROR ( 0x1C01000B )
#define DCERPC_NCA_S_OUT_ARGS_TOO_BIG ( 0x1C010013 )
#define DCERPC_NCA_S_SERVER_TOO_BUSY ( 0x1C010014 )
#define DCERPC_NCA_S_FAULT_STRING_TOO_LARGE ( 0x1C010015 )
#define DCERPC_NCA_S_UNSUPPORTED_TYPE ( 0x1C010017 )
#define DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO ( 0x1C000001 )
#define DCERPC_NCA_S_FAULT_ADDR_ERROR ( 0x1C000002 )
#define DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO ( 0x1C000003 )
#define DCERPC_NCA_S_FAULT_FP_UNDERFLOW ( 0x1C000004 )
#define DCERPC_NCA_S_FAULT_FP_OVERRFLOW ( 0x1C000005 )
#define DCERPC_NCA_S_FAULT_INVALID_TAG ( 0x1C000006 )
#define DCERPC_NCA_S_FAULT_INVALID_BOUND ( 0x1C000007 )
#define DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH ( 0x1C000008 )
#define DCERPC_NCA_S_FAULT_UNSPEC_REJECT ( 0x1C000009 )
#define DCERPC_NCA_S_FAULT_BAD_ACTID ( 0x1C00000A )
#define DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED ( 0x1C00000B )
#define DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED ( 0x1C00000C )
#define DCERPC_NCA_S_FAULT_CANCEL ( 0x1C00000D )
#define DCERPC_NCA_S_FAULT_ILL_INST ( 0x1C00000E )
#define DCERPC_NCA_S_FAULT_FP_ERROR ( 0x1C00000F )
#define DCERPC_NCA_S_FAULT_INT_OVERFLOW ( 0x1C000010 )
#define DCERPC_NCA_S_UNUSED_1C000011 ( 0x1C000011 )
#define DCERPC_NCA_S_FAULT_UNSPEC ( 0x1C000012 )
#define DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE ( 0x1C000013 )
#define DCERPC_NCA_S_FAULT_PIPE_EMPTY ( 0x1C000014 )
#define DCERPC_NCA_S_FAULT_PIPE_CLOSED ( 0x1C000015 )
#define DCERPC_NCA_S_FAULT_PIPE_ORDER ( 0x1C000016 )
#define DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE ( 0x1C000017 )
#define DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR ( 0x1C000018 )
#define DCERPC_NCA_S_FAULT_PIPE_MEMORY ( 0x1C000019 )
#define DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH ( 0x1C00001A )
#define DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY ( 0x1C00001B )
#define DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID ( 0x1C00001C )
#define DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL ( 0x1C00001D )
#define DCERPC_NCA_S_UNUSED_1C00001E ( 0x1C00001E )
#define DCERPC_NCA_S_INVALID_CHECKSUM ( 0x1C00001F )
#define DCERPC_NCA_S_INVALID_CRC ( 0x1C000020 )
#define DCERPC_NCA_S_FAULT_USER_DEFINED ( 0x1C000021 )
#define DCERPC_NCA_S_FAULT_TX_OPEN_FAILED ( 0x1C000022 )
#define DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR ( 0x1C000023 )
#define DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND ( 0x1C000024 )
#define DCERPC_NCA_S_FAULT_NO_CLIENT_STUB ( 0x1C000025 )
#define DCERPC_FAULT_ACCESS_DENIED ( 0x00000005 )
#define DCERPC_FAULT_SERVER_UNAVAILABLE ( 0x000006ba )
#define DCERPC_FAULT_NO_CALL_ACTIVE ( 0x000006bd )
#define DCERPC_FAULT_CANT_PERFORM ( 0x000006d8 )
#define DCERPC_FAULT_OUT_OF_RESOURCES ( 0x000006d9 )
#define DCERPC_FAULT_BAD_STUB_DATA ( 0x000006f7 )
#define DCERPC_FAULT_SEC_PKG_ERROR ( 0x00000721 )
#endif
;

/* bitmap dcerpc_fault_flags */
#define DCERPC_FAULT_FLAG_EXTENDED_ERROR_INFORMATION ( 0x01 )

struct dcerpc_fault {
	uint32_t alloc_hint;
	uint16_t context_id;
	uint8_t cancel_count;
	uint8_t flags;
	enum dcerpc_nca_status status;
	uint32_t reserved;/* [value(0)] */
	DATA_BLOB error_and_verifier;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

enum dcerpc_AuthType
#ifndef USE_UINT_ENUMS
 {
	DCERPC_AUTH_TYPE_NONE=(int)(0),
	DCERPC_AUTH_TYPE_KRB5_1=(int)(1),
	DCERPC_AUTH_TYPE_SPNEGO=(int)(9),
	DCERPC_AUTH_TYPE_NTLMSSP=(int)(10),
	DCERPC_AUTH_TYPE_KRB5=(int)(16),
	DCERPC_AUTH_TYPE_DPA=(int)(17),
	DCERPC_AUTH_TYPE_MSN=(int)(18),
	DCERPC_AUTH_TYPE_DIGEST=(int)(21),
	DCERPC_AUTH_TYPE_SCHANNEL=(int)(68),
	DCERPC_AUTH_TYPE_MSMQ=(int)(100),
	DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM=(int)(200)
}
#else
 { __do_not_use_enum_dcerpc_AuthType=INT_MAX}
#define DCERPC_AUTH_TYPE_NONE ( 0 )
#define DCERPC_AUTH_TYPE_KRB5_1 ( 1 )
#define DCERPC_AUTH_TYPE_SPNEGO ( 9 )
#define DCERPC_AUTH_TYPE_NTLMSSP ( 10 )
#define DCERPC_AUTH_TYPE_KRB5 ( 16 )
#define DCERPC_AUTH_TYPE_DPA ( 17 )
#define DCERPC_AUTH_TYPE_MSN ( 18 )
#define DCERPC_AUTH_TYPE_DIGEST ( 21 )
#define DCERPC_AUTH_TYPE_SCHANNEL ( 68 )
#define DCERPC_AUTH_TYPE_MSMQ ( 100 )
#define DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM ( 200 )
#endif
;

enum dcerpc_AuthLevel
#ifndef USE_UINT_ENUMS
 {
	DCERPC_AUTH_LEVEL_NONE=(int)(1),
	DCERPC_AUTH_LEVEL_CONNECT=(int)(2),
	DCERPC_AUTH_LEVEL_CALL=(int)(3),
	DCERPC_AUTH_LEVEL_PACKET=(int)(4),
	DCERPC_AUTH_LEVEL_INTEGRITY=(int)(5),
	DCERPC_AUTH_LEVEL_PRIVACY=(int)(6)
}
#else
 { __do_not_use_enum_dcerpc_AuthLevel=INT_MAX}
#define DCERPC_AUTH_LEVEL_NONE ( 1 )
#define DCERPC_AUTH_LEVEL_CONNECT ( 2 )
#define DCERPC_AUTH_LEVEL_CALL ( 3 )
#define DCERPC_AUTH_LEVEL_PACKET ( 4 )
#define DCERPC_AUTH_LEVEL_INTEGRITY ( 5 )
#define DCERPC_AUTH_LEVEL_PRIVACY ( 6 )
#endif
;

struct dcerpc_auth {
	enum dcerpc_AuthType auth_type;
	enum dcerpc_AuthLevel auth_level;
	uint8_t auth_pad_length;
	uint8_t auth_reserved;
	uint32_t auth_context_id;
	DATA_BLOB credentials;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_auth3 {
	uint32_t _pad;/* [value(0)] */
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_orphaned {
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_co_cancel {
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_cl_cancel {
	uint32_t version;
	uint32_t id;
}/* [public] */;

struct dcerpc_cancel_ack {
	uint32_t version;
	uint32_t id;
	uint32_t server_is_accepting;
}/* [public] */;

struct dcerpc_fack {
	uint32_t version;
	uint8_t _pad1;
	uint16_t window_size;
	uint32_t max_tdsu;
	uint32_t max_frag_size;
	uint16_t serial_no;
	uint16_t selack_size;
	uint32_t *selack;
}/* [public] */;

struct dcerpc_ack {
	char _empty_;
}/* [public] */;

struct dcerpc_ping {
	char _empty_;
}/* [public] */;

struct dcerpc_shutdown {
	char _empty_;
}/* [public] */;

struct dcerpc_working {
	char _empty_;
}/* [public] */;

struct RTSCookie {
	struct GUID Cookie;
}/* [public] */;

enum AddressType
#ifndef USE_UINT_ENUMS
 {
	RTS_IPV4=(int)(0),
	RTS_IPV6=(int)(1)
}
#else
 { __do_not_use_enum_AddressType=INT_MAX}
#define RTS_IPV4 ( 0 )
#define RTS_IPV6 ( 1 )
#endif
;

union ClientAddressType {
	const char * ClientAddressIPV4;/* [case(RTS_IPV4)] */
	const char * ClientAddressIPV6;/* [case(RTS_IPV6)] */
}/* [nodiscriminant] */;

struct ClientAddress {
	enum AddressType AddressType;
	union ClientAddressType ClientAddress;/* [switch_is(AddressType)] */
	uint8_t Padding[12];
}/* [public] */;

enum ForwardDestination
#ifndef USE_UINT_ENUMS
 {
	FDClient=(int)(0),
	FDInProxy=(int)(1),
	FDServer=(int)(2),
	FDOutProxy=(int)(3)
}
#else
 { __do_not_use_enum_ForwardDestination=INT_MAX}
#define FDClient ( 0 )
#define FDInProxy ( 1 )
#define FDServer ( 2 )
#define FDOutProxy ( 3 )
#endif
;

struct FlowControlAcknowledgment {
	uint32_t BytesReceived;
	uint32_t AvailableWindow;
	struct RTSCookie ChannelCookie;
}/* [public] */;

struct dcerpc_rts_cmd_ReceiveWindowSize {
	uint32_t ReceiveWindowSize;/* [range(0x2000,0x40000)] */
}/* [public] */;

struct dcerpc_rts_cmd_FlowControlAck {
	struct FlowControlAcknowledgment Ack;
}/* [public] */;

struct dcerpc_rts_cmd_ConnectionTimeout {
	uint32_t ConnectionTimeout;/* [range(0x1D4C0,0xDBBA00)] */
}/* [public] */;

struct dcerpc_rts_cmd_Cookie {
	struct RTSCookie Cookie;
}/* [public] */;

struct dcerpc_rts_cmd_ChannelLifetime {
	uint32_t ChannelLifetime;/* [range(0x20000,0x80000000)] */
}/* [public] */;

struct dcerpc_rts_cmd_ClientKeepalive {
	uint32_t ClientKeepalive;
}/* [public] */;

struct dcerpc_rts_cmd_Version {
	uint32_t Version;
}/* [public] */;

struct dcerpc_rts_cmd_Empty {
	char _empty_;
}/* [public] */;

struct dcerpc_rts_cmd_Padding {
	uint32_t ConformanceCount;/* [range(0x0,0xFFFF)] */
	uint8_t *Padding;
}/* [public] */;

struct dcerpc_rts_cmd_NegativeANCE {
	char _empty_;
}/* [public] */;

struct dcerpc_rts_cmd_ANCE {
	char _empty_;
}/* [public] */;

struct dcerpc_rts_cmd_ClientAddress {
	struct ClientAddress ClientAddress;
}/* [public] */;

struct dcerpc_rts_cmd_AssociationGroupId {
	struct RTSCookie AssociationGroupId;
}/* [public] */;

struct dcerpc_rts_cmd_Destination {
	enum ForwardDestination ForwardDestination;
}/* [public] */;

struct dcerpc_rts_cmd_PingTrafficSentNotify {
	uint32_t PingTrafficSent;
}/* [public] */;

union dcerpc_rts_cmds {
	struct dcerpc_rts_cmd_ReceiveWindowSize ReceiveWindowSize;/* [case(0x0)] */
	struct dcerpc_rts_cmd_FlowControlAck FlowControlAck;/* [case(0x1)] */
	struct dcerpc_rts_cmd_ConnectionTimeout ConnectionTimeout;/* [case(0x2)] */
	struct dcerpc_rts_cmd_Cookie Cookie;/* [case(0x3)] */
	struct dcerpc_rts_cmd_ChannelLifetime ChannelLifetime;/* [case(0x4)] */
	struct dcerpc_rts_cmd_ClientKeepalive ClientKeepalive;/* [case(0x5)] */
	struct dcerpc_rts_cmd_Version Version;/* [case(0x6)] */
	struct dcerpc_rts_cmd_Empty Empty;/* [case(0x7)] */
	struct dcerpc_rts_cmd_Padding Padding;/* [case(0x8)] */
	struct dcerpc_rts_cmd_NegativeANCE NegativeANCE;/* [case(0x9)] */
	struct dcerpc_rts_cmd_ANCE ANCE;/* [case(0xA)] */
	struct dcerpc_rts_cmd_ClientAddress ClientAddress;/* [case(0xB)] */
	struct dcerpc_rts_cmd_AssociationGroupId AssociationGroupId;/* [case(0xC)] */
	struct dcerpc_rts_cmd_Destination Destination;/* [case(0xD)] */
	struct dcerpc_rts_cmd_PingTrafficSentNotify PingTrafficSentNotify;/* [case(0xE)] */
}/* [nodiscriminant] */;

struct dcerpc_rts_cmd {
	uint32_t CommandType;
	union dcerpc_rts_cmds Command;/* [switch_is(CommandType)] */
}/* [public] */;

/* bitmap dcerpc_rts_flags */
#define RTS_FLAG_NONE ( 0x0000 )
#define RTS_FLAG_PING ( 0x0001 )
#define RTS_FLAG_OTHER_CMD ( 0x0002 )
#define RTS_FLAG_RECYCLE_CHANNEL ( 0x0004 )
#define RTS_FLAG_IN_CHANNEL ( 0x0008 )
#define RTS_FLAG_OUT_CHANNEL ( 0x0010 )
#define RTS_FLAG_EOF ( 0x0020 )
#define RTS_FLAG_ECHO ( 0x0040 )

struct dcerpc_rts {
	uint16_t Flags;
	uint16_t NumberOfCommands;
	struct dcerpc_rts_cmd *Commands;
}/* [public] */;

enum dcerpc_pkt_type
#ifndef USE_UINT_ENUMS
 {
	DCERPC_PKT_REQUEST=(int)(0),
	DCERPC_PKT_PING=(int)(1),
	DCERPC_PKT_RESPONSE=(int)(2),
	DCERPC_PKT_FAULT=(int)(3),
	DCERPC_PKT_WORKING=(int)(4),
	DCERPC_PKT_NOCALL=(int)(5),
	DCERPC_PKT_REJECT=(int)(6),
	DCERPC_PKT_ACK=(int)(7),
	DCERPC_PKT_CL_CANCEL=(int)(8),
	DCERPC_PKT_FACK=(int)(9),
	DCERPC_PKT_CANCEL_ACK=(int)(10),
	DCERPC_PKT_BIND=(int)(11),
	DCERPC_PKT_BIND_ACK=(int)(12),
	DCERPC_PKT_BIND_NAK=(int)(13),
	DCERPC_PKT_ALTER=(int)(14),
	DCERPC_PKT_ALTER_RESP=(int)(15),
	DCERPC_PKT_AUTH3=(int)(16),
	DCERPC_PKT_SHUTDOWN=(int)(17),
	DCERPC_PKT_CO_CANCEL=(int)(18),
	DCERPC_PKT_ORPHANED=(int)(19),
	DCERPC_PKT_RTS=(int)(20)
}
#else
 { __do_not_use_enum_dcerpc_pkt_type=INT_MAX}
#define DCERPC_PKT_REQUEST ( 0 )
#define DCERPC_PKT_PING ( 1 )
#define DCERPC_PKT_RESPONSE ( 2 )
#define DCERPC_PKT_FAULT ( 3 )
#define DCERPC_PKT_WORKING ( 4 )
#define DCERPC_PKT_NOCALL ( 5 )
#define DCERPC_PKT_REJECT ( 6 )
#define DCERPC_PKT_ACK ( 7 )
#define DCERPC_PKT_CL_CANCEL ( 8 )
#define DCERPC_PKT_FACK ( 9 )
#define DCERPC_PKT_CANCEL_ACK ( 10 )
#define DCERPC_PKT_BIND ( 11 )
#define DCERPC_PKT_BIND_ACK ( 12 )
#define DCERPC_PKT_BIND_NAK ( 13 )
#define DCERPC_PKT_ALTER ( 14 )
#define DCERPC_PKT_ALTER_RESP ( 15 )
#define DCERPC_PKT_AUTH3 ( 16 )
#define DCERPC_PKT_SHUTDOWN ( 17 )
#define DCERPC_PKT_CO_CANCEL ( 18 )
#define DCERPC_PKT_ORPHANED ( 19 )
#define DCERPC_PKT_RTS ( 20 )
#endif
;

union dcerpc_payload {
	struct dcerpc_request request;/* [case(DCERPC_PKT_REQUEST)] */
	struct dcerpc_ping ping;/* [case(DCERPC_PKT_PING)] */
	struct dcerpc_response response;/* [case(DCERPC_PKT_RESPONSE)] */
	struct dcerpc_fault fault;/* [case(DCERPC_PKT_FAULT)] */
	struct dcerpc_working working;/* [case(DCERPC_PKT_WORKING)] */
	struct dcerpc_fack nocall;/* [case(DCERPC_PKT_NOCALL)] */
	struct dcerpc_fault reject;/* [case(DCERPC_PKT_REJECT)] */
	struct dcerpc_ack ack;/* [case(DCERPC_PKT_ACK)] */
	struct dcerpc_cl_cancel cl_cancel;/* [case(DCERPC_PKT_CL_CANCEL)] */
	struct dcerpc_fack fack;/* [case(DCERPC_PKT_FACK)] */
	struct dcerpc_cancel_ack cancel_ack;/* [case(DCERPC_PKT_CANCEL_ACK)] */
	struct dcerpc_bind bind;/* [case(DCERPC_PKT_BIND)] */
	struct dcerpc_bind_ack bind_ack;/* [case(DCERPC_PKT_BIND_ACK)] */
	struct dcerpc_bind_nak bind_nak;/* [case(DCERPC_PKT_BIND_NAK)] */
	struct dcerpc_bind alter;/* [case(DCERPC_PKT_ALTER)] */
	struct dcerpc_bind_ack alter_resp;/* [case(DCERPC_PKT_ALTER_RESP)] */
	struct dcerpc_shutdown shutdown;/* [case(DCERPC_PKT_SHUTDOWN)] */
	struct dcerpc_co_cancel co_cancel;/* [case(DCERPC_PKT_CO_CANCEL)] */
	struct dcerpc_orphaned orphaned;/* [case(DCERPC_PKT_ORPHANED)] */
	struct dcerpc_auth3 auth3;/* [case(DCERPC_PKT_AUTH3)] */
	struct dcerpc_rts rts;/* [case(DCERPC_PKT_RTS)] */
}/* [nodiscriminant,public] */;

/* bitmap dcerpc_pfc_flags */
#define DCERPC_PFC_FLAG_FIRST ( 0x01 )
#define DCERPC_PFC_FLAG_LAST ( 0x02 )
#define DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING ( 0x04 )
#define DCERPC_PFC_FLAG_CONC_MPX ( 0x10 )
#define DCERPC_PFC_FLAG_DID_NOT_EXECUTE ( 0x20 )
#define DCERPC_PFC_FLAG_MAYBE ( 0x40 )
#define DCERPC_PFC_FLAG_OBJECT_UUID ( 0x80 )

struct ncacn_packet {
	uint8_t rpc_vers;
	uint8_t rpc_vers_minor;
	enum dcerpc_pkt_type ptype;
	uint8_t pfc_flags;
	uint8_t drep[4];
	uint16_t frag_length;
	uint16_t auth_length;
	uint32_t call_id;
	union dcerpc_payload u;/* [switch_is(ptype)] */
}/* [noprint,nopull,nopush,public] */;

struct ncadg_packet {
	uint8_t rpc_vers;
	uint8_t ptype;
	uint8_t pfc_flags;
	uint8_t ncadg_flags;
	uint8_t drep[3];
	uint8_t serial_high;
	struct GUID object;
	struct GUID iface;
	struct GUID activity;
	uint32_t server_boot;
	uint32_t iface_version;
	uint32_t seq_num;
	uint16_t opnum;
	uint16_t ihint;
	uint16_t ahint;
	uint16_t len;
	uint16_t fragnum;
	uint8_t auth_proto;
	uint8_t serial_low;
	union dcerpc_payload u;/* [switch_is(ptype)] */
}/* [public] */;

/* bitmap dcerpc_sec_vt_command */
#define DCERPC_SEC_VT_COMMAND_ENUM ( 0x3FFF )
#define DCERPC_SEC_VT_COMMAND_END ( 0x4000 )
#define DCERPC_SEC_VT_MUST_PROCESS ( 0x8000 )

enum dcerpc_sec_vt_command_enum
#ifndef USE_UINT_ENUMS
 {
	DCERPC_SEC_VT_COMMAND_BITMASK1=(int)(0x0001),
	DCERPC_SEC_VT_COMMAND_PCONTEXT=(int)(0x0002),
	DCERPC_SEC_VT_COMMAND_HEADER2=(int)(0x0003)
}
#else
 { __do_not_use_enum_dcerpc_sec_vt_command_enum=INT_MAX}
#define DCERPC_SEC_VT_COMMAND_BITMASK1 ( 0x0001 )
#define DCERPC_SEC_VT_COMMAND_PCONTEXT ( 0x0002 )
#define DCERPC_SEC_VT_COMMAND_HEADER2 ( 0x0003 )
#endif
;

/* bitmap dcerpc_sec_vt_bitmask1 */
#define DCERPC_SEC_VT_CLIENT_SUPPORTS_HEADER_SIGNING ( 0x00000001 )

struct dcerpc_sec_vt_pcontext {
	struct ndr_syntax_id abstract_syntax;
	struct ndr_syntax_id transfer_syntax;
};

struct dcerpc_sec_vt_header2 {
	enum dcerpc_pkt_type ptype;
	uint8_t reserved1;/* [value(0)] */
	uint16_t reserved2;/* [value(0)] */
	uint8_t drep[4];
	uint32_t call_id;
	uint16_t context_id;
	uint16_t opnum;
};

union dcerpc_sec_vt_union {
	uint32_t bitmask1;/* [case(DCERPC_SEC_VT_COMMAND_BITMASK1)] */
	struct dcerpc_sec_vt_pcontext pcontext;/* [case(DCERPC_SEC_VT_COMMAND_PCONTEXT)] */
	struct dcerpc_sec_vt_header2 header2;/* [case(DCERPC_SEC_VT_COMMAND_HEADER2)] */
	DATA_BLOB _unknown;/* [default,flag(LIBNDR_FLAG_REMAINING)] */
}/* [nodiscriminant,switch_type(dcerpc_sec_vt_command_enum)] */;

struct dcerpc_sec_vt {
	uint16_t command;
	union dcerpc_sec_vt_union u;/* [flag(LIBNDR_FLAG_SUBCONTEXT_NO_UNREAD_BYTES),subcontext(2),switch_is(command&DCERPC_SEC_VT_COMMAND_ENUM)] */
};

struct dcerpc_sec_vt_count {
	uint16_t count;
}/* [nopull,nopush,public] */;

struct dcerpc_sec_verification_trailer {
	DATA_BLOB _pad;/* [flag(LIBNDR_FLAG_ALIGN4)] */
	uint8_t magic[8];/* [value(DCERPC_SEC_VT_MAGIC)] */
	struct dcerpc_sec_vt_count count;
	struct dcerpc_sec_vt *commands;
}/* [flag(LIBNDR_PRINT_ARRAY_HEX),public] */;

#endif /* _HEADER_dcerpc */
#endif /* _PIDL_HEADER_dcerpc */
