/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KerberosTime {
    private final long kerberosTime;
    private final int microSeconds;
    private static long initMilli = System.currentTimeMillis();
    private static long initMicro = System.nanoTime() / 1000L;
    private static boolean DEBUG = Krb5.DEBUG;

    private KerberosTime(long l, int n) {
        this.kerberosTime = l;
        this.microSeconds = n;
    }

    public KerberosTime(long l) {
        this(l, 0);
    }

    public KerberosTime(String string) throws Asn1Exception {
        this(KerberosTime.toKerberosTime(string), 0);
    }

    private static long toKerberosTime(String string) throws Asn1Exception {
        if (string.length() != 15) {
            throw new Asn1Exception(900);
        }
        if (string.charAt(14) != 'Z') {
            throw new Asn1Exception(900);
        }
        int n = Integer.parseInt(string.substring(0, 4));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(n, Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)), Integer.parseInt(string.substring(12, 14)));
        return calendar.getTimeInMillis();
    }

    public KerberosTime(Date date) {
        this(date.getTime(), 0);
    }

    public KerberosTime(Instant instant) {
        this(instant.getEpochSecond() * 1000L + (long)instant.getNano() / 1000000L, instant.getNano() / 1000 % 1000);
    }

    public static KerberosTime now() {
        long l = System.currentTimeMillis();
        long l2 = System.nanoTime() / 1000L;
        long l3 = l2 - initMicro;
        long l4 = initMilli + l3 / 1000L;
        if (l4 - l > 100L || l - l4 > 100L) {
            if (DEBUG) {
                System.out.println("System time adjusted");
            }
            initMilli = l;
            initMicro = l2;
            return new KerberosTime(l, 0);
        }
        return new KerberosTime(l4, (int)(l3 % 1000L));
    }

    public String toGeneralizedTimeString() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.setTimeInMillis(this.kerberosTime);
        return String.format("%04d%02d%02d%02d%02d%02dZ", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putGeneralizedTime(this.toDate());
        return derOutputStream.toByteArray();
    }

    public long getTime() {
        return this.kerberosTime;
    }

    public Date toDate() {
        return new Date(this.kerberosTime);
    }

    public int getMicroSeconds() {
        Long l = new Long(this.kerberosTime % 1000L * 1000L);
        return l.intValue() + this.microSeconds;
    }

    public KerberosTime withMicroSeconds(int n) {
        return new KerberosTime(this.kerberosTime - this.kerberosTime % 1000L + (long)n / 1000L, n % 1000);
    }

    private boolean inClockSkew(int n) {
        return Math.abs(this.kerberosTime - System.currentTimeMillis()) <= (long)n * 1000L;
    }

    public boolean inClockSkew() {
        return this.inClockSkew(KerberosTime.getDefaultSkew());
    }

    public boolean greaterThanWRTClockSkew(KerberosTime kerberosTime, int n) {
        return this.kerberosTime - kerberosTime.kerberosTime > (long)n * 1000L;
    }

    public boolean greaterThanWRTClockSkew(KerberosTime kerberosTime) {
        return this.greaterThanWRTClockSkew(kerberosTime, KerberosTime.getDefaultSkew());
    }

    public boolean greaterThan(KerberosTime kerberosTime) {
        return this.kerberosTime > kerberosTime.kerberosTime || this.kerberosTime == kerberosTime.kerberosTime && this.microSeconds > kerberosTime.microSeconds;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KerberosTime)) {
            return false;
        }
        return this.kerberosTime == ((KerberosTime)object).kerberosTime && this.microSeconds == ((KerberosTime)object).microSeconds;
    }

    public int hashCode() {
        int n = 629 + (int)(this.kerberosTime ^ this.kerberosTime >>> 32);
        return n * 17 + this.microSeconds;
    }

    public boolean isZero() {
        return this.kerberosTime == 0L && this.microSeconds == 0;
    }

    public int getSeconds() {
        Long l = new Long(this.kerberosTime / 1000L);
        return l.intValue();
    }

    public static KerberosTime parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        Date date = derValue2.getGeneralizedTime();
        return new KerberosTime(date.getTime(), 0);
    }

    public static int getDefaultSkew() {
        int n;
        block3: {
            n = 300;
            try {
                n = Config.getInstance().getIntValue("libdefaults", "clockskew");
                if (n == Integer.MIN_VALUE) {
                    n = 300;
                }
            }
            catch (KrbException krbException) {
                if (!DEBUG) break block3;
                System.out.println("Exception in getting clockskew from Configuration using default value " + krbException.getMessage());
            }
        }
        return n;
    }

    public String toString() {
        return this.toGeneralizedTimeString();
    }
}

