/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ThreadLocalAllocBuffer
extends VMObject {
    private static AddressField startField;
    private static AddressField topField;
    private static AddressField endField;
    private static CIntegerField desired_sizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ThreadLocalAllocBuffer");
        startField = type.getAddressField("_start");
        topField = type.getAddressField("_top");
        endField = type.getAddressField("_end");
        desired_sizeField = type.getCIntegerField("_desired_size");
    }

    public ThreadLocalAllocBuffer(Address addr) {
        super(addr);
    }

    public Address start() {
        return startField.getValue(this.addr);
    }

    public Address end() {
        return endField.getValue(this.addr);
    }

    public Address top() {
        return topField.getValue(this.addr);
    }

    public Address hardEnd() {
        return this.end().addOffsetTo(this.alignmentReserve());
    }

    private long alignmentReserve() {
        return Oop.alignObjectSize(this.endReserve());
    }

    private long endReserve() {
        long minFillerArraySize = Array.baseOffsetInBytes(BasicType.T_INT);
        long reserveForAllocationPrefetch = VM.getVM().getReserveForAllocationPrefetch();
        long heapWordSize = VM.getVM().getHeapWordSize();
        return Math.max(minFillerArraySize, reserveForAllocationPrefetch * heapWordSize);
    }

    public OopHandle startAsOopHandle() {
        return startField.getOopHandle(this.addr);
    }

    public OopHandle nextOopHandle(OopHandle handle, long size) {
        return handle.addOffsetToAsOopHandle(size);
    }

    public void print() {
        this.printOn(System.out);
    }

    public boolean contains(Address p) {
        if (this.top() == null) {
            return false;
        }
        return this.start().lessThanOrEqual(p) && this.top().greaterThan(p);
    }

    public void printOn(PrintStream tty) {
        tty.println(" [" + this.start() + "," + this.top() + "," + this.end() + ",{" + this.hardEnd() + "})");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ThreadLocalAllocBuffer.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

