/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.PrintStream;
import java.util.Stack;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.utilities.LivenessPathElement;

public class LivenessPath {
    private Stack stack = new Stack();

    LivenessPath() {
    }

    public int size() {
        return this.stack.size();
    }

    public LivenessPathElement get(int index) throws ArrayIndexOutOfBoundsException {
        return (LivenessPathElement)this.stack.get(index);
    }

    public void printOn(PrintStream tty) {
        for (int j = 0; j < this.size(); ++j) {
            LivenessPathElement el = this.get(j);
            tty.print("  - ");
            if (el.getObj() != null) {
                Oop.printOopValueOn(el.getObj(), tty);
            }
            if (el.getField() != null) {
                if (el.getObj() != null) {
                    tty.print(", field ");
                }
                tty.print(el.getField().getName());
            }
            tty.println();
        }
    }

    boolean isComplete() {
        if (this.size() == 0) {
            return false;
        }
        return this.peek().isRoot();
    }

    LivenessPathElement peek() {
        return (LivenessPathElement)this.stack.peek();
    }

    void push(LivenessPathElement el) {
        this.stack.push(el);
    }

    void pop() {
        this.stack.pop();
    }

    LivenessPath copy() {
        LivenessPath dup = new LivenessPath();
        for (int i = 0; i < this.stack.size(); ++i) {
            dup.stack.push(this.stack.get(i));
        }
        return dup;
    }
}

