/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_te extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u0c1c\u0c28\u0c35\u0c30\u0c3f",
               "\u0c2b\u0c3f\u0c2c\u0c4d\u0c30\u0c35\u0c30\u0c3f",
               "\u0c2e\u0c3e\u0c30\u0c4d\u0c1a\u0c3f",
               "\u0c0f\u0c2a\u0c4d\u0c30\u0c3f\u0c32\u0c4d",
               "\u0c2e\u0c47",
               "\u0c1c\u0c42\u0c28\u0c4d",
               "\u0c1c\u0c41\u0c32\u0c48",
               "\u0c06\u0c17\u0c38\u0c4d\u0c1f\u0c41",
               "\u0c38\u0c46\u0c2a\u0c4d\u0c1f\u0c46\u0c02\u0c2c\u0c30\u0c4d",
               "\u0c05\u0c15\u0c4d\u0c1f\u0c4b\u0c2c\u0c30\u0c4d",
               "\u0c28\u0c35\u0c02\u0c2c\u0c30\u0c4d",
               "\u0c21\u0c3f\u0c38\u0c46\u0c02\u0c2c\u0c30\u0c4d",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u0c1c\u0c28",
               "\u0c2b\u0c3f\u0c2c\u0c4d\u0c30",
               "\u0c2e\u0c3e\u0c30\u0c4d\u0c1a\u0c3f",
               "\u0c0f\u0c2a\u0c4d\u0c30\u0c3f",
               "\u0c2e\u0c47",
               "\u0c1c\u0c42\u0c28\u0c4d",
               "\u0c1c\u0c41\u0c32\u0c48",
               "\u0c06\u0c17",
               "\u0c38\u0c46\u0c2a\u0c4d\u0c1f\u0c46\u0c02",
               "\u0c05\u0c15\u0c4d\u0c1f\u0c4b",
               "\u0c28\u0c35\u0c02",
               "\u0c21\u0c3f\u0c38\u0c46\u0c02",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u0c1c",
               "\u0c2b\u0c3f",
               "\u0c2e\u0c3e",
               "\u0c0f",
               "\u0c2e\u0c47",
               "\u0c1c\u0c42",
               "\u0c1c\u0c41",
               "\u0c06",
               "\u0c38\u0c46",
               "\u0c05",
               "\u0c28",
               "\u0c21\u0c3f",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u0c06\u0c26\u0c3f\u0c35\u0c3e\u0c30\u0c02",
               "\u0c38\u0c4b\u0c2e\u0c35\u0c3e\u0c30\u0c02",
               "\u0c2e\u0c02\u0c17\u0c33\u0c35\u0c3e\u0c30\u0c02",
               "\u0c2c\u0c41\u0c27\u0c35\u0c3e\u0c30\u0c02",
               "\u0c17\u0c41\u0c30\u0c41\u0c35\u0c3e\u0c30\u0c02",
               "\u0c36\u0c41\u0c15\u0c4d\u0c30\u0c35\u0c3e\u0c30\u0c02",
               "\u0c36\u0c28\u0c3f\u0c35\u0c3e\u0c30\u0c02",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u0c06\u0c26\u0c3f",
               "\u0c38\u0c4b\u0c2e",
               "\u0c2e\u0c02\u0c17\u0c33",
               "\u0c2c\u0c41\u0c27",
               "\u0c17\u0c41\u0c30\u0c41",
               "\u0c36\u0c41\u0c15\u0c4d\u0c30",
               "\u0c36\u0c28\u0c3f",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u0c06",
               "\u0c38\u0c4b",
               "\u0c2e",
               "\u0c2c\u0c41",
               "\u0c17\u0c41",
               "\u0c36\u0c41",
               "\u0c36",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "1\u0c35 \u0c24\u0c4d\u0c30\u0c48\u0c2e\u0c3e\u0c38\u0c3f\u0c15\u0c02",
               "2\u0c35 \u0c24\u0c4d\u0c30\u0c48\u0c2e\u0c3e\u0c38\u0c3f\u0c15\u0c02",
               "3\u0c35 \u0c24\u0c4d\u0c30\u0c48\u0c2e\u0c3e\u0c38\u0c3f\u0c15\u0c02",
               "4\u0c35 \u0c24\u0c4d\u0c30\u0c48\u0c2e\u0c3e\u0c38\u0c3f\u0c15\u0c02",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "\u0c24\u0c4d\u0c30\u0c481",
               "\u0c24\u0c4d\u0c30\u0c482",
               "\u0c24\u0c4d\u0c30\u0c483",
               "\u0c24\u0c4d\u0c30\u0c484",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "\u0c09",
               "\u0c38\u0c3e",
            };
        final String[] metaValue_Eras = new String[] {
               "\u0c15\u0c4d\u0c30\u0c40\u0c2a\u0c42",
               "\u0c15\u0c4d\u0c30\u0c40\u0c36",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "h:mm:ss a zzzz",
               "h:mm:ss a z",
               "h:mm:ss a",
               "h:mm a",
            };
        final String[] metaValue_buddhist_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "4",
            };
        final String[] metaValue_buddhist_long_Eras = new String[] {
               "BC",
               "BE",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE d MMMM y G",
               "d MMMM y G",
               "d MMM y G",
               "dd-MM-y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE d MMMM y GGGG",
               "d MMMM y GGGG",
               "d MMM y GGGG",
               "dd-MM-y G",
            };
        final String[] metaValue_roc_AmPmMarkers = new String[] {
               "AM",
               "PM",
            };
        final String[] metaValue_roc_long_Eras = new String[] {
               "R.O.C. \u0c2a\u0c42\u0c30\u0c4d\u0c35\u0c02",
               "R.O.C.",
            };
        final String[] metaValue_islamic_long_Eras = new String[] {
               "",
               "AH",
            };
        final String metaValue_calendarname_gregorian = "\u0c17\u0c4d\u0c30\u0c47\u0c17\u0c4b\u0c30\u0c3f\u0c2f\u0c28\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0c38\u0c02\u0c35\u0c24\u0c4d\u0c38\u0c30\u0c02" },
            { "calendarname.islamic-umalqura", "\u0c07\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3f\u0c15\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d (\u0c09\u0c2e\u0c4d \u0c05\u0c32\u0c4d-\u0c16\u0c41\u0c30\u0c3e)" },
            { "buddhist.narrow.Eras", metaValue_buddhist_long_Eras },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\u0c07\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3f\u0c15\u0c4d-\u0c38\u0c3f\u0c35\u0c3f\u0c32\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "roc.long.Eras", metaValue_roc_long_Eras },
            { "timezone.regionFormat.standard", "{0} \u0c2a\u0c4d\u0c30\u0c3e\u0c2e\u0c3e\u0c23\u0c3f\u0c15 \u0c38\u0c2e\u0c2f\u0c02" },
            { "calendarname.japanese", "\u0c1c\u0c2a\u0c3e\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "long.Eras",
                new String[] {
                    "\u0c15\u0c4d\u0c30\u0c40\u0c38\u0c4d\u0c24\u0c41 \u0c2a\u0c42\u0c30\u0c4d\u0c35\u0c02",
                    "\u0c15\u0c4d\u0c30\u0c40\u0c38\u0c4d\u0c24\u0c41 \u0c36\u0c15\u0c02",
                }
            },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}\u0c15\u0c3f",
                    "{1} {0}\u0c15\u0c3f",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u0c28\u0c3f\u0c2e\u0c3f\u0c37\u0c2e\u0c41" },
            { "field.era", "\u0c2f\u0c41\u0c17\u0c02" },
            { "field.dayperiod", "AM/PM" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.roc", "\u0c2e\u0c3f\u0c02\u0c17\u0c4d\u0c2f\u0c42 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.Eras", metaValue_islamic_long_Eras },
            { "field.month", "\u0c28\u0c46\u0c32" },
            { "roc.Eras", metaValue_roc_long_Eras },
            { "field.second", "\u0c38\u0c46\u0c15\u0c28\u0c41" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4#,##,##0.00",
                    "#,##0%",
                }
            },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0c07\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3f\u0c15\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "timezone.regionFormat", "{0} \u0c38\u0c2e\u0c2f\u0c02" },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "buddhist.long.Eras", metaValue_buddhist_long_Eras },
            { "islamic.AmPmMarkers", metaValue_roc_AmPmMarkers },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "field.zone", "\u0c38\u0c2e\u0c2f \u0c2e\u0c02\u0c21\u0c32\u0c3f" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.narrow.Eras", metaValue_roc_long_Eras },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u0c35\u0c3e\u0c30\u0c02\u0c32\u0c4b \u0c30\u0c4b\u0c1c\u0c41" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "telu.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0c66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_buddhist_long_Eras },
            { "field.week", "\u0c35\u0c3e\u0c30\u0c2e\u0c41" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_roc_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "timezone.regionFormat.daylight", "{0} \u0c2a\u0c17\u0c1f\u0c3f \u0c35\u0c46\u0c32\u0c41\u0c24\u0c41\u0c30\u0c41 \u0c38\u0c2e\u0c2f\u0c02" },
            { "DatePatterns",
                new String[] {
                    "d, MMMM y, EEEE",
                    "d MMMM, y",
                    "d MMM, y",
                    "dd-MM-yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "field.hour", "\u0c17\u0c02\u0c1f" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\u0c2e\u0c41\u0c39.",
                    "\u0c38\u0c2b.",
                    "\u0c30. I",
                    "\u0c30. II",
                    "\u0c1c\u0c41\u0c2e. I",
                    "\u0c1c\u0c41\u0c2e. II",
                    "\u0c30\u0c1c.",
                    "\u0c37\u0c2c\u0c3e.",
                    "\u0c30\u0c02\u0c1c\u0c3e.",
                    "\u0c37\u0c35\u0c4d\u0c35\u0c3e.",
                    "\u0c27\u0c41\u0c32\u0c4d-\u0c15\u0c3f.",
                    "\u0c27\u0c41\u0c32\u0c4d-\u0c39\u0c3f.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_islamic_long_Eras },
            { "calendarname.buddhist", "\u0c2c\u0c41\u0c26\u0c4d\u0c27\u0c41\u0c32 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d\u200c" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
