/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_az extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestan";
        final String metaValue_ar = "\u0259r\u0259b";
        final String metaValue_bn = "benqal";
        final String metaValue_bo = "tibet";
        final String metaValue_el = "yunan";
        final String metaValue_gu = "qucarat";
        final String metaValue_hy = "erm\u0259ni";
        final String metaValue_ja = "yapon";
        final String metaValue_ka = "g\u00fcrc\u00fc";
        final String metaValue_km = "kxmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreya";
        final String metaValue_la = "lat\u0131n";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "monqol";
        final String metaValue_su = "sundan";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "teluqu";
        final String metaValue_th = "tay";
        final String metaValue_tl = "taqaloq";
        final String metaValue_ban = "bali";
        final String metaValue_sam = "samaritan";
        final String metaValue_uga = "uqarit";
        final String metaValue_type_hc_h23 = "24 Saatl\u0131q Sistem (0\u201323)";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6ln" },
            { "Ogam", "o\u011fam" },
            { "mwl", "mirand" },
            { "Zsym", "simvollar" },
            { "cch", "atsam" },
            { "mwr", "maruari" },
            { "Tagb", "taqbanva" },
            { "Zsye", "emoji" },
            { "ccp", "\u00c7akma" },
            { "egy", "q\u0259dim misir" },
            { "raj", "racastani" },
            { "Phag", "faqs-pa" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Askenson adas\u0131" },
            { "rar", "rarotonqan" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Birl\u0259\u015fmi\u015f \u018fr\u0259b \u018fmirlikl\u0259ri" },
            { "nl_BE", "flamand" },
            { "AF", "\u018ffqan\u0131stan" },
            { "AG", "Antiqua v\u0259 Barbuda" },
            { "type.ca.ethiopic", "Efiop T\u0259qvimi" },
            { "AI", "Angilya" },
            { "AL", "Albaniya" },
            { "AM", "Erm\u0259nistan" },
            { "Teng", "tengvar" },
            { "AO", "Anqola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "Prti", "prti" },
            { "AS", "Amerika Samoas\u0131" },
            { "AT", "Avstriya" },
            { "AU", "Avstraliya" },
            { "AW", "Aruba" },
            { "en_US", "Amerika ingilisc\u0259si" },
            { "AX", "Aland adalar\u0131" },
            { "AZ", "Az\u0259rbaycan" },
            { "BA", "Bosniya v\u0259 Herseqovina" },
            { "BB", "Barbados" },
            { "ceb", "sebuan" },
            { "BD", "Banqlade\u015f" },
            { "kum", "kum\u0131k" },
            { "BE", "Bel\u00e7ika" },
            { "gmh", "orta y\u00fcks\u0259k alman" },
            { "BF", "Burkina Faso" },
            { "BG", "Bolqar\u0131stan" },
            { "BH", "B\u0259hreyn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sent-Bartelemi" },
            { "BM", "Bermud adalar\u0131" },
            { "kut", "kutenay" },
            { "myv", "erzya" },
            { "BN", "Bruney" },
            { "BO", "Boliviya" },
            { "BQ", "Karib Niderland\u0131" },
            { "BR", "Braziliya" },
            { "BS", "Baham adalar\u0131" },
            { "xog", "soqa" },
            { "BT", "Butan" },
            { "BV", "Buve adas\u0131" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "Visp", "dan\u0131\u015fma s\u0259sl\u0259ri" },
            { "type.ca.persian", "\u0130ran T\u0259qvimi" },
            { "type.nu.hebr", "\u0130vrit R\u0259q\u0259ml\u0259ri" },
            { "CA", "Kanada" },
            { "CC", "Kokos (Kilinq) adalar\u0131" },
            { "mzn", "mazandaran" },
            { "CD", "Konqo - Kin\u015fasa" },
            { "CF", "M\u0259rk\u0259zi Afrika Respublikas\u0131" },
            { "CG", "Konqo - Brazzavil" },
            { "CH", "\u0130sve\u00e7r\u0259" },
            { "CI", "Kotd\u2019ivuar" },
            { "CK", "Kuk adalar\u0131" },
            { "CL", "\u00c7ili" },
            { "Kthi", "kti" },
            { "CM", "Kamerun" },
            { "CN", "\u00c7in" },
            { "CO", "Kolumbiya" },
            { "CP", "Klipperton adas\u0131" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo-Verde" },
            { "CW", "Kurasao" },
            { "CX", "Milad adas\u0131" },
            { "CY", "Kipr" },
            { "CZ", "\u00c7exiya" },
            { "eka", "ekacuk" },
            { "DE", "Almaniya" },
            { "goh", "q\u0259dim alman" },
            { "ace", "akin" },
            { "cgg", "\u00e7iqa" },
            { "DG", "Dieqo Qarsiya" },
            { "type.nu.deva", "Devanaqari R\u0259q\u0259ml\u0259ri" },
            { "DJ", "Cibuti" },
            { "DK", "Danimarka" },
            { "ach", "akoli" },
            { "gon", "qondi" },
            { "Brai", "brayl" },
            { "Brah", "brahmi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Ki\u00e7ik Erm\u0259ni R\u0259q\u0259ml\u0259ri" },
            { "DO", "Dominikan Respublikas\u0131" },
            { "gor", "qorontalo" },
            { "got", "qotika" },
            { "Mtei", "meytey mayek" },
            { "zun", "zuni" },
            { "tig", "tiqre" },
            { "DZ", "\u018flc\u0259zair" },
            { "pag", "panqasinan" },
            { "pal", "p\u0259hl\u0259vi" },
            { "EA", "Seuta v\u0259 Melilya" },
            { "chb", "\u00e7ib\u00e7a" },
            { "pam", "pampanqa" },
            { "EC", "Ekvador" },
            { "pap", "papyamento" },
            { "ada", "adanqme" },
            { "EE", "Estoniya" },
            { "tiv", "tiv" },
            { "EG", "Misir" },
            { "EH", "Q\u0259rbi Saxara" },
            { "chg", "\u00e7a\u011fatay" },
            { "pau", "palayan" },
            { "chk", "\u00e7ukiz" },
            { "chn", "\u00e7inuk l\u0259h\u00e7\u0259si" },
            { "chm", "mari" },
            { "chp", "\u00e7ipevyan" },
            { "cho", "\u00e7oktau" },
            { "chr", "\u00e7eroki" },
            { "ER", "Eritreya" },
            { "ES", "\u0130spaniya" },
            { "ET", "Efiopiya" },
            { "EU", "Avropa Birliyi" },
            { "elx", "elamit" },
            { "type.ca.gregorian", "Qreqorian T\u0259qvimi" },
            { "EZ", "Avrozona" },
            { "chy", "\u00e7eyen" },
            { "type.nu.gujr", "Qucarat R\u0259q\u0259ml\u0259ri" },
            { "Inds", "hindistan" },
            { "ady", "ad\u0131gey" },
            { "FI", "Finlandiya" },
            { "FJ", "Fici" },
            { "FK", "Folklend adalar\u0131" },
            { "FM", "Mikroneziya" },
            { "FO", "Farer adalar\u0131" },
            { "Taml", metaValue_ta },
            { "FR", "Fransa" },
            { "tkl", "tokelay" },
            { "grb", "qrebo" },
            { "type.ca.indian", "Hindi t\u0259qvimi" },
            { "grc", "q\u0259dim yunan" },
            { "GA", "Qabon" },
            { "vot", "votik" },
            { "GB", "Birl\u0259\u015fmi\u015f Krall\u0131q" },
            { "pcm", "niger kreol" },
            { "GD", "Qrenada" },
            { "GE", "G\u00fcrc\u00fcstan" },
            { "GF", "Fransa Qvianas\u0131" },
            { "GG", "Gernsi" },
            { "GH", "Qana" },
            { "Tale", "tay le" },
            { "GI", "C\u0259b\u0259ll\u00fctariq" },
            { "afh", "afrihili" },
            { "GL", "Qrenlandiya" },
            { "enm", "orta ingilis" },
            { "GM", "Qambiya" },
            { "GN", "Qvineya" },
            { "GP", "Qvadelupa" },
            { "GQ", "Ekvatorial Qvineya" },
            { "GR", "Yunan\u0131stan" },
            { "GS", "C\u0259nubi Corciya v\u0259 C\u0259nubi Sendvi\u00e7 adalar\u0131" },
            { "GT", "Qvatemala" },
            { "GU", "Quam" },
            { "GW", "Qvineya-Bisau" },
            { "tli", "tlinqit" },
            { "tlh", "klinqon" },
            { "Talu", "t\u0259z\u0259 tay lu" },
            { "GY", "Qayana" },
            { "ckb", "M\u0259rk\u0259zi k\u00fcrdc\u0259" },
            { "zxx", "dil m\u0259zmunu yoxdur" },
            { "de_AT", "Avstriya almancas\u0131" },
            { "HK", "Honq Konq X\u00fcsusi \u0130nzibati Rayonu \u00c7in" },
            { "Vaii", "vay" },
            { "HM", "Herd v\u0259 Makdonald adalar\u0131" },
            { "HN", "Honduras" },
            { "HR", "Xorvatiya" },
            { "agq", "aqhem" },
            { "gsw", "\u0130sve\u00e7r\u0259 almancas\u0131" },
            { "HT", "Haiti" },
            { "HU", "Macar\u0131stan" },
            { "tmh", "tama\u015fek" },
            { "IC", "Kanar adalar\u0131" },
            { "nan", "Min Nan" },
            { "ID", "\u0130ndoneziya" },
            { "peo", "q\u0259dim fars" },
            { "IE", "\u0130rlandiya" },
            { "nap", "neapolitan" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "\u0130srail" },
            { "IM", "Men adas\u0131" },
            { "IN", "Hindistan" },
            { "IO", "Britaniyan\u0131n Hind Okean\u0131 \u018frazisi" },
            { "IQ", "\u0130raq" },
            { "IR", "\u0130ran" },
            { "IS", "\u0130slandiya" },
            { "IT", "\u0130taliya" },
            { "Zmth", "riyazi notasiya" },
            { "type.nu.thai", "Tay R\u0259q\u0259ml\u0259ri" },
            { "type.nu.beng", "Benqal R\u0259q\u0259ml\u0259ri" },
            { "JE", "Cersi" },
            { "type.ca.islamic", "\u0130slam T\u0259qvimi" },
            { "Beng", metaValue_bn },
            { "JM", "Yamayka" },
            { "JO", "\u0130ordaniya" },
            { "JP", "Yaponiya" },
            { "ain", "aynu" },
            { "guz", "qusi" },
            { "tog", "nyasa tonqa" },
            { "type.nu.knda", "Kannada R\u0259q\u0259ml\u0259ri" },
            { "Kali", "kayax li" },
            { "de_CH", "\u0130sve\u00e7r\u0259 y\u00fcks\u0259k almancas\u0131" },
            { "type.ca.buddhist", "Buddist T\u0259qvimi" },
            { "KE", "Keniya" },
            { "419", "Lat\u0131n Amerikas\u0131" },
            { "KG", "Q\u0131r\u011f\u0131z\u0131stan" },
            { "KH", "Kamboca" },
            { "KI", "Kiribati" },
            { "KM", "Komor adalar\u0131" },
            { "Knda", metaValue_kn },
            { "KN", "Sent-Kits v\u0259 Nevis" },
            { "fr_CA", "Kanada frans\u0131zcas\u0131" },
            { "KP", "\u015eimali Koreya" },
            { "KR", "C\u0259nubi Koreya" },
            { "Plrd", "polard fonetik" },
            { "fr_CH", "\u0130sve\u00e7r\u0259 frans\u0131zcas\u0131" },
            { "KW", "K\u00fcveyt" },
            { "tpi", "tok pisin" },
            { "KY", "Kayman adalar\u0131" },
            { "KZ", "Qazax\u0131stan" },
            { "Cyrl", "kiril" },
            { "LA", "Laos" },
            { "LB", "Livan" },
            { "LC", "Sent-Lusiya" },
            { "phn", "foyenik" },
            { "Cyrs", "q\u0259dimi kilsa kirili" },
            { "gwi", "qvi\u00e7in" },
            { "nds", "a\u015fa\u011f\u0131 alman" },
            { "LI", "Lixten\u015fteyn" },
            { "LK", "\u015eri-Lanka" },
            { "akk", "akkad" },
            { "cop", "kopt" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "Phlv", "kitab paxlavi" },
            { "LT", "Litva" },
            { "LU", "L\u00fcksemburq" },
            { "LV", "Latviya" },
            { "Kana", "katakana" },
            { "LY", "Liviya" },
            { "lad", "sefard" },
            { "vun", "vunyo" },
            { "lah", "q\u0259rbi p\u0259ncab" },
            { "lag", "langi" },
            { "Thaa", "thana" },
            { "MA", "M\u0259rake\u015f" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Monteneqro" },
            { "MF", "Sent Martin" },
            { "lam", "lamba" },
            { "MG", "Madaqaskar" },
            { "Thai", metaValue_th },
            { "MH", "Mar\u015fal adalar\u0131" },
            { "ale", "aleut" },
            { "MK", "\u015eimali Makedoniya" },
            { "ML", "Mali" },
            { "MM", "Myanma" },
            { "MN", "Monqolustan" },
            { "new", "nevari" },
            { "MO", "Makao X\u0130R \u00c7in" },
            { "MP", "\u015eimali Marian adalar\u0131" },
            { "MQ", "Martinik" },
            { "MR", "Mavritaniya" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "MU", "Mavriki" },
            { "alt", "c\u0259nubi altay" },
            { "MV", "Maldiv adalar\u0131" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "type.ca.japanese", "Yapon T\u0259qvimi" },
            { "MY", "Malayziya" },
            { "MZ", "Mozambik" },
            { "Phli", "fli" },
            { "NA", "Namibiya" },
            { "202", "Saharadan c\u0259nub" },
            { "type.ca.hebrew", "Y\u0259hudi T\u0259qvimi" },
            { "NC", "Yeni Kaledoniya" },
            { "NE", "Niger" },
            { "NF", "Norfolk adas\u0131" },
            { "NG", "Nigeriya" },
            { "trv", "taroko" },
            { "Phlp", "flp" },
            { "NI", "Nikaraqua" },
            { "Hmng", "pahav monq" },
            { "NL", "Niderland" },
            { "NO", "Norve\u00e7" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "foenik" },
            { "rof", "rombo" },
            { "tsi", "sim\u015fyan" },
            { "NZ", "Yeni Zelandiya" },
            { "rom", "roman" },
            { "Mero", "meroytik" },
            { "crh", "kr\u0131m t\u00fcrkc\u0259si" },
            { "ang", "q\u0259dim ingilis" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "Sey\u015fel kreol frans\u0131zcas\u0131" },
            { "Xpeo", "q\u0259dimi fars" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Ivrit t\u0259qvimi" },
            { "csb", "ka\u015fubyan" },
            { "en_GB", "Britaniya ingilisc\u0259si" },
            { "PE", "Peru" },
            { "PF", "Fransa Polineziyas\u0131" },
            { "PG", "Papua-Yeni Qvineya" },
            { "PH", "Filippin" },
            { "PK", "Pakistan" },
            { "PL", "Pol\u015fa" },
            { "ewo", "evondo" },
            { "PM", "M\u00fcq\u0259dd\u0259s Pyer v\u0259 Mikelon" },
            { "PN", "Pitkern adalar\u0131" },
            { "PR", "Puerto Riko" },
            { "Bali", metaValue_ban },
            { "PS", "F\u0259l\u0259stin \u018frazil\u0259ri" },
            { "PT", "Portuqaliya" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "Ki\u00e7ik Yunan R\u0259q\u0259ml\u0259ri" },
            { "PY", "Paraqvay" },
            { "tum", "tumbuka" },
            { "Hebr", "ibrani" },
            { "QA", "Q\u0259t\u0259r" },
            { "niu", "niyuan" },
            { "QO", "Uzaq Okeaniya" },
            { "lez", "l\u0259zgi" },
            { "tvl", "tuvalu" },
            { "Tavt", "tavt" },
            { "001", "D\u00fcnya" },
            { "002", "Afrika" },
            { "003", "\u015eimali Amerika" },
            { "RE", "Reyunyon" },
            { "005", "C\u0259nubi Amerika" },
            { "jbo", "lo\u011fban" },
            { "Rjng", "rec\u0259ng" },
            { "009", "Okeaniya" },
            { "RO", "Rum\u0131niya" },
            { "RS", "Serbiya" },
            { "RU", "Rusiya" },
            { "RW", "Ruanda" },
            { "Ugar", metaValue_uga },
            { "Mani", "mani\u00e7ayen" },
            { "Khar", "xaro\u015fti" },
            { "SA", "S\u0259udiyy\u0259 \u018fr\u0259bistan\u0131" },
            { "pon", "ponpey" },
            { "Mand", "mandayen" },
            { "SB", "Solomon adalar\u0131" },
            { "twq", "tasavaq" },
            { "011", "Q\u0259rbi Afrika" },
            { "SC", "Sey\u015fel adalar\u0131" },
            { "SD", "Sudan" },
            { "013", "M\u0259rk\u0259zi Amerika" },
            { "SE", "\u0130sve\u00e7" },
            { "014", "\u015e\u0259rqi Afrika" },
            { "arc", "aramik" },
            { "015", "\u015eimali Afrika" },
            { "SG", "Sinqapur" },
            { "SH", "M\u00fcq\u0259dd\u0259s Yelena" },
            { "type.lb.strict", "S\u0259rt s\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "017", "M\u0259rk\u0259zi Afrika" },
            { "SI", "Sloveniya" },
            { "018", "C\u0259nubi Afrika" },
            { "SJ", "Svalbard v\u0259 Yan-Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakiya" },
            { "SL", "Syerra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Seneqal" },
            { "SO", "Somali" },
            { "arn", "mapu\u00e7e" },
            { "arp", "arapaho" },
            { "type.nu.taml", "\u018fn\u0259n\u0259vi Tamil R\u0259q\u0259ml\u0259ri" },
            { "SR", "Surinam" },
            { "SS", "C\u0259nubi Sudan" },
            { "ST", "San-Tome v\u0259 Prinsipi" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Suriya" },
            { "yao", "yao" },
            { "SZ", "Esvatini" },
            { "arw", "aravak" },
            { "yap", "yapiz" },
            { "TA", "Tristan da Kunya" },
            { "asa", "asu" },
            { "type.ms.ussystem", "AB\u015e \u00d6l\u00e7\u00fc Sistemi" },
            { "021", "\u015eimal Amerikas\u0131" },
            { "TC", "T\u00f6rks v\u0259 Kaykos adalar\u0131" },
            { "yav", "yanqben" },
            { "TD", "\u00c7ad" },
            { "TF", "Fransan\u0131n C\u0259nub \u018frazil\u0259ri" },
            { "TG", "Toqo" },
            { "TH", "Tailand" },
            { "TJ", "Tacikistan" },
            { "029", "Karib" },
            { "TK", "Tokelau" },
            { "TL", "\u015e\u0259rqi Timor" },
            { "ybb", "yemba" },
            { "TM", "T\u00fcrkm\u0259nistan" },
            { "TN", "Tunis" },
            { "TO", "Tonqa" },
            { "TR", "T\u00fcrkiy\u0259" },
            { "TT", "Trinidad v\u0259 Tobaqo" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "ast", "asturiya" },
            { "Orkh", "orxon" },
            { "TZ", "Tanzaniya" },
            { "nmg", "kvasio" },
            { "Zzzz", "tan\u0131nmayan yaz\u0131" },
            { "UA", "Ukrayna" },
            { "rup", "aroman" },
            { "030", "\u015e\u0259rqi Asiya" },
            { "tyv", "tuvinyan" },
            { "sw_CD", "Konqo suahilic\u0259si" },
            { "034", "C\u0259nubi Asiya" },
            { "hai", "hayda" },
            { "035", "C\u0259nub-\u015e\u0259rqi Asiya" },
            { "UG", "Uqanda" },
            { "hak", "hakka" },
            { "type.co.pinyin", "Pinyin t\u0259qvimi" },
            { "039", "C\u0259nubi Avropa" },
            { "Sinh", "sinhal" },
            { "UM", "AB\u015e-a ba\u011fl\u0131 ki\u00e7ik adac\u0131qlar" },
            { "UN", "Birl\u0259\u015fmi\u015f Mill\u0259tl\u0259r T\u0259\u015fkilat\u0131" },
            { "US", "Amerika Birl\u0259\u015fmi\u015f \u015etatlar\u0131" },
            { "haw", "havay" },
            { "UY", "Uruqvay" },
            { "prg", "pruss" },
            { "UZ", "\u00d6zb\u0259kistan" },
            { "tzm", "M\u0259rk\u0259zi Atlas tamazic\u0259si" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikan" },
            { "pro", "q\u0259dim provansal" },
            { "VC", "Sent-Vinsent v\u0259 Qrenadinl\u0259r" },
            { "VE", "Venesuela" },
            { "VG", "Britaniyan\u0131n Virgin adalar\u0131" },
            { "VI", "AB\u015e Virgin adalar\u0131" },
            { "VN", "Vyetnam" },
            { "VU", "Vanuatu" },
            { "nog", "noqay" },
            { "rwk", "rua" },
            { "non", "q\u0259dim nors" },
            { "053", "Avstralaziya" },
            { "054", "Melaneziya" },
            { "WF", "Uollis v\u0259 Futuna" },
            { "057", "Mikroneziya Regionu" },
            { "jgo", "nqomba" },
            { "lkt", "lakota" },
            { "wae", "valles" },
            { "WS", "Samoa" },
            { "wal", "valamo" },
            { "was", "va\u015fo" },
            { "XA", "Psevdo-Aksent" },
            { "war", "varay" },
            { "XB", "Psevdo-Bidi" },
            { "awa", "avadhi" },
            { "061", "Polineziya" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "yaz\u0131s\u0131z" },
            { "Olck", "ol \u00e7iki" },
            { "wbp", "valpiri" },
            { "Batk", "batak" },
            { "Blis", "blissymbols" },
            { "YE", "Y\u0259m\u0259n" },
            { "type.co.standard", "Standart S\u0131ralama" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "Sgnw", "i\u015far\u0259t yaz\u0131s\u0131" },
            { "YT", "Mayot" },
            { "ZA", "C\u0259nub Afrika" },
            { "type.lb.loose", "S\u0259rb\u0259st s\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "Deva", "devanaqari" },
            { "type.nu.geor", "G\u00fcrc\u00fc R\u0259q\u0259ml\u0259ri" },
            { "Hira", "iraqana" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Nam\u0259lum Region" },
            { "Runr", "runik" },
            { "type.ms.metric", "Metrik Sistem" },
            { "type.ca.iso8601", "ISO-8601 T\u0259qvimi" },
            { "lol", "monqo" },
            { "nso", "\u015fimal soto" },
            { "type.nu.telu", "Teluqu R\u0259q\u0259ml\u0259ri" },
            { "loz", "lozi" },
            { "jmc", "ma\u00e7am" },
            { "type.nu.hansfin", "Sad\u0259l\u0259\u015fmi\u015f \u00c7in Maliyy\u0259 R\u0259q\u0259ml\u0259ri" },
            { "hil", "hiliqaynon" },
            { "type.nu.arabext", "Geni\u015fl\u0259nmi\u015f \u018fr\u0259b-Hind R\u0259q\u0259ml\u0259ri" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "Tam Geni\u015f R\u0259q\u0259ml\u0259r" },
            { "hit", "hittit" },
            { "dar", "darqva" },
            { "dav", "taita" },
            { "Maya", "maya hiyeroqlifi" },
            { "lrc", "\u015fimali luri" },
            { "Copt", "koptik" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandave" },
            { "type.nu.roman", "Rum R\u0259q\u0259ml\u0259ri" },
            { "sah", "saxa" },
            { "sam", metaValue_sam },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santal" },
            { "Tfng", "tifinaq" },
            { "jpr", "ivrit-fars" },
            { "sba", "nqambay" },
            { "Guru", "qurmuxi" },
            { "lua", "luba-lulua" },
            { "sbp", "sanqu" },
            { "lui", "luyseno" },
            { "nyn", "nyankol" },
            { "nym", "nyamvezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippin" },
            { "hmn", "monq" },
            { "del", "delaver" },
            { "lus", "mizo" },
            { "bal", "baluc" },
            { "den", "slavey" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "luy", "luyia" },
            { "bas", "basa" },
            { "jrb", "ivrit-\u0259r\u0259b" },
            { "es_ES", "Kastiliya ispancas\u0131" },
            { "nzi", "nzima" },
            { "sco", "skots" },
            { "scn", "siciliya" },
            { "aa", "afar" },
            { "ab", "abxaz" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhar" },
            { "Arab", metaValue_ar },
            { "an", "araqon" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "hecal\u0131 yapon \u0259lifbas\u0131" },
            { "as", "assam" },
            { "av", "avar" },
            { "sdh", "c\u0259nubi k\u00fcrd" },
            { "ay", "aymara" },
            { "az", "az\u0259rbaycan" },
            { "ba", "ba\u015fq\u0131rd" },
            { "be", "belarus" },
            { "bg", "bolqar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "doqrib" },
            { "br", "breton" },
            { "bs", "bosniya" },
            { "Mymr", "myanmar" },
            { "type.nu.laoo", "Lao R\u0259q\u0259ml\u0259ri" },
            { "seh", "sena" },
            { "Nkoo", "nko" },
            { "sel", "selkup" },
            { "ca", "katalan" },
            { "ses", "koyraboro senni" },
            { "ce", "\u00e7e\u00e7en" },
            { "ch", "\u00e7amoro" },
            { "co", "korsika" },
            { "Orya", "oriya" },
            { "cr", "kri" },
            { "cs", "\u00e7ex" },
            { "cu", "slavyan" },
            { "cv", "\u00e7uva\u015f" },
            { "cy", "uels" },
            { "type.nu.ethi", "Efiop R\u0259q\u0259ml\u0259ri" },
            { "Yiii", "yi" },
            { "da", "danimarka" },
            { "pt_PT", "Portuqaliya portuqalcas\u0131" },
            { "de", "alman" },
            { "type.cf.standard", "Standart Valyuta Format\u0131" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", "buqin" },
            { "bem", "bemba" },
            { "sga", "q\u0259dim irland" },
            { "dv", "maldiv" },
            { "es_419", "Lat\u0131n Amerikas\u0131 ispancas\u0131" },
            { "dz", "dzonqxa" },
            { "bez", "bena" },
            { "type.ca.chinese", "\u00c7in T\u0259qvimi" },
            { "dje", "zarma" },
            { "type.nu.grek", "Yunan R\u0259q\u0259ml\u0259ri" },
            { "ee", "eve" },
            { "type.lb.normal", "Normal s\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "ro_MD", "moldav" },
            { "el", metaValue_el },
            { "en", "ingilis" },
            { "eo", "esperanto" },
            { "es", "ispan" },
            { "et", "eston" },
            { "Hanb", "hanb" },
            { "eu", "bask" },
            { "Buhd", "buhid" },
            { "Hang", "hanq\u0131l" },
            { "Samr", metaValue_sam },
            { "shi", "ta\u00e7elit" },
            { "hsb", "yuxar\u0131 sorb" },
            { "Hani", "han" },
            { "shn", "\u015fan" },
            { "Hano", "hanunu" },
            { "fa", "fars" },
            { "Hans", "sad\u0259l\u0259\u015fmi\u015f" },
            { "type.nu.latn", "Q\u0259rb R\u0259q\u0259ml\u0259ri" },
            { "Hant", "\u0259n\u0259n\u0259vi" },
            { "az_Arab", "c\u0259nubi az\u0259rbaycan" },
            { "ff", "fula" },
            { "hsn", "syan" },
            { "fi", "fin" },
            { "fj", "fici" },
            { "fon", "fon" },
            { "bgn", "q\u0259rbi b\u0259luc" },
            { "yue", "kanton" },
            { "fo", "farer" },
            { "umb", "umbundu" },
            { "fr", "frans\u0131z" },
            { "sid", "sidamo" },
            { "fy", "q\u0259rbi friz" },
            { "ga", "irland" },
            { "gd", "\u015eotlandiya keltc\u0259si" },
            { "gl", "qalisiya" },
            { "gn", "quarani" },
            { "bho", "bxo\u00e7puri" },
            { "und", "nam\u0259lum dil" },
            { "gu", metaValue_gu },
            { "gv", "manks" },
            { "ha", "hausa" },
            { "he", "ivrit" },
            { "hi", "hind" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "xorvat" },
            { "ht", "haiti kreol" },
            { "hu", "macar" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlinqua" },
            { "Jamo", "jamo" },
            { "id", "indoneziya" },
            { "type.nu.tibt", "Tibet R\u0259q\u0259ml\u0259ri" },
            { "ie", "interlinqve" },
            { "ig", "iqbo" },
            { "ii", "si\u00e7uan yi" },
            { "frm", "orta frans\u0131z" },
            { "ik", "inupiaq" },
            { "fro", "q\u0259dim frans\u0131z" },
            { "io", "ido" },
            { "frr", "\u015fimali fris" },
            { "is", "island" },
            { "it", "italyan" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "sarati" },
            { "doi", "doqri" },
            { "sma", "c\u0259nubi sami" },
            { "jv", "yava" },
            { "Shaw", "\u015favyan" },
            { "mad", "maduriz" },
            { "smj", "lule sami" },
            { "mag", "maqahi" },
            { "mai", "maitili" },
            { "smn", "inari sami" },
            { "ka", metaValue_ka },
            { "bla", "siksik\u0259" },
            { "mak", "makasar" },
            { "wuu", "vu" },
            { "sms", "skolt sami" },
            { "man", "m\u0259ndinqo" },
            { "kg", "konqo" },
            { "Goth", "qotik" },
            { "ki", "kikuyu" },
            { "mas", "masay" },
            { "kj", "kuanyama" },
            { "kk", "qazax" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "k\u0259\u015fmir" },
            { "Cirt", "sirt" },
            { "Lepc", "lep\u00e7\u0259" },
            { "Avst", metaValue_ae },
            { "ku", "k\u00fcrd" },
            { "kv", "komi" },
            { "kw", "korn" },
            { "ky", "q\u0131r\u011f\u0131z" },
            { "snk", "soninke" },
            { "la", metaValue_la },
            { "lb", "l\u00fcksemburq" },
            { "type.nu.mlym", "Malayalam R\u0259q\u0259ml\u0259ri" },
            { "lg", "qanda" },
            { "Roro", "ronqoronqo" },
            { "li", "limburq" },
            { "Tibt", metaValue_bo },
            { "ln", "linqala" },
            { "fur", "friul" },
            { "lo", "laos" },
            { "type.ms.uksystem", "\u0130mperial \u00d6l\u00e7\u00fc Sistemi" },
            { "lt", "litva" },
            { "lu", "luba-katanqa" },
            { "lv", "lat\u0131\u015f" },
            { "sog", "soqdiyen" },
            { "mg", "malaqas" },
            { "mh", "mar\u015fal" },
            { "type.co.ducet", "Standart Unicode S\u0131ralama" },
            { "mi", "maori" },
            { "mk", "makedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malay" },
            { "mt", "malta" },
            { "my", "birman" },
            { "Saur", "saurastra" },
            { "Armn", metaValue_hy },
            { "mdf", "mok\u015fa" },
            { "dsb", "a\u015fa\u011f\u0131 sorb" },
            { "Armi", "armi" },
            { "na", "nauru" },
            { "type.co.search", "\u00dcmumi M\u0259qs\u0259dli Axtar\u0131\u015f" },
            { "nb", "bokmal norve\u00e7" },
            { "nd", "\u015fimali ndebele" },
            { "ne", "nepal" },
            { "ng", "ndonqa" },
            { "mdr", "mandar" },
            { "nl", "holland" },
            { "nn", "n\u00fcnorsk norve\u00e7" },
            { "no", "norve\u00e7" },
            { "nr", "c\u0259nubi ndebele" },
            { "nv", "navayo" },
            { "kaa", "qaraqalpaq" },
            { "ny", "nyanca" },
            { "kac", "ka\u00e7in" },
            { "kab", "kabile" },
            { "oc", "oksitan" },
            { "kaj", "ju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ocibva" },
            { "mer", "meru" },
            { "type.nu.armn", "Erm\u0259ni R\u0259q\u0259ml\u0259ri" },
            { "om", "oromo" },
            { "kaw", "kavi" },
            { "or", "odiya" },
            { "os", "osetin" },
            { "kbd", "kabarda-\u00e7\u0259rk\u0259z" },
            { "mfe", "morisien" },
            { "srn", "sranan tonqo" },
            { "pa", "p\u0259ncab" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "pi", "pali" },
            { "pl", "polyak" },
            { "dum", "orta holland" },
            { "type.ca.dangi", "Dangi T\u0259qvimi" },
            { "ps", "pu\u015ftu" },
            { "pt", "portuqal" },
            { "mga", "orta irland" },
            { "key.co", "S\u0131ralama" },
            { "pt_BR", "Braziliya portuqalcas\u0131" },
            { "kcg", "tiyap" },
            { "mgh", "maxuva-meetto" },
            { "key.cf", "Valyuta Format\u0131" },
            { "bra", "braj" },
            { "key.ca", "T\u0259qvim" },
            { "Laoo", "lao" },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "mgo", "meta\u2019" },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "ssy", "saho" },
            { "type.nu.mymr", "Myanma R\u0259q\u0259ml\u0259ri" },
            { "qu", "ke\u00e7ua" },
            { "zap", "zapotek" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makond" },
            { "Ethi", "efiop" },
            { "type.hc.h12", "12 Saatl\u0131q Sistem (0\u201312)" },
            { "type.hc.h11", "12 Saatl\u0131q Sistem (0\u201311)" },
            { "rm", "roman\u015f" },
            { "rn", "rundi" },
            { "key.cu", "Valyuta" },
            { "ro", "rum\u0131n" },
            { "type.nu.orya", "Oriya R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hanidec", "Onluq \u00c7in R\u0259q\u0259ml\u0259ri" },
            { "ru", "rus" },
            { "rw", "kinyarvanda" },
            { "zbl", "blisimbols" },
            { "kea", "kabuverdian" },
            { "mic", "mikmak" },
            { "suk", "sukuma" },
            { "en_AU", "Avstraliya ingilisc\u0259si" },
            { "sa", "sanskrit" },
            { "sc", "sardin" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "\u015fimali sami" },
            { "min", "minanqkaban" },
            { "sg", "sanqo" },
            { "sh", "serb-xorvat" },
            { "si", "sinhala" },
            { "sux", "sumeryan" },
            { "sk", "slovak" },
            { "sl", "sloven" },
            { "sm", "samoa" },
            { "sn", "\u015fona" },
            { "so", "somali" },
            { "type.nu.arab", "\u018fr\u0259b-Hind R\u0259q\u0259ml\u0259ri" },
            { "sq", "alban" },
            { "sr", "serb" },
            { "ss", "svati" },
            { "type.cf.account", "U\u00e7ot Valyuta Format\u0131" },
            { "st", "sesoto" },
            { "Java", "cava" },
            { "su", metaValue_su },
            { "sv", "isve\u00e7" },
            { "sw", "suahili" },
            { "type.nu.hantfin", "\u018fn\u0259n\u0259vi \u00c7in Maliyy\u0259 R\u0259q\u0259ml\u0259ri" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asiya" },
            { "bua", "buryat" },
            { "143", "M\u0259rk\u0259zi Asiya" },
            { "te", metaValue_te },
            { "145", "Q\u0259rbi Asiya" },
            { "tg", "tacik" },
            { "th", metaValue_th },
            { "ti", "tiqrin" },
            { "bug", "bugin" },
            { "kfo", "koro" },
            { "en_CA", "Kanada ingilisc\u0259si" },
            { "tk", "t\u00fcrkm\u0259n" },
            { "tl", metaValue_tl },
            { "tn", "svana" },
            { "to", "tonqa" },
            { "dyo", "diola" },
            { "type.nu.jpan", "Yapon R\u0259q\u0259ml\u0259ri" },
            { "tr", "t\u00fcrk" },
            { "ts", "sonqa" },
            { "swb", "komor" },
            { "Cakm", "kakm" },
            { "tt", "tatar" },
            { "dyu", "dyula" },
            { "tw", "tvi" },
            { "ty", "taxiti" },
            { "150", "Avropa" },
            { "151", "\u015e\u0259rqi Avropa" },
            { "154", "\u015eimali Avropa" },
            { "dzg", "dazaqa" },
            { "155", "Q\u0259rbi Avropa" },
            { "ug", "uy\u011fur" },
            { "Kore", metaValue_ko },
            { "Ital", "q\u0259dimi italyal\u0131" },
            { "Zyyy", "\u00fcmumi yaz\u0131" },
            { "uk", "ukrayna" },
            { "ur", "urdu" },
            { "xal", "kalm\u0131k" },
            { "zen", "zenaqa" },
            { "uz", "\u00f6zb\u0259k" },
            { "kha", "xazi" },
            { "nds_NL", "a\u015fa\u011f\u0131 sakson" },
            { "Sylo", "siloti n\u0259qri" },
            { "ve", "venda" },
            { "type.ca.roc", "Minquo T\u0259qvimi" },
            { "vi", "vyetnam" },
            { "kho", "xotan" },
            { "khq", "koyra \u00e7iini" },
            { "key.hc", "Saat Sikli (12 / 24)" },
            { "vo", "volap\u00fck" },
            { "Osma", "osmanya" },
            { "quc", "ki\u00e7e" },
            { "gaa", "qa" },
            { "wa", "valun" },
            { "gag", "qaqauz" },
            { "syr", "suriya" },
            { "Grek", metaValue_el },
            { "gan", "qan" },
            { "Lydi", "ludian" },
            { "Xsux", "sumer-akadyan kuneyform" },
            { "wo", "volof" },
            { "zgh", "tamazi" },
            { "ar_001", "m\u00fcasir standart \u0259r\u0259b" },
            { "Cans", "birl\u0259\u015fmi\u015f kanada yerli yaz\u0131s\u0131" },
            { "gay", "qayo" },
            { "Mong", metaValue_mn },
            { "mnc", "man\u00e7u" },
            { "Latf", "fraktur lat\u0131n\u0131" },
            { "gba", "qabaya" },
            { "mni", "manip\u00fcri" },
            { "Latn", metaValue_la },
            { "Latg", "gael lat\u0131n\u0131" },
            { "type.nu.hans", "Sad\u0259l\u0259\u015fmi\u015f \u00c7in R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hant", "\u018fn\u0259n\u0259vi \u00c7in R\u0259q\u0259ml\u0259ri" },
            { "xh", "xosa" },
            { "type.nu.romanlow", "Ki\u00e7ik Rum R\u0259q\u0259ml\u0259ri" },
            { "byn", "blin" },
            { "Lyci", "lusian" },
            { "osa", "osage" },
            { "Moon", "mun" },
            { "moh", "mohavk" },
            { "kkj", "kako" },
            { "yi", "idi\u015f" },
            { "mos", "mosi" },
            { "Syrc", "siryak" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "es_MX", "Meksika ispancas\u0131" },
            { "ota", "osman" },
            { "Syre", "estrangela s\u00fcryanice" },
            { "vai", "vai" },
            { "za", "\u00e7juan" },
            { "Cari", "kariyan" },
            { "kln", "kalencin" },
            { "zh", "\u00e7in" },
            { "Bopo", "bopomofo" },
            { "Perm", "q\u0259dimi permik" },
            { "key.lb", "S\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "zu", "zulu" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "Yapon Maliyy\u0259 R\u0259q\u0259ml\u0259ri" },
            { "Cham", "\u00e7am" },
            { "gez", "qez" },
            { "Tglg", metaValue_tl },
            { "Egyd", "misir demotik" },
            { "Egyh", "misir hiyeratik" },
            { "ebu", "embu" },
            { "Egyp", "misir hiyeroqlif" },
            { "Geok", "g\u00fcrc\u00fc xutsuri" },
            { "zh_Hans", "sad\u0259l\u0259\u015fmi\u015f \u00e7in" },
            { "koi", "komi-permyak" },
            { "Hung", "q\u0259dimi macar" },
            { "kok", "konkani" },
            { "kos", "kosreyan" },
            { "zh_Hant", "\u0259n\u0259n\u0259vi \u00e7in" },
            { "Sund", metaValue_su },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "Kxmer R\u0259q\u0259ml\u0259ri" },
            { "ilo", "iloko" },
            { "Cprt", "kipr" },
            { "mua", "mundanq" },
            { "type.nu.guru", "Qurmuxi R\u0259q\u0259ml\u0259ri" },
            { "mul", "\u00e7oxsayl\u0131 dill\u0259r" },
            { "cad", "keddo" },
            { "key.ms", "\u00d6l\u00e7\u00fc Sistemi" },
            { "mus", "krik" },
            { "Glag", "qlaqolitik" },
            { "gil", "qilbert" },
            { "Cher", "\u00e7iroki" },
            { "car", "karib" },
            { "type.nu.tamldec", "Tamil R\u0259q\u0259ml\u0259ri" },
            { "krc", "qara\u00e7ay-balkar" },
            { "inh", "inqu\u015f" },
            { "fa_AF", "dari" },
            { "krl", "karel" },
            { "efi", "efik" },
            { "key.nu", "R\u0259q\u0259ml\u0259r" },
            { "kru", "kurux" },
            { "ksb", "\u015fambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
