/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ProfilePanel;
import ca.sqlpower.architect.swingui.table.FreqValueCountTableModel;
import ca.sqlpower.architect.swingui.table.FreqValueTable;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.swingui.TimedDocumentListener;
import ca.sqlpower.swingui.table.TableModelSortDecorator;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class ProfileGraphPanel {
    private JLabel rowCountDisplay;
    private JLabel title;
    private JLabel nullableLabel;
    private JLabel minValue;
    private JLabel maxValue;
    private JLabel avgValue;
    private JLabel nullCountLabel;
    private JLabel nullPercentLabel;
    private JLabel minLengthLabel;
    private JLabel uniqueCountLabel;
    private JLabel uniquePercentLabel;
    private JLabel maxLengthLabel;
    private FreqValueTable freqValueTable;
    private JScrollPane freqValueSp;
    private final JPanel displayArea;
    private final JPanel validResultsPanel;
    private final JPanel invalidResultsPanel;
    private JLabel invalidResultsLabel;
    private int rowCount;
    private ChartPanel chartPanel;
    private static final Logger logger = Logger.getLogger(ProfileGraphPanel.class);
    private JTextArea notesField;
    private TimedDocumentListener notesFieldListener;
    private SPListener notesListener;
    private final ProfilePanel profilePanel;
    private ColumnProfileResult columnProfileResult;

    public ProfileGraphPanel(ProfilePanel panel, int rowCount) {
        this.profilePanel = panel;
        this.rowCount = rowCount;
        FormLayout displayLayout = new FormLayout("4dlu, default, 4dlu, 100dlu, 4dlu, fill:default:grow, 4dlu", "4dlu, default, 6dlu");
        CellConstraints cc = new CellConstraints();
        this.validResultsPanel = logger.isDebugEnabled() ? new FormDebugPanel(displayLayout) : new JPanel((LayoutManager)displayLayout);
        this.validResultsPanel.setBorder(BorderFactory.createEtchedBorder());
        Font bodyFont = this.validResultsPanel.getFont();
        Font titleFont = bodyFont.deriveFont(1, (float)bodyFont.getSize() * 1.25f);
        this.title = new JLabel("Column Name");
        this.title.setFont(titleFont);
        PanelBuilder pb = new PanelBuilder(displayLayout, this.validResultsPanel);
        pb.add((Component)this.title, cc.xyw(2, 2, 5));
        int row = 4;
        this.rowCountDisplay = this.makeInfoRow(pb, "RowCount", row);
        this.nullableLabel = this.makeInfoRow(pb, "Nullable", row += 2);
        this.nullCountLabel = this.makeInfoRow(pb, "Null Count", row += 2);
        this.nullPercentLabel = this.makeInfoRow(pb, "% Null Records", row += 2);
        this.minLengthLabel = this.makeInfoRow(pb, "Minimum Length", row += 2);
        this.maxLengthLabel = this.makeInfoRow(pb, "Maximum Length", row += 2);
        this.uniqueCountLabel = this.makeInfoRow(pb, "Unique Values", row += 2);
        this.uniquePercentLabel = this.makeInfoRow(pb, "% Unique", row += 2);
        this.minValue = this.makeInfoRow(pb, "Minimum Value", row += 2);
        this.maxValue = this.makeInfoRow(pb, "Maximum Value", row += 2);
        this.avgValue = this.makeInfoRow(pb, "Average Value", row += 2);
        this.freqValueTable = new FreqValueTable(null);
        this.freqValueSp = new JScrollPane(this.freqValueTable);
        pb.appendRow("fill:10dlu:grow");
        pb.appendRow("fill:default:grow");
        pb.add((Component)this.freqValueSp, cc.xyw(2, (row += 2) + 1, 3));
        JFreeChart createPieChart = ChartFactory.createPieChart((String)"", (PieDataset)new DefaultPieDataset((KeyedValues)new DefaultKeyedValues()), (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(createPieChart);
        this.chartPanel.setPreferredSize(new Dimension(300, 300));
        if (panel.getProfileManager().getWorkspaceContainer() instanceof ArchitectSession && ((ArchitectSession)panel.getProfileManager().getWorkspaceContainer()).isEnterpriseSession()) {
            pb.add((Component)new JLabel("Column Profile Notes"), cc.xy(6, 2));
            this.notesField = new JTextArea();
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
            JScrollPane notesScroll = new JScrollPane(this.notesField);
            notesScroll.setHorizontalScrollBarPolicy(31);
            notesScroll.setVerticalScrollBarPolicy(22);
            pb.add((Component)notesScroll, cc.xywh(6, 4, 1, row - 4));
            pb.appendRow("fill:4dlu:grow");
            pb.appendRow("4dlu");
            pb.add((Component)this.chartPanel, cc.xy(6, row + 1));
        } else {
            pb.appendRow("fill:4dlu:grow");
            pb.appendRow("4dlu");
            pb.add((Component)this.chartPanel, cc.xywh(6, 4, 1, row - 2));
        }
        this.invalidResultsPanel = new JPanel(new BorderLayout());
        this.invalidResultsLabel = new JLabel("No error message yet");
        this.invalidResultsPanel.add(this.invalidResultsLabel);
        this.displayArea = new JPanel(new GridLayout(1, 1));
        this.displayArea.setPreferredSize(this.validResultsPanel.getPreferredSize());
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public JPanel getDisplayArea() {
        return this.displayArea;
    }

    public void displayProfile(final ColumnProfileResult cr) {
        this.columnProfileResult = cr;
        this.displayArea.removeAll();
        if (cr.getException() != null) {
            this.displayInvalidProfile(cr);
            this.displayArea.add(this.invalidResultsPanel);
        } else {
            this.displayValidProfile(cr);
            this.displayArea.add(this.validResultsPanel);
        }
        if (this.notesField != null) {
            if (this.notesFieldListener != null) {
                this.notesField.getDocument().removeDocumentListener((DocumentListener)this.notesFieldListener);
                this.notesFieldListener.cancel();
            }
            this.columnProfileResult.removeSPListener(this.notesListener);
            this.notesField.setText(cr.getNotes());
            this.notesListener = new AbstractSPListener(){

                public void propertyChanged(PropertyChangeEvent evt) {
                    if ("notes".equals(evt.getPropertyName()) && !evt.getNewValue().equals(ProfileGraphPanel.this.notesField.getText())) {
                        ProfileGraphPanel.this.notesField.setText((String)evt.getNewValue());
                    }
                }
            };
            cr.addSPListener(this.notesListener);
            this.notesFieldListener = new TimedDocumentListener(((SQLColumn)cr.getProfiledObject()).getName(), 2500L){

                public void textChanged() {
                    final String notesText = ProfileGraphPanel.this.notesField.getText();
                    ProfileGraphPanel.this.profilePanel.getProfileManager().getRunnableDispatcher().runInForeground(new Runnable(){

                        @Override
                        public void run() {
                            cr.setNotes(notesText);
                        }
                    });
                }
            };
            this.notesField.getDocument().addDocumentListener((DocumentListener)this.notesFieldListener);
        }
        this.displayArea.revalidate();
        this.displayArea.repaint();
    }

    private void displayInvalidProfile(ColumnProfileResult cr) {
        JDBCDataSource ds;
        SQLDatabase parentDB;
        SQLColumn profiledColumn = (SQLColumn)cr.getProfiledObject();
        String databaseType = null;
        if (profiledColumn.getParent() != null && (parentDB = profiledColumn.getParent().getParentDatabase()) != null && (ds = parentDB.getDataSource()) != null) {
            JDBCDataSourceType parentType = ds.getParentType();
            databaseType = parentType.getName();
        }
        String advice = "";
        if (databaseType != null) {
            advice = "You may be able to rectify this situation by visiting the JDBC Drivers configuration panel for " + databaseType + " and modifying the set of profile " + "functions to attempt for type " + profiledColumn.getTypeName() + ".";
        }
        this.invalidResultsLabel.setText("<html> <table width=100% height=100%>  <tr>   <td>    <h2>Profiler was unable to create a profile for column <i>" + profiledColumn.getName() + "</i></h2>" + "    <p>" + cr.getException() + "    <p><p>" + advice + "   </td>" + "  </tr>" + " </table>" + "</html>");
        this.notesField.setText(cr.getNotes());
    }

    private void displayValidProfile(ColumnProfileResult cr) {
        TableProfileResult tr = cr.getParent();
        this.rowCount = tr.getRowCount();
        this.rowCountDisplay.setText(Integer.toString(this.rowCount));
        StringBuffer sb = new StringBuffer();
        SQLColumn c = (SQLColumn)cr.getProfiledObject();
        sb.append(c);
        if (c.isPrimaryKey()) {
            sb.append(' ').append("[PK]");
        }
        this.setTitle(sb.toString());
        this.nullableLabel.setText(Boolean.toString(c.isDefinitelyNullable()));
        this.chartPanel.setChart(ProfileGraphPanel.createTopNChart(cr, this.rowCount));
        this.nullCountLabel.setText(Integer.toString(cr.getNullCount()));
        int nullsInRecords = cr.getNullCount();
        double ratio = this.rowCount > 0 ? (double)nullsInRecords * 100.0 / (double)this.rowCount : 0.0;
        this.nullPercentLabel.setText(this.format(ratio));
        this.uniqueCountLabel.setText(Integer.toString(cr.getDistinctValueCount()));
        double uniqueRatio = this.rowCount > 0 ? (double)cr.getDistinctValueCount() * 100.0 / (double)this.rowCount : 0.0;
        this.uniquePercentLabel.setText(this.format(uniqueRatio));
        this.minLengthLabel.setText(Integer.toString(cr.getMinLength()));
        this.maxLengthLabel.setText(Integer.toString(cr.getMaxLength()));
        this.minValue.setText(cr.getMinValue() == null ? "" : cr.getMinValue().toString());
        this.maxValue.setText(cr.getMaxValue() == null ? "" : cr.getMaxValue().toString());
        Object o = cr.getAvgValue();
        if (o == null) {
            this.avgValue.setText("");
        } else if (o instanceof BigDecimal) {
            double d = ((BigDecimal)o).doubleValue();
            this.avgValue.setText(this.format(d));
        } else {
            ProfilePanel.logger.debug((Object)("Got avgValue of type: " + o.getClass().getName()));
            this.avgValue.setText(cr.getAvgValue().toString());
        }
        if (this.notesField != null) {
            // empty if block
        }
        FreqValueCountTableModel freqValueCountTableModel = new FreqValueCountTableModel(cr);
        TableModelSortDecorator sortModel = new TableModelSortDecorator((TableModel)freqValueCountTableModel);
        sortModel.setColumnComparator(freqValueCountTableModel.getColumnClass(2), (Comparator)new ColumnValueCount.ColumnValueComparator());
        this.freqValueTable.setModel((TableModel)sortModel);
        sortModel.setTableHeader(this.freqValueTable.getTableHeader());
        this.freqValueTable.initColumnSizes();
    }

    public static JFreeChart createTopNChart(ColumnProfileResult cr, int rowCount) {
        String chartTitle;
        JFreeChart chart;
        List<ColumnValueCount> valueCounts = cr.getValueCount();
        SQLColumn col = (SQLColumn)cr.getProfiledObject();
        DefaultCategoryDataset catDataset = new DefaultCategoryDataset();
        long otherDataCount = rowCount;
        for (ColumnValueCount vc : valueCounts) {
            catDataset.addValue((double)vc.getCount(), (Comparable)((Object)col.getName()), (Comparable)((Object)(vc.getValue() == null ? "null" : vc.getValue().toString())));
            otherDataCount -= (long)vc.getCount();
        }
        int numberOfTopValues = catDataset.getColumnCount();
        if (otherDataCount > 0L) {
            catDataset.addValue((double)otherDataCount, (Comparable)((Object)col.getName()), (Comparable)((Object)"Other Values"));
        }
        if ((chart = ChartFactory.createPieChart((String)(chartTitle = numberOfTopValues == 10 ? "Top " + numberOfTopValues + " most common values" : "All " + numberOfTopValues + " values"), (PieDataset)new CategoryToPieDataset((CategoryDataset)catDataset, TableOrder.BY_ROW, 0), (boolean)false, (boolean)true, (boolean)false)).getPlot() instanceof PiePlot) {
            ((PiePlot)chart.getPlot()).setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} [{1}]"));
        }
        return chart;
    }

    private String format(double d) {
        return String.format("%6.2f", d);
    }

    private JLabel makeInfoRow(PanelBuilder pb, String title, int row) {
        CellConstraints cc = new CellConstraints();
        pb.appendRow("default");
        pb.appendRow("2dlu");
        pb.add((Component)new JLabel(title), cc.xy(2, row));
        JLabel label = new JLabel("--");
        pb.add((Component)label, cc.xy(4, row));
        return label;
    }

    public void close() {
        if (this.notesFieldListener != null) {
            this.notesFieldListener.cancel();
        }
    }
}

