/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.ArchitectSessionContext;
import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContextImpl;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionImpl;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.enterprise.SecurityPanel;
import ca.sqlpower.enterprise.AbstractNetworkConflictResolver;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServerProjectsManagerPanel {
    private final Component dialogOwner;
    private final ArchitectSessionContext context;
    private final ArchitectSwingSession session;
    private final JPanel panel;
    private final Action closeAction;
    private final JList projects;
    private final JList servers;
    private final Action refreshAction = new AbstractAction("Refresh"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerProjectsManagerPanel.this.refreshInfoList();
        }
    };
    private final Action newAction = new AbstractAction("New..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            String name;
            if (ServerProjectsManagerPanel.this.getSelectedServerInfo() != null && (name = JOptionPane.showInputDialog(ServerProjectsManagerPanel.this.dialogOwner, "Please specify the name of your project", "", 3)) != null) {
                DefaultListModel model = (DefaultListModel)ServerProjectsManagerPanel.this.projects.getModel();
                for (int i = 0; i < model.size(); ++i) {
                    if (!((ProjectLocation)model.getElementAt(i)).getName().trim().equalsIgnoreCase(name.trim())) continue;
                    JOptionPane.showMessageDialog(ServerProjectsManagerPanel.this.dialogOwner, "A project called \"" + name + "\" already exists. Please use a different name.", "Duplicate project name", 0);
                    return;
                }
                try {
                    ArchitectFrame frame = ServerProjectsManagerPanel.this.session.getArchitectFrame();
                    JLabel messageLabel = new JLabel("Creating New Project");
                    JProgressBar progressBar = new JProgressBar();
                    progressBar.setIndeterminate(true);
                    JDialog dialog = new JDialog((Frame)frame, "Creating New Project");
                    DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref"));
                    builder.setDefaultDialogBorder();
                    builder.append((Component)messageLabel, 3);
                    builder.nextLine();
                    builder.append((Component)progressBar, 3);
                    dialog.add(builder.getPanel());
                    dialog.setSize(new Dimension(300, 90));
                    dialog.setLocation(frame.getX() + (frame.getWidth() - dialog.getWidth()) / 2, frame.getY() + (frame.getHeight() - dialog.getHeight()) / 2);
                    dialog.setAlwaysOnTop(true);
                    dialog.setVisible(true);
                    ArchitectClientSideSession.createNewServerSession(ServerProjectsManagerPanel.this.getSelectedServerInfo(), name, ServerProjectsManagerPanel.this.session);
                    dialog.dispose();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to create new project", ex);
                }
                ServerProjectsManagerPanel.this.refreshInfoList();
            }
        }
    };
    private final Action openAction = new AbstractAction("Open"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices;
            if (ServerProjectsManagerPanel.this.getSelectedServerInfo() != null && (indices = ServerProjectsManagerPanel.this.projects.getSelectedIndices()).length >= 1) {
                Object[] objs = new Object[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    objs[i] = ServerProjectsManagerPanel.this.projects.getModel().getElementAt(indices[i]);
                }
                for (Object obj : objs) {
                    if (!(obj instanceof ProjectLocation)) continue;
                    ProjectLocation location = (ProjectLocation)obj;
                    try {
                        ArchitectSwingSession newSession = ((ArchitectSwingSessionContextImpl)ServerProjectsManagerPanel.this.context).createServerSession(location, false);
                        ArchitectFrame frame = ServerProjectsManagerPanel.this.session.getArchitectFrame();
                        frame.addSession(newSession);
                        frame.setCurrentSession(newSession);
                        JLabel messageLabel = new JLabel("Opening");
                        JProgressBar progressBar = new JProgressBar();
                        progressBar.setIndeterminate(true);
                        final JDialog dialog = new JDialog((Frame)frame, "Opening");
                        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref"));
                        builder.setDefaultDialogBorder();
                        builder.append((Component)messageLabel, 3);
                        builder.nextLine();
                        builder.append((Component)progressBar, 3);
                        dialog.add(builder.getPanel());
                        dialog.pack();
                        dialog.setLocation(frame.getX() + (frame.getWidth() - dialog.getWidth()) / 2, frame.getY() + (frame.getHeight() - dialog.getHeight()) / 2);
                        dialog.setAlwaysOnTop(true);
                        dialog.setVisible(true);
                        ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)newSession).getDelegateSession()).getUpdater().addListener(new AbstractNetworkConflictResolver.UpdateListener(){

                            public boolean updatePerformed(AbstractNetworkConflictResolver resolver) {
                                dialog.dispose();
                                return true;
                            }

                            public boolean updateException(AbstractNetworkConflictResolver resolver, Throwable t) {
                                return false;
                            }

                            public void preUpdatePerformed(AbstractNetworkConflictResolver resolver) {
                            }

                            public void workspaceDeleted() {
                                ServerProjectsManagerPanel.this.refreshInfoList();
                            }
                        });
                        ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)newSession).getDelegateSession()).startUpdaterThread();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Unable to open project", ex);
                    }
                }
                ServerProjectsManagerPanel.this.closeAction.actionPerformed(e);
            }
        }
    };
    private final Action uploadAction = new AbstractAction("Upload"){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(ServerProjectsManagerPanel.this.dialogOwner), "Upload Project", Dialog.ModalityType.DOCUMENT_MODAL);
            JPanel panel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, pref, 4dlu, max(150dlu;pref), 4dlu, pref, 4dlu", "pref, pref, pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout, panel);
            CellConstraints cc = new CellConstraints();
            final JTextField nameField = new JTextField();
            builder.add((Component)new JLabel("Name"), cc.xy(2, 1));
            builder.add((Component)nameField, cc.xyw(4, 1, 3));
            final JTextField fileField = new JTextField();
            JButton fileButton = new JButton("...");
            fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(ServerProjectsManagerPanel.this.session.getProjectLoader().getFile());
                    chooser.addChoosableFileFilter(SPSUtils.ARCHITECT_FILE_FILTER);
                    chooser.setDialogTitle(Messages.getString("Choose Project to Upload"));
                    int response = chooser.showOpenDialog(dialog);
                    if (response != 0) {
                        return;
                    }
                    fileField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            });
            builder.add((Component)new JLabel("File"), cc.xy(2, 2));
            builder.add((Component)fileField, cc.xy(4, 2));
            builder.add((Component)fileButton, cc.xy(6, 2));
            final JButton okButton = new JButton("Upload");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = new File(fileField.getText());
                    if (!f.canRead()) {
                        JOptionPane.showMessageDialog(ServerProjectsManagerPanel.this.dialogOwner, "File cannot be read", "Invalid File", 0);
                        return;
                    }
                    try {
                        ArchitectClientSideSession.uploadProject(ServerProjectsManagerPanel.this.getSelectedServerInfo(), nameField.getText(), f, ServerProjectsManagerPanel.this.session);
                        dialog.dispose();
                        ServerProjectsManagerPanel.this.refreshInfoList();
                    }
                    catch (Exception ex) {
                        SPSUtils.showExceptionDialogNoReport((Component)dialog, (String)"Unable to upload project", (Throwable)ex);
                    }
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            });
            okButton.setEnabled(false);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged(e);
                }

                private void textChanged(DocumentEvent e) {
                    okButton.setEnabled(!fileField.getText().isEmpty() && !nameField.getText().isEmpty());
                }
            };
            fileField.getDocument().addDocumentListener(documentListener);
            nameField.getDocument().addDocumentListener(documentListener);
            JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)okButton, (JButton)cancelButton);
            builder.add((Component)buttonBar, cc.xyw(2, 3, 5));
            dialog.add(panel);
            SPSUtils.makeJDialogCancellable((Window)dialog, null);
            dialog.pack();
            dialog.setLocationRelativeTo(ServerProjectsManagerPanel.this.dialogOwner);
            dialog.setVisible(true);
        }
    };
    private final Action deleteAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices;
            if (ServerProjectsManagerPanel.this.getSelectedServerInfo() != null && (indices = ServerProjectsManagerPanel.this.projects.getSelectedIndices()).length >= 1) {
                Object[] objs = new Object[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    objs[i] = ServerProjectsManagerPanel.this.projects.getModel().getElementAt(indices[i]);
                }
                String promptMessage = indices.length == 1 ? "Are you sure you want to delete the selected project?\nThis action cannot be undone." : "Are you sure you want to delete these " + indices.length + " selected projects?" + "\nThis action cannot be undone.";
                if (JOptionPane.showConfirmDialog(ServerProjectsManagerPanel.this.dialogOwner, promptMessage, "Confirm Delete Projects", 0, 2) == 0) {
                    for (Object obj : objs) {
                        if (!(obj instanceof ProjectLocation)) continue;
                        ProjectLocation location = (ProjectLocation)obj;
                        try {
                            ArchitectClientSideSession.deleteServerWorkspace(location, ServerProjectsManagerPanel.this.session);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Unable to delete project", ex);
                        }
                    }
                    ServerProjectsManagerPanel.this.refreshInfoList();
                }
            }
        }
    };
    private final Action openSecurityManagerPanelAction = new AbstractAction("Security"){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)ServerProjectsManagerPanel.this.dialogOwner, (String)"Security Manager");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            SecurityPanel spm = new SecurityPanel(ServerProjectsManagerPanel.this.getSelectedServerInfo(), closeAction, d, ServerProjectsManagerPanel.this.session);
            d.setDefaultCloseOperation(2);
            d.setContentPane(spm.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(ServerProjectsManagerPanel.this.dialogOwner);
            d.setVisible(true);
        }
    };
    private boolean connected = false;
    private SPServerInfo serverInfo = null;

    public ServerProjectsManagerPanel(SPServerInfo serverInfo, ArchitectSwingSession session, ArchitectSessionContext context, Component dialogOwner, Action closeAction) {
        this.serverInfo = serverInfo;
        this.dialogOwner = dialogOwner;
        this.session = session;
        this.context = context;
        this.closeAction = closeAction;
        ArchitectClientSideSession.getCookieStore().clear();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref", "pref, pref, pref"));
        this.servers = null;
        this.projects = new JList(new DefaultListModel());
        this.projects.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ServerProjectsManagerPanel.this.refreshPanel();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ServerProjectsManagerPanel.this.openAction.actionPerformed(null);
                }
            }
        });
        JScrollPane projectsPane = new JScrollPane(this.projects);
        projectsPane.setPreferredSize(new Dimension(250, 300));
        JButton securityButton = new JButton(this.openSecurityManagerPanelAction);
        this.refreshInfoList();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JLabel(serverInfo.getName() + "'s projects:"), cc.xyw(1, 1, 2));
        builder.nextLine();
        builder.add((Component)projectsPane, cc.xywh(1, 2, 1, 2));
        DefaultFormBuilder buttonBarBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        buttonBarBuilder.append((Component)new JButton(this.refreshAction));
        buttonBarBuilder.append((Component)securityButton);
        buttonBarBuilder.append((Component)new JButton(this.newAction));
        buttonBarBuilder.append((Component)new JButton(this.openAction));
        buttonBarBuilder.append((Component)new JButton(this.deleteAction));
        buttonBarBuilder.append((Component)new JButton(closeAction));
        builder.add((Component)buttonBarBuilder.getPanel(), cc.xy(3, 2));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
    }

    public ServerProjectsManagerPanel(ArchitectSwingSession session, ArchitectSessionContext context, Component dialogOwner, Action closeAction) {
        this.session = session;
        this.dialogOwner = dialogOwner;
        this.context = context;
        this.closeAction = closeAction;
        ArchitectClientSideSession.getCookieStore().clear();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref:grow, 5dlu, pref", "pref, pref, pref"));
        this.servers = new JList(new DefaultListModel());
        this.servers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ServerProjectsManagerPanel.this.refreshInfoList();
                }
            }
        });
        DefaultListModel serversModel = (DefaultListModel)this.servers.getModel();
        serversModel.removeAllElements();
        if (context.getServerManager().getServers(false).size() > 0) {
            for (SPServerInfo serverInfo : context.getServerManager().getServers(false)) {
                serversModel.addElement(serverInfo);
            }
        } else {
            serversModel.addElement("No Servers");
            this.servers.setEnabled(false);
        }
        this.projects = new JList(new DefaultListModel());
        this.projects.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ServerProjectsManagerPanel.this.refreshPanel();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ServerProjectsManagerPanel.this.openAction.actionPerformed(null);
                }
            }
        });
        JScrollPane projectsPane = new JScrollPane(this.projects);
        projectsPane.setPreferredSize(new Dimension(250, 300));
        JScrollPane serverPane = new JScrollPane(this.servers);
        serverPane.setPreferredSize(new Dimension(250, 300));
        JButton securityButton = new JButton(this.openSecurityManagerPanelAction);
        this.refreshInfoList();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JLabel("Servers:"), cc.xyw(1, 1, 2));
        builder.add((Component)new JLabel("Projects:"), cc.xyw(3, 1, 2));
        builder.nextLine();
        builder.add((Component)serverPane, cc.xywh(1, 2, 1, 2));
        builder.add((Component)projectsPane, cc.xywh(3, 2, 1, 2));
        DefaultFormBuilder buttonBarBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        buttonBarBuilder.append((Component)new JButton(this.refreshAction));
        buttonBarBuilder.append((Component)securityButton);
        buttonBarBuilder.append((Component)new JButton(this.newAction));
        buttonBarBuilder.append((Component)new JButton(this.openAction));
        buttonBarBuilder.append((Component)new JButton(this.uploadAction));
        buttonBarBuilder.append((Component)new JButton(this.deleteAction));
        buttonBarBuilder.append((Component)new JButton(closeAction));
        builder.add((Component)buttonBarBuilder.getPanel(), cc.xy(5, 2));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void refreshPanel() {
        if (this.connected) {
            this.openSecurityManagerPanelAction.setEnabled(true);
            this.newAction.setEnabled(true);
            this.uploadAction.setEnabled(true);
            if (this.projects.isSelectionEmpty()) {
                this.openAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
            } else {
                this.openAction.setEnabled(true);
                this.deleteAction.setEnabled(true);
            }
            this.projects.setEnabled(true);
        } else {
            this.openSecurityManagerPanelAction.setEnabled(false);
            this.newAction.setEnabled(false);
            this.openAction.setEnabled(false);
            this.uploadAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.projects.setEnabled(false);
        }
    }

    private void refreshInfoList() {
        DefaultListModel model = (DefaultListModel)this.projects.getModel();
        model.removeAllElements();
        SPServerInfo serviceInfo = this.getSelectedServerInfo();
        if (serviceInfo != null) {
            try {
                ((ArchitectSwingSessionContextImpl)this.session.getContext()).createSecuritySession(serviceInfo);
                List<ProjectLocation> projects = ArchitectClientSideSession.getWorkspaceNames(serviceInfo, this.session);
                Collections.sort(projects, new Comparator<ProjectLocation>(){

                    @Override
                    public int compare(ProjectLocation proj1, ProjectLocation proj2) {
                        return proj1.getName().compareToIgnoreCase(proj2.getName());
                    }
                });
                model.clear();
                for (ProjectLocation pl : projects) {
                    model.addElement(pl);
                }
                this.connected = true;
            }
            catch (Exception ex) {
                model.removeAllElements();
                model.addElement("Unable to get projects from server");
                this.connected = false;
                this.session.createUserPrompter("Server Unavailable", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, "OK", new String[]{"OK"}).promptUser(new Object[]{""});
            }
            this.refreshPanel();
        } else {
            model.addElement("No Server Selected");
            this.connected = false;
            this.refreshPanel();
        }
    }

    private SPServerInfo getSelectedServerInfo() {
        Object obj;
        if (this.serverInfo != null) {
            return this.serverInfo;
        }
        int index = this.servers.getSelectedIndex();
        if (index >= 0 && (obj = this.servers.getModel().getElementAt(index)) instanceof SPServerInfo) {
            return (SPServerInfo)obj;
        }
        return null;
    }
}

