/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServerResultSetMetaDataDecorator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLServerResultSetDecorator
extends ResultSetDecorator {
    public static final Logger logger = Logger.getLogger(SQLServerResultSetDecorator.class);

    public SQLServerResultSetDecorator(Statement parentStatement, ResultSet rs) {
        super(parentStatement, rs);
    }

    @Override
    protected ResultSetMetaData makeResultSetMetaDataDecorator(ResultSetMetaData rsmd) {
        return new SQLServerResultSetMetaDataDecorator(rsmd);
    }

    @Override
    public boolean first() throws SQLException {
        ResultSetDecorator.checkInterrupted();
        try {
            return this.resultSet.first();
        }
        catch (NullPointerException npe) {
            logger.debug((Object)"NullPointerException (due to permissions [hopefully]) squished in call to 'first'");
            return false;
        }
    }

    @Override
    public boolean last() throws SQLException {
        ResultSetDecorator.checkInterrupted();
        try {
            return this.resultSet.last();
        }
        catch (NullPointerException npe) {
            logger.debug((Object)"NullPointerException (due to permissions [hopefully]) squished in call to 'last'");
            return false;
        }
    }

    @Override
    public boolean next() throws SQLException {
        ResultSetDecorator.checkInterrupted();
        try {
            return this.resultSet.next();
        }
        catch (NullPointerException npe) {
            logger.debug((Object)"NullPointerException (due to permissions [hopefully]) squished in call to 'next'");
            return false;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        ResultSetDecorator.checkInterrupted();
        try {
            return this.resultSet.previous();
        }
        catch (NullPointerException npe) {
            logger.debug((Object)"NullPointerException (due to permissions [hopefully]) squished in call to 'previous'");
            return false;
        }
    }
}

